/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Functions;
import hudson.security.AccessControlled;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.matrixauth.AuthorizationContainer;
import org.jenkinsci.plugins.matrixauth.AuthorizationType;
import org.jenkinsci.plugins.matrixauth.Messages;
import org.jenkinsci.plugins.matrixauth.PermissionEntry;
import org.jenkinsci.plugins.matrixauth.ValidationUtil;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public interface AuthorizationContainerDescriptor {
    public PermissionScope getPermissionScope();

    @Restricted(value={DoNotUse.class})
    default public String getDescription(Permission p) {
        String description = p.description == null ? "" : p.description.toString();
        Permission impliedBy = p.impliedBy;
        while (impliedBy != null && impliedBy.group == PermissionGroup.get(Permission.class) && impliedBy.impliedBy != null) {
            impliedBy = impliedBy.impliedBy;
        }
        if (p != Jenkins.ADMINISTER) {
            if (impliedBy == null) {
                if (description.length() > 0) {
                    description = description + "<br/><br/>";
                }
                description = description + Messages.GlobalMatrixAuthorizationStrategy_PermissionNotImpliedBy();
            } else if (impliedBy != Jenkins.ADMINISTER) {
                if (description.length() > 0) {
                    description = description + "<br/><br/>";
                }
                description = description + Messages.GlobalMatrixAuthorizationStrategy_PermissionImpliedBy(impliedBy.group.title, impliedBy.name);
            }
        }
        return description;
    }

    @Restricted(value={DoNotUse.class})
    default public List<PermissionGroup> getAllGroups() {
        ArrayList<PermissionGroup> groups = new ArrayList<PermissionGroup>();
        block0: for (PermissionGroup group : PermissionGroup.getAll()) {
            if (group == PermissionGroup.get(Permission.class) || !group.hasPermissionContainedBy(this.getPermissionScope())) continue;
            for (Permission p : group.getPermissions()) {
                if (!p.getEnabled()) continue;
                groups.add(group);
                continue block0;
            }
        }
        return groups;
    }

    @Restricted(value={NoExternalUse.class})
    default public String impliedByList(Permission p) {
        ArrayList<Permission> impliedBys = new ArrayList<Permission>();
        while (p.impliedBy != null) {
            p = p.impliedBy;
            impliedBys.add(p);
        }
        return StringUtils.join((Collection)impliedBys.stream().map(Permission::getId).collect(Collectors.toList()), (String)" ");
    }

    @Restricted(value={DoNotUse.class})
    default public boolean showPermission(Permission p) {
        if (!p.getEnabled()) {
            return false;
        }
        if (!p.isContainedBy(this.getPermissionScope())) {
            return false;
        }
        return !GlobalMatrixAuthorizationStrategy.DANGEROUS_PERMISSIONS.contains(p);
    }

    @Restricted(value={DoNotUse.class})
    default public boolean hasAmbiguousEntries(AuthorizationContainer container) {
        if (container == null) {
            return false;
        }
        return container.getAllPermissionEntries().stream().anyMatch(e -> e.getType() == AuthorizationType.EITHER);
    }

    @Restricted(value={DoNotUse.class})
    default public PermissionEntry entryFor(String type, String sid) {
        if (type == null) {
            return null;
        }
        return new PermissionEntry(AuthorizationType.valueOf(type), sid);
    }

    @Restricted(value={DoNotUse.class})
    default public String getTypeLabel(String type) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (type == null) {
            return "__TYPE__";
        }
        return Messages.class.getMethod("TypeLabel_" + type, new Class[0]).invoke(null, new Object[0]).toString();
    }

    @Restricted(value={NoExternalUse.class})
    default public FormValidation doCheckName_(@NonNull String value, @NonNull AccessControlled subject, @NonNull Permission permission) {
        AuthorizationType type;
        String unbracketedValue = value.substring(1, value.length() - 1);
        int splitIndex = unbracketedValue.indexOf(58);
        if (splitIndex < 0) {
            return FormValidation.error((String)("No type prefix: " + unbracketedValue));
        }
        String typeString = unbracketedValue.substring(0, splitIndex);
        try {
            type = AuthorizationType.valueOf(typeString);
        }
        catch (Exception ex) {
            return FormValidation.error((String)("Invalid type prefix: " + unbracketedValue));
        }
        String sid = unbracketedValue.substring(splitIndex + 1);
        String escapedSid = Functions.escape((String)sid);
        if (!subject.hasPermission(permission)) {
            if (type == AuthorizationType.USER) {
                return FormValidation.okWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse("person", escapedSid, "User may or may not exist"));
            }
            if (type == AuthorizationType.GROUP) {
                return FormValidation.okWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse("user", escapedSid, "Group may or may not exist"));
            }
            return FormValidation.warningWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse(null, escapedSid, "Permissions would be granted to a user or group of this name"));
        }
        SecurityRealm sr = Jenkins.get().getSecurityRealm();
        if (sid.equals("authenticated") && type == AuthorizationType.EITHER) {
            return FormValidation.warningWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse("user", escapedSid, "Internal group found; but permissions would also be granted to a user of this name"));
        }
        if (sid.equals("anonymous") && type == AuthorizationType.EITHER) {
            return FormValidation.warningWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse("person", escapedSid, "Internal user found; but permissions would also be granted to a group of this name"));
        }
        try {
            switch (type) {
                case GROUP: {
                    FormValidation groupValidation = ValidationUtil.validateGroup(sid, sr, false);
                    if (groupValidation != null) {
                        return groupValidation;
                    }
                    return FormValidation.errorWithMarkup((String)ValidationUtil.formatNonExistentUserGroupValidationResponse(escapedSid, "Group not found"));
                }
                case USER: {
                    FormValidation userValidation = ValidationUtil.validateUser(sid, sr, false);
                    if (userValidation != null) {
                        return userValidation;
                    }
                    return FormValidation.errorWithMarkup((String)ValidationUtil.formatNonExistentUserGroupValidationResponse(escapedSid, "User not found"));
                }
                case EITHER: {
                    FormValidation userValidation = ValidationUtil.validateUser(sid, sr, true);
                    if (userValidation != null) {
                        return userValidation;
                    }
                    FormValidation groupValidation = ValidationUtil.validateGroup(sid, sr, true);
                    if (groupValidation != null) {
                        return groupValidation;
                    }
                    return FormValidation.errorWithMarkup((String)ValidationUtil.formatNonExistentUserGroupValidationResponse(escapedSid, "User or group not found"));
                }
            }
            return FormValidation.error((String)("Unexpected type: " + (Object)((Object)type)));
        }
        catch (Exception e) {
            return FormValidation.error((Throwable)e, (String)escapedSid);
        }
    }
}

