/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.security.Permission;
import hudson.util.RobustReflectionConverter;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.matrixauth.AuthorizationContainer;
import org.jenkinsci.plugins.matrixauth.PermissionEntry;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class AbstractAuthorizationContainerConverter<T extends AuthorizationContainer>
implements Converter {
    public abstract boolean canConvert(Class var1);

    public abstract T create();

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        AuthorizationContainer.PermissionEntryComparator comparator = new AuthorizationContainer.PermissionEntryComparator();
        if (!this.canConvert(source.getClass())) {
            throw new IllegalArgumentException("cannot marshal object of type " + source.getClass());
        }
        AuthorizationContainer container = (AuthorizationContainer)source;
        TreeMap<Permission, Set<PermissionEntry>> sortedPermissions = new TreeMap<Permission, Set<PermissionEntry>>(Permission.ID_COMPARATOR);
        sortedPermissions.putAll(container.getGrantedPermissionEntries());
        for (Map.Entry e : sortedPermissions.entrySet()) {
            String p = ((Permission)e.getKey()).getId();
            TreeSet<PermissionEntry> entries = new TreeSet<PermissionEntry>(comparator);
            entries.addAll((Collection)e.getValue());
            for (PermissionEntry entry : entries) {
                writer.startNode("permission");
                writer.setValue(entry.getType().toPrefix() + p + ':' + entry.getSid());
                writer.endNode();
            }
        }
    }

    protected void unmarshalContainer(T container, HierarchicalStreamReader reader, UnmarshallingContext context) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            try {
                container.add(reader.getValue());
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(AbstractAuthorizationContainerConverter.class.getName()).log(Level.WARNING, "Skipping a non-existent permission", ex);
                RobustReflectionConverter.addErrorInContext((UnmarshallingContext)context, (Throwable)ex);
            }
            reader.moveUp();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        T container = this.create();
        this.unmarshalContainer(container, reader, context);
        return container;
    }
}

