/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.User;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import hudson.security.SidACL;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.model.NodeListener;
import net.sf.json.JSONObject;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.jenkinsci.plugins.matrixauth.AbstractAuthorizationPropertyConverter;
import org.jenkinsci.plugins.matrixauth.AuthorizationProperty;
import org.jenkinsci.plugins.matrixauth.AuthorizationPropertyDescriptor;
import org.jenkinsci.plugins.matrixauth.Messages;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritGlobalStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AuthorizationMatrixNodeProperty
extends NodeProperty<Node>
implements AuthorizationProperty {
    private final transient SidACL acl = new AclImpl();
    private final Map<Permission, Set<String>> grantedPermissions = new HashMap<Permission, Set<String>>();
    private final Set<String> sids = new HashSet<String>();
    @Deprecated
    private transient Boolean blocksInheritance;
    private InheritanceStrategy inheritanceStrategy = new InheritGlobalStrategy();
    private static final Logger LOGGER = Logger.getLogger(AuthorizationMatrixNodeProperty.class.getName());

    private AuthorizationMatrixNodeProperty() {
    }

    public AuthorizationMatrixNodeProperty(Map<Permission, Set<String>> grantedPermissions) {
        for (Map.Entry<Permission, Set<String>> e : grantedPermissions.entrySet()) {
            this.grantedPermissions.put(e.getKey(), new HashSet(e.getValue()));
        }
    }

    @Restricted(value={NoExternalUse.class})
    public Set<String> getGroups() {
        return new HashSet<String>(this.sids);
    }

    @Override
    public Map<Permission, Set<String>> getGrantedPermissions() {
        return Collections.unmodifiableMap(this.grantedPermissions);
    }

    @Override
    public void setInheritanceStrategy(InheritanceStrategy inheritanceStrategy) {
        this.inheritanceStrategy = inheritanceStrategy;
    }

    @Override
    public InheritanceStrategy getInheritanceStrategy() {
        return this.inheritanceStrategy;
    }

    @Override
    public void add(Permission p, String sid) {
        Set<String> set = this.grantedPermissions.get(p);
        if (set == null) {
            set = new HashSet<String>();
            this.grantedPermissions.put(p, set);
        }
        set.add(sid);
        this.sids.add(sid);
    }

    public SidACL getACL() {
        return this.acl;
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class NodeListenerImpl
    extends NodeListener {
        protected void onCreated(@Nonnull Node node) {
            AuthorizationStrategy authorizationStrategy = Jenkins.getInstance().getAuthorizationStrategy();
            if (authorizationStrategy instanceof ProjectMatrixAuthorizationStrategy) {
                User current;
                String sid;
                ProjectMatrixAuthorizationStrategy strategy = (ProjectMatrixAuthorizationStrategy)authorizationStrategy;
                AuthorizationMatrixNodeProperty prop = (AuthorizationMatrixNodeProperty)node.getNodeProperty(AuthorizationMatrixNodeProperty.class);
                if (prop == null) {
                    prop = new AuthorizationMatrixNodeProperty();
                }
                String string = sid = (current = User.current()) == null ? "anonymous" : current.getId();
                if (!strategy.getACL(node).hasPermission(Jenkins.getAuthentication(), Computer.CONFIGURE)) {
                    prop.add(Computer.CONFIGURE, sid);
                }
                if (prop.getGrantedPermissions().size() > 0) {
                    try {
                        node.getNodeProperties().replace((Describable)prop);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.WARNING, "Failed to grant creator permissions on node " + node.getDisplayName(), ex);
                    }
                }
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends NodePropertyDescriptor
    implements AuthorizationPropertyDescriptor<AuthorizationMatrixNodeProperty> {
        @Override
        @Restricted(value={NoExternalUse.class})
        public AuthorizationMatrixNodeProperty create() {
            return new AuthorizationMatrixNodeProperty();
        }

        @Override
        @Restricted(value={NoExternalUse.class})
        public PermissionScope getPermissionScope() {
            return PermissionScope.COMPUTER;
        }

        public AuthorizationMatrixNodeProperty newInstance(StaplerRequest req, @Nonnull JSONObject formData) throws Descriptor.FormException {
            return (AuthorizationMatrixNodeProperty)this.createNewInstance(req, formData, false);
        }

        public boolean isApplicable(Class<? extends Node> node) {
            return Node.class.isAssignableFrom(node) && this.isApplicable();
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.AuthorizationMatrixNodeProperty_DisplayName();
        }

        @Restricted(value={DoNotUse.class})
        public FormValidation doCheckName(@AncestorInPath Computer computer, @QueryParameter String value) {
            return this.doCheckName_(value, (AccessControlled)(computer == null ? Jenkins.getInstance() : computer), computer == null ? Jenkins.ADMINISTER : Computer.CONFIGURE);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class ConverterImpl
    extends AbstractAuthorizationPropertyConverter<AuthorizationMatrixNodeProperty> {
        @Override
        public boolean canConvert(Class type) {
            return type == AuthorizationMatrixNodeProperty.class;
        }

        @Override
        public AuthorizationMatrixNodeProperty create() {
            return new AuthorizationMatrixNodeProperty();
        }
    }

    private final class AclImpl
    extends SidACL {
        private AclImpl() {
        }

        @CheckForNull
        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="As designed, implements a third state for the ternary logic")
        protected Boolean hasPermission(Sid sid, Permission p) {
            if (AuthorizationMatrixNodeProperty.this.hasPermission(this.toString(sid), p, sid instanceof PrincipalSid)) {
                return true;
            }
            return null;
        }
    }
}

