/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth;

import hudson.Functions;
import hudson.Util;
import hudson.model.User;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.matrixauth.AuthorizationContainer;
import org.jenkinsci.plugins.matrixauth.Messages;
import org.jenkinsci.plugins.matrixauth.ValidationUtil;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.dao.DataAccessException;

@Restricted(value={NoExternalUse.class})
public interface AuthorizationContainerDescriptor<T extends AuthorizationContainer> {
    public PermissionScope getPermissionScope();

    @Restricted(value={DoNotUse.class})
    default public String getDescription(Permission p) {
        String description = p.description == null ? "" : p.description.toString();
        Permission impliedBy = p.impliedBy;
        while (impliedBy != null && impliedBy.group == PermissionGroup.get(Permission.class) && impliedBy.impliedBy != null) {
            impliedBy = impliedBy.impliedBy;
        }
        if (impliedBy == null) {
            if (description.length() > 0) {
                description = description + "<br/><br/>";
            }
            description = description + Messages.GlobalMatrixAuthorizationStrategy_PermissionNotImpliedBy();
        } else if (impliedBy != Jenkins.ADMINISTER) {
            if (description.length() > 0) {
                description = description + "<br/><br/>";
            }
            description = description + Messages.GlobalMatrixAuthorizationStrategy_PermissionImpliedBy(impliedBy.group.title, impliedBy.name);
        }
        return description;
    }

    @Restricted(value={DoNotUse.class})
    default public List<PermissionGroup> getAllGroups() {
        ArrayList<PermissionGroup> groups = new ArrayList<PermissionGroup>();
        block0: for (PermissionGroup group : PermissionGroup.getAll()) {
            if (group == PermissionGroup.get(Permission.class) || !group.hasPermissionContainedBy(this.getPermissionScope())) continue;
            for (Permission p : group.getPermissions()) {
                if (!p.getEnabled()) continue;
                groups.add(group);
                continue block0;
            }
        }
        return groups;
    }

    @Restricted(value={DoNotUse.class})
    default public boolean showPermission(Permission p) {
        if (!p.getEnabled()) {
            return false;
        }
        if (!p.isContainedBy(this.getPermissionScope())) {
            return false;
        }
        if (GlobalMatrixAuthorizationStrategy.ENABLE_DANGEROUS_PERMISSIONS || !GlobalMatrixAuthorizationStrategy.DANGEROUS_PERMISSIONS.contains(p)) {
            return true;
        }
        AuthorizationStrategy strategy = Jenkins.getInstance().getAuthorizationStrategy();
        if (strategy instanceof GlobalMatrixAuthorizationStrategy) {
            GlobalMatrixAuthorizationStrategy globalMatrixAuthorizationStrategy = (GlobalMatrixAuthorizationStrategy)strategy;
            return globalMatrixAuthorizationStrategy.isAnyRelevantDangerousPermissionExplicitlyGranted();
        }
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    default public FormValidation doCheckName_(@Nonnull String value, @Nonnull AccessControlled subject, @Nonnull Permission permission) {
        String v = value.substring(1, value.length() - 1);
        String ev = Functions.escape((String)v);
        if (!subject.hasPermission(permission)) {
            return FormValidation.ok((String)ev);
        }
        SecurityRealm sr = Jenkins.getInstance().getSecurityRealm();
        if (v.equals("authenticated")) {
            return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatUserGroupValidationResponse("user.png", ev, "Group", false));
        }
        try {
            try {
                sr.loadUserByUsername(v);
                User u = User.get((String)v);
                if (ev.equals(u.getFullName())) {
                    return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatUserGroupValidationResponse("person.png", ev, "User", false));
                }
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatUserGroupValidationResponse("person.png", Util.escape((String)StringUtils.abbreviate((String)u.getFullName(), (int)50)), "User " + ev, false));
            }
            catch (UserMayOrMayNotExistException e) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ev);
            }
            catch (UsernameNotFoundException | DataAccessException e) {
            }
            catch (AuthenticationException e) {
                return FormValidation.error((Throwable)e, (String)("Failed to test the validity of the user name " + v));
            }
            try {
                sr.loadGroupByGroupname(v);
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatUserGroupValidationResponse("user.png", ev, "Group", false));
            }
            catch (UserMayOrMayNotExistException e) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ev);
            }
            catch (UsernameNotFoundException | DataAccessException e) {
            }
            catch (AuthenticationException e) {
                return FormValidation.error((Throwable)e, (String)("Failed to test the validity of the group name " + v));
            }
            return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.ERROR, (String)ValidationUtil.formatNonExistentUserGroupValidationResponse(ev, "User or group not found"));
        }
        catch (Exception e) {
            return FormValidation.error((Throwable)e, (String)ev);
        }
    }
}

