/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Functions;
import hudson.PluginManager;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionAdder;
import hudson.security.PermissionGroup;
import hudson.security.SecurityRealm;
import hudson.security.SidACL;
import hudson.security.UserMayOrMayNotExistException;
import hudson.util.FormValidation;
import hudson.util.RobustReflectionConverter;
import hudson.util.VersionNumber;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.IdStrategy;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.jenkinsci.plugins.matrixauth.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.dao.DataAccessException;

public class GlobalMatrixAuthorizationStrategy
extends AuthorizationStrategy {
    private transient SidACL acl = new AclImpl();
    private final Map<Permission, Set<String>> grantedPermissions = new HashMap<Permission, Set<String>>();
    @Restricted(value={NoExternalUse.class})
    static final List<Permission> DANGEROUS_PERMISSIONS = Arrays.asList(Jenkins.RUN_SCRIPTS, PluginManager.CONFIGURE_UPDATECENTER, PluginManager.UPLOAD_PLUGINS);
    private final Set<String> sids = new HashSet<String>();
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger LOGGER = Logger.getLogger(GlobalMatrixAuthorizationStrategy.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    @Restricted(value={NoExternalUse.class})
    public static boolean ENABLE_DANGEROUS_PERMISSIONS = Boolean.getBoolean(GlobalMatrixAuthorizationStrategy.class.getName() + ".dangerousPermissions");

    public void add(Permission p, String sid) {
        if (p == null) {
            throw new IllegalArgumentException("Permission can not be null for sid:" + sid);
        }
        LOGGER.log(Level.FINE, "Grant permission \"{0}\" to \"{1}\")", new Object[]{p, sid});
        Set<String> set = this.grantedPermissions.get(p);
        if (set == null) {
            set = new HashSet<String>();
            this.grantedPermissions.put(p, set);
        }
        set.add(sid);
        this.sids.add(sid);
    }

    private void add(String shortForm) {
        int idx = shortForm.indexOf(58);
        Permission p = Permission.fromId((String)shortForm.substring(0, idx));
        if (p == null) {
            throw new IllegalArgumentException("Failed to parse '" + shortForm + "' --- no such permission");
        }
        this.add(p, shortForm.substring(idx + 1));
    }

    public ACL getRootACL() {
        return this.acl;
    }

    public Set<String> getGroups() {
        TreeSet<String> sids = new TreeSet<String>(new IdStrategyComparator());
        sids.addAll(this.sids);
        return sids;
    }

    static boolean migrateHudson2324(Map<Permission, Set<String>> grantedPermissions) {
        Set<String> f;
        boolean result = false;
        if (Jenkins.getActiveInstance().isUpgradedFromBefore(new VersionNumber("1.300.*")) && (f = grantedPermissions.get(Jenkins.READ)) != null) {
            Set<String> t = grantedPermissions.get(Item.READ);
            if (t != null) {
                result = t.addAll(f);
            } else {
                t = new HashSet<String>(f);
                result = true;
            }
            grantedPermissions.put(Item.READ, t);
        }
        return result;
    }

    public boolean hasPermission(String sid, Permission p) {
        if (!ENABLE_DANGEROUS_PERMISSIONS && DANGEROUS_PERMISSIONS.contains(p)) {
            return this.hasPermission(sid, Jenkins.ADMINISTER);
        }
        SecurityRealm securityRealm = Jenkins.getActiveInstance().getSecurityRealm();
        IdStrategy groupIdStrategy = securityRealm.getGroupIdStrategy();
        IdStrategy userIdStrategy = securityRealm.getUserIdStrategy();
        while (p != null) {
            Set<String> set;
            if (p.getEnabled() && (set = this.grantedPermissions.get(p)) != null) {
                if (set.contains(sid)) {
                    return true;
                }
                for (String s : set) {
                    if (!userIdStrategy.equals(s, sid) && !groupIdStrategy.equals(s, sid)) continue;
                    return true;
                }
            }
            p = p.impliedBy;
        }
        return false;
    }

    public boolean hasPermission(String sid, Permission p, boolean principal) {
        IdStrategy strategy;
        SecurityRealm securityRealm = Jenkins.getActiveInstance().getSecurityRealm();
        IdStrategy idStrategy = strategy = principal ? securityRealm.getUserIdStrategy() : securityRealm.getGroupIdStrategy();
        while (p != null) {
            if (p.getEnabled()) {
                Set<String> set = this.grantedPermissions.get(p);
                if (set != null && set.contains(sid)) {
                    return true;
                }
                if (set != null) {
                    for (String s : set) {
                        if (!strategy.equals(s, sid)) continue;
                        return true;
                    }
                }
            }
            p = p.impliedBy;
        }
        return false;
    }

    public boolean hasExplicitPermission(String sid, Permission p) {
        Set<String> set = this.grantedPermissions.get(p);
        if (set != null && p.getEnabled()) {
            if (set.contains(sid)) {
                return true;
            }
            SecurityRealm securityRealm = Jenkins.getActiveInstance().getSecurityRealm();
            IdStrategy groupIdStrategy = securityRealm.getGroupIdStrategy();
            IdStrategy userIdStrategy = securityRealm.getUserIdStrategy();
            for (String s : set) {
                if (!userIdStrategy.equals(s, sid) && !groupIdStrategy.equals(s, sid)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isAnyRelevantDangerousPermissionExplicitlyGranted() {
        for (String sid : this.getAllSIDs()) {
            if (!this.isAnyRelevantDangerousPermissionExplicitlyGranted(sid)) continue;
            return true;
        }
        return this.isAnyRelevantDangerousPermissionExplicitlyGranted("anonymous");
    }

    boolean isAnyRelevantDangerousPermissionExplicitlyGranted(String sid) {
        for (Permission p : DANGEROUS_PERMISSIONS) {
            if (this.hasPermission(sid, Jenkins.ADMINISTER) || !this.hasExplicitPermission(sid, p)) continue;
            return true;
        }
        return false;
    }

    public List<String> getAllSIDs() {
        TreeSet<String> r = new TreeSet<String>(new IdStrategyComparator());
        for (Set<String> set : this.grantedPermissions.values()) {
            r.addAll(set);
        }
        r.remove("anonymous");
        Object[] data = r.toArray(new String[r.size()]);
        Arrays.sort(data);
        return Arrays.asList(data);
    }

    @Extension
    public static final class PermissionAdderImpl
    extends PermissionAdder {
        public boolean add(AuthorizationStrategy strategy, User user, Permission perm) {
            if (strategy instanceof GlobalMatrixAuthorizationStrategy) {
                ((GlobalMatrixAuthorizationStrategy)strategy).add(perm, user.getId());
                return true;
            }
            return false;
        }
    }

    public static class DescriptorImpl
    extends Descriptor<AuthorizationStrategy> {
        protected DescriptorImpl(Class<? extends GlobalMatrixAuthorizationStrategy> clazz) {
            super(clazz);
        }

        public DescriptorImpl() {
        }

        public String getDisplayName() {
            return Messages.GlobalMatrixAuthorizationStrategy_DisplayName();
        }

        public AuthorizationStrategy newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            GlobalMatrixAuthorizationStrategy gmas = this.create();
            JSONObject data = formData.getJSONObject("data");
            for (Map.Entry r : data.entrySet()) {
                String sid = (String)r.getKey();
                if (!(r.getValue() instanceof JSONObject)) {
                    throw new Descriptor.FormException("not an object: " + formData, "data");
                }
                JSONObject value = (JSONObject)r.getValue();
                for (Map.Entry e : value.entrySet()) {
                    if (!(e.getValue() instanceof Boolean)) {
                        throw new Descriptor.FormException("not an boolean: " + formData, "data");
                    }
                    if (!((Boolean)e.getValue()).booleanValue()) continue;
                    Permission p = Permission.fromId((String)((String)e.getKey()));
                    if (p == null) {
                        LOGGER.log(Level.FINE, "Silently skip unknown permission \"{0}\" for sid:\"{1}\"", new Object[]{e.getKey(), sid});
                        continue;
                    }
                    gmas.add(p, sid);
                }
            }
            return gmas;
        }

        protected GlobalMatrixAuthorizationStrategy create() {
            return new GlobalMatrixAuthorizationStrategy();
        }

        public List<PermissionGroup> getAllGroups() {
            ArrayList<PermissionGroup> groups = new ArrayList<PermissionGroup>(PermissionGroup.getAll());
            groups.remove(PermissionGroup.get(Permission.class));
            return groups;
        }

        public boolean showPermission(Permission p) {
            if (!p.getEnabled()) {
                return false;
            }
            if (ENABLE_DANGEROUS_PERMISSIONS || !DANGEROUS_PERMISSIONS.contains(p)) {
                return true;
            }
            AuthorizationStrategy strategy = Jenkins.getActiveInstance().getAuthorizationStrategy();
            if (strategy instanceof GlobalMatrixAuthorizationStrategy) {
                GlobalMatrixAuthorizationStrategy globalMatrixAuthorizationStrategy = (GlobalMatrixAuthorizationStrategy)strategy;
                return globalMatrixAuthorizationStrategy.isAnyRelevantDangerousPermissionExplicitlyGranted();
            }
            return false;
        }

        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return FormValidation.error((String)"Jenkins instance is not ready. Cannot validate the field");
            }
            return this.doCheckName_(value, (AccessControlled)Jenkins.getActiveInstance(), Jenkins.ADMINISTER);
        }

        public FormValidation doCheckName_(@Nonnull String value, @Nonnull AccessControlled subject, @Nonnull Permission permission) throws IOException, ServletException {
            if (!subject.hasPermission(permission)) {
                return FormValidation.ok();
            }
            String v = value.substring(1, value.length() - 1);
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return FormValidation.error((String)"Jenkins instance is not ready. Cannot validate the field");
            }
            SecurityRealm sr = jenkins.getSecurityRealm();
            String ev = Functions.escape((String)v);
            if (v.equals("authenticated")) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)(this.makeImg("user.png", "Group", false) + ev));
            }
            try {
                try {
                    sr.loadUserByUsername(v);
                    return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)(this.makeImg("person.png", "User", false) + ev));
                }
                catch (UserMayOrMayNotExistException e) {
                    return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ev);
                }
                catch (UsernameNotFoundException e) {
                }
                catch (DataAccessException e) {
                }
                catch (AuthenticationException e) {
                    return FormValidation.error((Throwable)e, (String)("Failed to test the validity of the user name " + v));
                }
                try {
                    sr.loadGroupByGroupname(v);
                    return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)(this.makeImg("user.png", "Group", false) + ev));
                }
                catch (UserMayOrMayNotExistException e) {
                    return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ev);
                }
                catch (UsernameNotFoundException e) {
                }
                catch (DataAccessException e) {
                }
                catch (AuthenticationException e) {
                    return FormValidation.error((Throwable)e, (String)("Failed to test the validity of the group name " + v));
                }
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.ERROR, (String)(this.makeImg("user-disabled.png", "User or group not found", true) + this.formatNonexistentUser(ev)));
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)ev);
            }
        }

        private String formatNonexistentUser(String username) {
            return "<span style='text-decoration: line-through; color: grey;'>" + username + "</span>";
        }

        private String makeImg(String img, String tooltip, boolean inPlugin) {
            if (inPlugin) {
                return String.format("<img src='%s/plugin/matrix-auth/images/%s' title='%s' style='margin-right:0.2em'>", Stapler.getCurrentRequest().getContextPath(), img, tooltip);
            }
            return String.format("<img src='%s%s/images/16x16/%s' title='%s' style='margin-right:0.2em'>", Stapler.getCurrentRequest().getContextPath(), Jenkins.RESOURCE_PATH, img, tooltip);
        }
    }

    public static class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == GlobalMatrixAuthorizationStrategy.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            IdStrategyComparator comparator = new IdStrategyComparator();
            GlobalMatrixAuthorizationStrategy strategy = (GlobalMatrixAuthorizationStrategy)((Object)source);
            TreeMap sortedPermissions = new TreeMap(Permission.ID_COMPARATOR);
            sortedPermissions.putAll(strategy.grantedPermissions);
            for (Map.Entry e : sortedPermissions.entrySet()) {
                String p = ((Permission)e.getKey()).getId();
                TreeSet<String> sids = new TreeSet<String>(comparator);
                sids.addAll((Collection)e.getValue());
                for (String sid : sids) {
                    writer.startNode("permission");
                    writer.setValue(p + ':' + sid);
                    writer.endNode();
                }
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            GlobalMatrixAuthorizationStrategy as = this.create();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                try {
                    as.add(reader.getValue());
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(GlobalMatrixAuthorizationStrategy.class.getName()).log(Level.WARNING, "Skipping a non-existent permission", ex);
                    RobustReflectionConverter.addErrorInContext((UnmarshallingContext)context, (Throwable)ex);
                }
                reader.moveUp();
            }
            if (GlobalMatrixAuthorizationStrategy.migrateHudson2324(as.grantedPermissions)) {
                OldDataMonitor.report((UnmarshallingContext)context, (String)"1.301");
            }
            return as;
        }

        protected GlobalMatrixAuthorizationStrategy create() {
            return new GlobalMatrixAuthorizationStrategy();
        }
    }

    private final class AclImpl
    extends SidACL {
        private AclImpl() {
        }

        @CheckForNull
        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="As designed, implements a third state for the ternary logic")
        protected Boolean hasPermission(Sid p, Permission permission) {
            if (GlobalMatrixAuthorizationStrategy.this.hasPermission(this.toString(p), permission, p instanceof PrincipalSid)) {
                return true;
            }
            return null;
        }
    }

    static class IdStrategyComparator
    implements Comparator<String> {
        private final SecurityRealm securityRealm = Jenkins.getActiveInstance().getSecurityRealm();
        private final IdStrategy groupIdStrategy = this.securityRealm.getGroupIdStrategy();
        private final IdStrategy userIdStrategy = this.securityRealm.getUserIdStrategy();

        IdStrategyComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int r = this.userIdStrategy.compare(o1, o2);
            if (r == 0) {
                r = this.groupIdStrategy.compare(o1, o2);
            }
            return r;
        }
    }
}

