/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Restricted(value={DoNotUse.class})
public class DangerousMatrixPermissionsAdministrativeMonitor
extends AdministrativeMonitor {
    public boolean isActivated() {
        return !GlobalMatrixAuthorizationStrategy.ENABLE_DANGEROUS_PERMISSIONS && !this.getSidsWithDangerousPermissions().isEmpty();
    }

    @RequirePOST
    public HttpResponse doAct(@QueryParameter String yes) throws IOException {
        if (yes != null) {
            return HttpResponses.redirectViaContextPath((String)"configureSecurity");
        }
        return HttpResponses.redirectToDot();
    }

    public List<String> getSidsWithDangerousPermissions() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            return Collections.emptyList();
        }
        if (!(j.getAuthorizationStrategy() instanceof GlobalMatrixAuthorizationStrategy)) {
            return Collections.emptyList();
        }
        ArrayList<String> sids = new ArrayList<String>();
        GlobalMatrixAuthorizationStrategy strategy = (GlobalMatrixAuthorizationStrategy)j.getAuthorizationStrategy();
        ArrayList<String> allSidsPlusAnon = new ArrayList<String>(strategy.getAllSIDs());
        allSidsPlusAnon.add("anonymous");
        for (String sid : allSidsPlusAnon) {
            if (strategy.hasPermission(sid, Jenkins.ADMINISTER) || !strategy.isAnyRelevantDangerousPermissionExplicitlyGranted(sid)) continue;
            sids.add(sid);
        }
        return sids;
    }

    public String getDisplayName() {
        return "Matrix Authorization: Dangerous Permissions";
    }
}

