/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.MatlabBuild;
import com.mathworks.ci.Message;
import com.mathworks.ci.SelectByFolder;
import com.mathworks.ci.SourceFolder;
import com.mathworks.ci.SourceFolderPaths;
import com.mathworks.ci.TestFolders;
import com.mathworks.ci.Utilities;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class RunMatlabTestsBuilder
extends Builder
implements SimpleBuildStep,
MatlabBuild {
    private int buildResult;
    private transient boolean tapChkBx;
    private transient boolean junitChkBx;
    private transient boolean coberturaChkBx;
    private transient boolean stmResultsChkBx;
    private transient boolean modelCoverageChkBx;
    private transient boolean pdfReportChkBx;
    private Artifact tapArtifact = new NullArtifact();
    private Artifact junitArtifact = new NullArtifact();
    private Artifact coberturaArtifact = new NullArtifact();
    private Artifact stmResultsArtifact = new NullArtifact();
    private Artifact modelCoverageArtifact = new NullArtifact();
    private Artifact pdfReportArtifact = new NullArtifact();
    private SourceFolder sourceFolder;
    private SelectByFolder selectByFolder;
    private SelectByTag selectByTag;

    @DataBoundConstructor
    public RunMatlabTestsBuilder() {
    }

    @DataBoundSetter
    public void setTapArtifact(TapArtifact tapArtifact) {
        this.tapArtifact = tapArtifact;
    }

    @DataBoundSetter
    public void setJunitArtifact(JunitArtifact junitArtifact) {
        this.junitArtifact = junitArtifact;
    }

    @DataBoundSetter
    public void setCoberturaArtifact(CoberturaArtifact coberturaArtifact) {
        this.coberturaArtifact = coberturaArtifact;
    }

    @DataBoundSetter
    public void setStmResultsArtifact(StmResultsArtifact stmResultsArtifact) {
        this.stmResultsArtifact = stmResultsArtifact;
    }

    @DataBoundSetter
    public void setModelCoverageArtifact(ModelCovArtifact modelCoverageArtifact) {
        this.modelCoverageArtifact = modelCoverageArtifact;
    }

    @DataBoundSetter
    public void setPdfReportArtifact(PdfArtifact pdfReportArtifact) {
        this.pdfReportArtifact = pdfReportArtifact;
    }

    @DataBoundSetter
    public void setSelectByTag(SelectByTag selectByTag) {
        this.selectByTag = selectByTag;
    }

    @DataBoundSetter
    public void setSourceFolder(SourceFolder sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    @DataBoundSetter
    public void setSelectByFolder(SelectByFolder selectByFolder) {
        this.selectByFolder = selectByFolder;
    }

    public String getTapReportFilePath() {
        return this.getTapArtifact().getFilePath();
    }

    public Artifact getTapArtifact() {
        return this.tapArtifact;
    }

    public Artifact getJunitArtifact() {
        return this.junitArtifact;
    }

    public String getJunitReportFilePath() {
        return this.getJunitArtifact().getFilePath();
    }

    public Artifact getCoberturaArtifact() {
        return this.coberturaArtifact;
    }

    public String getCoberturaReportFilePath() {
        return this.getCoberturaArtifact().getFilePath();
    }

    public Artifact getStmResultsArtifact() {
        return this.stmResultsArtifact;
    }

    public String getStmResultsFilePath() {
        return this.getStmResultsArtifact().getFilePath();
    }

    public Artifact getModelCoverageArtifact() {
        return this.modelCoverageArtifact;
    }

    public String getModelCoverageFilePath() {
        return this.getModelCoverageArtifact().getFilePath();
    }

    public Artifact getPdfReportArtifact() {
        return this.pdfReportArtifact;
    }

    public String getPdfReportFilePath() {
        return this.getPdfReportArtifact().getFilePath();
    }

    public SelectByTag getSelectByTag() {
        return this.selectByTag;
    }

    public SourceFolder getSourceFolder() {
        return this.sourceFolder;
    }

    public SelectByFolder getSelectByFolder() {
        return this.selectByFolder;
    }

    private Artifact getArtifactObject(boolean isChecked, Artifact returnVal) {
        return isChecked ? returnVal : new NullArtifact();
    }

    protected Object readResolve() {
        this.pdfReportArtifact = Optional.ofNullable(this.pdfReportArtifact).orElseGet(() -> this.getArtifactObject(this.pdfReportChkBx, new PdfArtifact("matlabTestArtifacts/testreport.pdf")));
        this.tapArtifact = Optional.ofNullable(this.tapArtifact).orElseGet(() -> this.getArtifactObject(this.tapChkBx, new TapArtifact("matlabTestArtifacts/taptestresults.tap")));
        this.junitArtifact = Optional.ofNullable(this.junitArtifact).orElseGet(() -> this.getArtifactObject(this.junitChkBx, new JunitArtifact("matlabTestArtifacts/junittestresults.xml")));
        this.coberturaArtifact = Optional.ofNullable(this.coberturaArtifact).orElseGet(() -> this.getArtifactObject(this.coberturaChkBx, new CoberturaArtifact("matlabTestArtifacts/cobertura.xml")));
        this.stmResultsArtifact = Optional.ofNullable(this.stmResultsArtifact).orElseGet(() -> this.getArtifactObject(this.stmResultsChkBx, new StmResultsArtifact("matlabTestArtifacts/simulinktestresults.mldatx")));
        this.modelCoverageArtifact = Optional.ofNullable(this.modelCoverageArtifact).orElseGet(() -> this.getArtifactObject(this.modelCoverageChkBx, new ModelCovArtifact("matlabTestArtifacts/coberturamodelcoverage.xml")));
        return this;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment(listener);
        this.buildResult = this.execMatlabCommand(workspace, launcher, listener, env);
        if (this.buildResult != 0) {
            build.setResult(Result.FAILURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execMatlabCommand(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        Utilities.addMatlabToEnvPathFrmAxis(Computer.currentComputer(), listener, envVars);
        String uniqueTmpFldrName = this.getUniqueNameForRunnerFile();
        try {
            FilePath genScriptLocation = this.getFilePathForUniqueFolder(launcher, uniqueTmpFldrName, workspace);
            Launcher.ProcStarter matlabLauncher = this.getProcessToRunMatlabCommand(workspace, launcher, listener, envVars, this.constructCommandForTest(genScriptLocation), uniqueTmpFldrName);
            this.prepareTmpFldr(genScriptLocation, this.getRunnerScript("testScript = genscript(${PARAMS});\n\ndisp('Running MATLAB script with content:');\ndisp(strtrim(testScript.Contents));\nrunnerFile = testScript.writeToFile(fullfile(tempname,'runnerScript.m'));\n[tmpDir,scriptName,ext] = fileparts(runnerFile);addpath(tmpDir);\nrmdir('.matlab/${TMPDIR}/+scriptgen', 's');\ndelete('.matlab/${TMPDIR}/genscript.m');\nfprintf('___________________________________\\n\\n');\n", envVars.expand(this.getInputArguments()), uniqueTmpFldrName));
            int n = matlabLauncher.pwd(workspace).join();
            return n;
        }
        catch (Exception e) {
            listener.getLogger().println(e.getMessage());
            int n = 1;
            return n;
        }
        finally {
            FilePath matlabRunnerScript = this.getFilePathForUniqueFolder(launcher, uniqueTmpFldrName, workspace);
            if (matlabRunnerScript.exists()) {
                matlabRunnerScript.deleteRecursive();
            }
        }
    }

    public String constructCommandForTest(FilePath scriptPath) {
        String matlabScriptName = this.getValidMatlabFileName(scriptPath.getBaseName());
        String runCommand = "addpath('" + scriptPath.getRemote().replaceAll("'", "''") + "'); " + matlabScriptName + ",delete('.matlab/" + scriptPath.getBaseName() + "/" + matlabScriptName + ".m'),runnerScript,rmdir(tmpDir,'s')";
        return runCommand;
    }

    private String getInputArguments() {
        ArrayList<String> inputArgsList = new ArrayList<String>();
        HashMap<String, String> args = new HashMap<String, String>();
        ArrayList<Artifact> artifactList = new ArrayList<Artifact>(Arrays.asList(this.getPdfReportArtifact(), this.getTapArtifact(), this.getJunitArtifact(), this.getStmResultsArtifact(), this.getCoberturaArtifact(), this.getModelCoverageArtifact()));
        inputArgsList.add("'Test'");
        for (Artifact artifact : artifactList) {
            artifact.addFilePathArgTo(args);
        }
        args.forEach((key, val) -> inputArgsList.add("'" + key + "','" + val.replaceAll("'", "''") + "'"));
        SourceFolder sf = this.getSourceFolder();
        if (sf != null && !sf.getSourceFolderPaths().isEmpty()) {
            sf.addSourceToInputArgs(inputArgsList, Utilities.getCellArrayFrmList(sf.getSourceFolderPaths().stream().map(SourceFolderPaths::getSrcFolderPath).collect(Collectors.toList())));
        }
        if (this.getSelectByFolder() != null && !this.getSelectByFolder().getTestFolderPaths().isEmpty()) {
            this.getSelectByFolder().addSourceToInputArgs(inputArgsList, Utilities.getCellArrayFrmList(this.getSelectByFolder().getTestFolderPaths().stream().map(TestFolders::getTestFolders).collect(Collectors.toList())));
        }
        if (this.getSelectByTag() != null && !this.getSelectByTag().getTestTag().isEmpty()) {
            this.getSelectByTag().addTagToInputArgs(inputArgsList);
        }
        return String.join((CharSequence)",", inputArgsList);
    }

    public static final class SelectByTag
    extends AbstractDescribableImpl<SelectByTag> {
        private String testTag;
        private static final String SELECT_BY_TAG = "SelectByTag";

        @DataBoundConstructor
        public SelectByTag(String testTag) {
            this.testTag = Util.fixNull((String)testTag);
        }

        public String getTestTag() {
            return this.testTag;
        }

        public void addTagToInputArgs(List<String> inputArgsList) {
            inputArgsList.add("'SelectByTag','" + this.getTestTag().replaceAll("'", "''") + "'");
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<SelectByTag> {
        }
    }

    public static interface Artifact {
        public void addFilePathArgTo(Map<String, String> var1);

        public String getFilePath();

        public boolean getSelected();
    }

    public static abstract class AbstractArtifactImpl
    implements Artifact {
        private String filePath;

        protected AbstractArtifactImpl(String path) {
            this.filePath = path;
        }

        @Override
        public boolean getSelected() {
            return true;
        }

        public void setFilePath(String path) {
            this.filePath = path;
        }

        @Override
        public String getFilePath() {
            return this.filePath;
        }
    }

    public static class NullArtifact
    implements Artifact {
        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
        }

        @Override
        public boolean getSelected() {
            return false;
        }

        @Override
        public String getFilePath() {
            return null;
        }
    }

    public static class ModelCovArtifact
    extends AbstractArtifactImpl {
        private static final String COBERTURA_MODEL_COVERAGE = "CoberturaModelCoverage";

        @DataBoundConstructor
        public ModelCovArtifact(String modelCoverageFilePath) {
            super(modelCoverageFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(COBERTURA_MODEL_COVERAGE, this.getFilePath());
        }
    }

    public static class StmResultsArtifact
    extends AbstractArtifactImpl {
        private static final String STM_RESULTS = "SimulinkTestResults";

        @DataBoundConstructor
        public StmResultsArtifact(String stmResultsFilePath) {
            super(stmResultsFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(STM_RESULTS, this.getFilePath());
        }
    }

    public static class CoberturaArtifact
    extends AbstractArtifactImpl {
        private static final String COBERTURA_CODE_COVERAGE = "CoberturaCodeCoverage";

        @DataBoundConstructor
        public CoberturaArtifact(String coberturaReportFilePath) {
            super(coberturaReportFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(COBERTURA_CODE_COVERAGE, this.getFilePath());
        }
    }

    public static class JunitArtifact
    extends AbstractArtifactImpl {
        private static final String JUNIT_TEST_RESULTS = "JUnitTestResults";

        @DataBoundConstructor
        public JunitArtifact(String junitReportFilePath) {
            super(junitReportFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(JUNIT_TEST_RESULTS, this.getFilePath());
        }
    }

    public static class TapArtifact
    extends AbstractArtifactImpl {
        private static final String TAP_TEST_RESULTS = "TAPTestResults";

        @DataBoundConstructor
        public TapArtifact(String tapReportFilePath) {
            super(tapReportFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(TAP_TEST_RESULTS, this.getFilePath());
        }
    }

    public static class PdfArtifact
    extends AbstractArtifactImpl {
        private static final String PDF_TEST_REPORT = "PDFTestReport";

        @DataBoundConstructor
        public PdfArtifact(String pdfReportFilePath) {
            super(pdfReportFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(PDF_TEST_REPORT, this.getFilePath());
        }
    }

    @Extension
    public static class RunMatlabTestsDescriptor
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return Message.getBuilderDisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobtype) {
            return true;
        }
    }
}

