/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;

public interface MatlabBuild {
    default public Launcher.ProcStarter getProcessToRunMatlabCommand(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars, String matlabCommand, String uniqueName) throws IOException, InterruptedException {
        Launcher.ProcStarter matlabLauncher;
        FilePath targetWorkspace = new FilePath(launcher.getChannel(), workspace.getRemote() + "/" + ".matlab");
        if (launcher.isUnix()) {
            String runnerScriptName = uniqueName + "/run_matlab_command.sh";
            matlabLauncher = launcher.launch().envs((Map)envVars);
            matlabLauncher.cmds(new String[]{".matlab/" + runnerScriptName, matlabCommand}).stdout(listener);
            this.copyFileInWorkspace("run_matlab_command.sh", runnerScriptName, targetWorkspace);
        } else {
            String runnerScriptName = uniqueName + "\\run_matlab_command.bat";
            launcher = launcher.decorateByPrefix(new String[]{"cmd.exe", "/C"});
            matlabLauncher = launcher.launch().envs((Map)envVars);
            matlabLauncher.cmds(new String[]{".matlab\\" + runnerScriptName, "\"" + matlabCommand + "\""}).stdout(listener);
            this.copyFileInWorkspace("run_matlab_command.bat", runnerScriptName, targetWorkspace);
        }
        return matlabLauncher;
    }

    default public void copyFileInWorkspace(String sourceFile, String targetFile, FilePath targetWorkspace) throws IOException, InterruptedException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        FilePath targetFilePath = new FilePath(targetWorkspace, targetFile);
        InputStream in = classLoader.getResourceAsStream(sourceFile);
        targetFilePath.copyFrom(in);
        targetFilePath.chmod(493);
    }

    default public FilePath getFilePathForUniqueFolder(Launcher launcher, String uniqueName, FilePath workspace) throws IOException, InterruptedException {
        String tmpDir = workspace.getRemote() + "/" + ".matlab";
        return new FilePath(launcher.getChannel(), tmpDir + "/" + uniqueName);
    }

    default public String getUniqueNameForRunnerFile() {
        return RandomStringUtils.randomAlphanumeric((int)8);
    }

    default public void prepareTmpFldr(FilePath tmpFldr, String runnerScript) throws IOException, InterruptedException {
        FilePath scriptFile = new FilePath(tmpFldr, this.getValidMatlabFileName(tmpFldr.getBaseName()) + ".m");
        scriptFile.write(runnerScript, "UTF-8");
        this.copyFileInWorkspace("matlab-script-generator.zip", "matlab-script-generator.zip", tmpFldr);
        FilePath zipFileLocation = new FilePath(tmpFldr, "matlab-script-generator.zip");
        zipFileLocation.unzip(tmpFldr);
    }

    default public String getRunnerScript(String script, String params, String uniqueTmpFldrName) {
        script = script.replace("${PARAMS}", params);
        script = script.replaceAll("\\$\\{TMPDIR\\}", uniqueTmpFldrName);
        return script;
    }

    default public String getValidMatlabFileName(String actualName) {
        return "runner_" + actualName.replaceAll("-", "_");
    }
}

