/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.FormValidationUtil;
import com.mathworks.ci.MatlabBuildWrapperContent;
import com.mathworks.ci.MatlabInstallation;
import com.mathworks.ci.MatlabItemListener;
import com.mathworks.ci.MatlabNotFoundError;
import com.mathworks.ci.MatlabReleaseInfo;
import com.mathworks.ci.MatlabVersionNotFoundException;
import com.mathworks.ci.MatrixPatternResolver;
import com.mathworks.ci.Message;
import com.mathworks.ci.Utilities;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import jenkins.tasks.SimpleBuildWrapper;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class UseMatlabVersionBuildWrapper
extends SimpleBuildWrapper {
    private String matlabRootFolder;
    private EnvVars env;
    private String matlabInstallationName;

    @DataBoundConstructor
    public UseMatlabVersionBuildWrapper() {
    }

    public String getMatlabRootFolder() {
        return this.matlabRootFolder;
    }

    public String getMatlabInstallationHome(Computer cmp, TaskListener listener, EnvVars env) throws IOException, InterruptedException {
        return Utilities.getNodeSpecificHome(this.matlabInstallationName, cmp.getNode(), listener, env);
    }

    public String getMatlabInstallationName() {
        if (this.matlabRootFolder != null && !this.matlabRootFolder.isEmpty()) {
            this.matlabInstallationName = Message.getValue("matlab.custom.location");
        }
        return this.matlabInstallationName;
    }

    @DataBoundSetter
    public void setMatlabBuildWrapperContent(MatlabBuildWrapperContent matlabBuildWrapperContent) {
        if (matlabBuildWrapperContent != null) {
            this.matlabInstallationName = matlabBuildWrapperContent.getMatlabInstallationName();
            this.matlabRootFolder = matlabBuildWrapperContent.getMatlabRootFolder();
        }
    }

    private String getNodeSpecificMatlab(Computer cmp, TaskListener listener) throws IOException, InterruptedException {
        String matlabroot = this.getMatlabRootFolder();
        if (matlabroot == null || matlabroot.isEmpty()) {
            matlabroot = this.getMatlabInstallationHome(cmp, listener, this.env);
        }
        return this.env == null ? matlabroot : this.env.expand(matlabroot);
    }

    private void setEnv(EnvVars env) {
        this.env = env;
    }

    public synchronized void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        this.setEnv(initialEnvironment);
        FilePath matlabExecutablePath = new FilePath(launcher.getChannel(), this.getNodeSpecificMatlab(Computer.currentComputer(), listener) + "/bin/" + this.getNodeSpecificExecutable(launcher));
        if (!matlabExecutablePath.exists()) {
            throw new MatlabNotFoundError(Message.getValue("matlab.not.found.error"));
        }
        context.env("matlabroot", this.getNodeSpecificMatlab(Computer.currentComputer(), listener));
        context.env("PATH+matlabroot", matlabExecutablePath.getParent().getRemote());
        listener.getLogger().println("\n" + String.format(Message.getValue("matlab.added.to.path.from"), matlabExecutablePath.getParent().getRemote()) + "\n");
    }

    private String getNodeSpecificExecutable(Launcher launcher) {
        return launcher.isUnix() ? "matlab" : "matlab.exe";
    }

    @Extension
    public static final class UseMatlabVersionDescriptor
    extends BuildWrapperDescriptor {
        MatlabReleaseInfo rel;
        private boolean isMatrix;
        private final String customLocation = Message.getValue("matlab.custom.location");
        private final String matlabAxisWarning = Message.getValue("Use.matlab.version.axis.warning");
        private AbstractProject<?, ?> project;
        Function<String, FormValidation> chkMatlabEmpty = matlabRootFolder -> {
            if (matlabRootFolder.isEmpty()) {
                return FormValidation.error((String)Message.getValue("Builder.matlab.root.empty.error"));
            }
            return FormValidation.ok();
        };
        Function<String, FormValidation> chkMatlabSupportsRunTests = matlabRootFolder -> {
            MatrixPatternResolver resolver = new MatrixPatternResolver((String)matlabRootFolder);
            if (!resolver.hasVariablePattern()) {
                try {
                    FilePath matlabRootPath = new FilePath(new File((String)matlabRootFolder));
                    this.rel = new MatlabReleaseInfo(matlabRootPath);
                    if (this.rel.verLessThan(8.1)) {
                        return FormValidation.error((String)Message.getValue("Builder.matlab.test.support.error"));
                    }
                }
                catch (MatlabVersionNotFoundException e) {
                    return FormValidation.warning((String)Message.getValue("Builder.invalid.matlab.root.warning"));
                }
            }
            return FormValidation.ok();
        };

        public boolean isApplicable(AbstractProject<?, ?> item) {
            this.project = item;
            this.isMatrix = item instanceof MatrixProject;
            return true;
        }

        public String getDisplayName() {
            return Message.getValue("Buildwrapper.display.name");
        }

        public MatlabInstallation[] getInstallations() {
            ArrayList<MatlabInstallation> arr = new ArrayList<MatlabInstallation>(Arrays.asList(MatlabInstallation.getAll()));
            arr.add(new MatlabInstallation(this.customLocation));
            MatlabInstallation[] temp = new MatlabInstallation[arr.size()];
            return arr.toArray(temp);
        }

        public String getCustomLocation() {
            return this.customLocation;
        }

        public boolean getIsMatrix() {
            return this.isMatrix;
        }

        public boolean checkAxisAdded() {
            if (!this.isMatrix) {
                return false;
            }
            return MatlabItemListener.getMatlabAxisCheckForPrj(this.project.getFullName()) && !MatlabInstallation.isEmpty();
        }

        public String getMatlabAxisWarning() {
            return this.matlabAxisWarning;
        }

        public FormValidation doCheckMatlabRootFolder(@QueryParameter String matlabRootFolder) {
            ArrayList<Function<String, FormValidation>> listOfCheckMethods = new ArrayList<Function<String, FormValidation>>();
            listOfCheckMethods.add(this.chkMatlabEmpty);
            listOfCheckMethods.add(this.chkMatlabSupportsRunTests);
            return FormValidationUtil.getFirstErrorOrWarning(listOfCheckMethods, matlabRootFolder);
        }
    }
}

