/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.MatlabBuild;
import com.mathworks.ci.MatlabExecutionException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class MatlabRunTestsStepExecution
extends SynchronousNonBlockingStepExecution<Void>
implements MatlabBuild {
    private static final long serialVersionUID = 6704588180717665100L;
    private String commandArgs;

    public MatlabRunTestsStepExecution(StepContext context, String commandArgs) {
        super(context);
        this.commandArgs = commandArgs;
    }

    private String getCommandArgs() {
        return this.commandArgs;
    }

    public Void run() throws Exception {
        Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        EnvVars env = (EnvVars)this.getContext().get(EnvVars.class);
        workspace.mkdirs();
        int exitCode = this.execMatlabCommand(workspace, launcher, listener, env);
        if (exitCode != 0) {
            this.stop(new MatlabExecutionException(exitCode));
        }
        this.getContext().setResult(Result.SUCCESS);
        return null;
    }

    public void stop(Throwable cause) throws Exception {
        this.getContext().onFailure(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int execMatlabCommand(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        String uniqueTmpFldrName = this.getUniqueNameForRunnerFile();
        try {
            FilePath genScriptLocation = this.getFilePathForUniqueFolder(launcher, uniqueTmpFldrName, workspace);
            String cmdPrefix = "addpath('" + genScriptLocation.getRemote().replaceAll("'", "''") + "'); ";
            String matlabScriptName = this.getValidMatlabFileName(genScriptLocation.getBaseName());
            Launcher.ProcStarter matlabLauncher = this.getProcessToRunMatlabCommand(workspace, launcher, listener, envVars, cmdPrefix + matlabScriptName, uniqueTmpFldrName);
            this.prepareTmpFldr(genScriptLocation, this.getRunnerScript("testScript = genscript(${PARAMS});\n\ndisp('Running MATLAB script with content:');\ndisp(strtrim(testScript.writeToText()));\nfprintf('___________________________________\\n\\n');\nrun(testScript);\n", envVars.expand(this.getCommandArgs())));
            int n = matlabLauncher.pwd(workspace).join();
            return n;
        }
        finally {
            FilePath matlabRunnerScript = this.getFilePathForUniqueFolder(launcher, uniqueTmpFldrName, workspace);
            if (matlabRunnerScript.exists()) {
                matlabRunnerScript.deleteRecursive();
            }
        }
    }
}

