/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.MatlabBuild;
import com.mathworks.ci.Message;
import com.mathworks.ci.Utilities;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class RunMatlabCommandBuilder
extends Builder
implements SimpleBuildStep,
MatlabBuild {
    private int buildResult;
    private EnvVars env;
    private String matlabCommand;

    @DataBoundConstructor
    public RunMatlabCommandBuilder() {
    }

    @DataBoundSetter
    public void setMatlabCommand(String matlabCommand) {
        this.matlabCommand = matlabCommand;
    }

    public String getMatlabCommand() {
        return this.matlabCommand;
    }

    private String getCommand() {
        return this.env == null ? this.getMatlabCommand() : this.env.expand(this.getMatlabCommand());
    }

    private void setEnv(EnvVars env) {
        this.env = env;
    }

    private EnvVars getEnv() {
        return this.env;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.setEnv(build.getEnvironment(listener));
        this.buildResult = this.execMatlabCommand(workspace, launcher, listener, this.getEnv());
        if (this.buildResult != 0) {
            build.setResult(Result.FAILURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int execMatlabCommand(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        Utilities.addMatlabToEnvPathFrmAxis(Computer.currentComputer(), listener, envVars);
        String uniqueTmpFldrName = this.getUniqueNameForRunnerFile();
        String uniqueCommandFile = "command_" + this.getUniqueNameForRunnerFile().replaceAll("-", "_");
        FilePath uniqeTmpFolderPath = this.getFilePathForUniqueFolder(launcher, uniqueTmpFldrName, workspace);
        this.createMatlabScriptByName(uniqeTmpFolderPath, uniqueCommandFile, workspace, listener);
        try {
            Launcher.ProcStarter matlabLauncher = this.getProcessToRunMatlabCommand(workspace, launcher, listener, envVars, "cd('" + uniqeTmpFolderPath.getRemote().replaceAll("'", "''") + "');" + uniqueCommandFile, uniqueTmpFldrName);
            listener.getLogger().println("#################### Starting command output ####################");
            int n = matlabLauncher.pwd(workspace).join();
            return n;
        }
        catch (Exception e) {
            listener.getLogger().println(e.getMessage());
            int n = 1;
            return n;
        }
        finally {
            if (uniqeTmpFolderPath.exists()) {
                uniqeTmpFolderPath.deleteRecursive();
            }
        }
    }

    private void createMatlabScriptByName(FilePath uniqeTmpFolderPath, String uniqueScriptName, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        FilePath matlabCommandFile = new FilePath(uniqeTmpFolderPath, uniqueScriptName + ".m");
        String matlabCommandFileContent = "cd '" + workspace.getRemote().replaceAll("'", "''") + "';\n" + this.getCommand();
        listener.getLogger().println("Generating MATLAB script with content:\n" + this.getCommand() + "\n");
        matlabCommandFile.write(matlabCommandFileContent, "UTF-8");
    }

    @Extension
    public static class RunMatlabCommandDescriptor
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return Message.getValue("Builder.script.builder.display.name");
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobtype) {
            return true;
        }
    }
}

