/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.FormValidationUtil;
import com.mathworks.ci.MatlabNotFoundError;
import com.mathworks.ci.MatlabReleaseInfo;
import com.mathworks.ci.MatlabVersionNotFoundException;
import com.mathworks.ci.MatrixPatternResolver;
import com.mathworks.ci.Message;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Function;
import jenkins.tasks.SimpleBuildWrapper;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class UseMatlabVersionBuildWrapper
extends SimpleBuildWrapper {
    private String matlabRootFolder;
    private EnvVars env;

    @DataBoundConstructor
    public UseMatlabVersionBuildWrapper() {
    }

    public String getMatlabRootFolder() {
        return this.matlabRootFolder;
    }

    @DataBoundSetter
    public void setMatlabRootFolder(String matlabRootFolder) {
        this.matlabRootFolder = matlabRootFolder;
    }

    private String getLocalMatlab() {
        return this.env == null ? this.getMatlabRootFolder() : this.env.expand(this.getMatlabRootFolder());
    }

    private void setEnv(EnvVars env) {
        this.env = env;
    }

    public synchronized void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        this.setEnv(initialEnvironment);
        FilePath matlabExecutablePath = new FilePath(launcher.getChannel(), this.getLocalMatlab() + "/bin/" + this.getNodeSpecificExecutable(launcher));
        if (!matlabExecutablePath.exists()) {
            throw new MatlabNotFoundError(Message.getValue("matlab.not.found.error"));
        }
        context.env("matlabroot", this.getLocalMatlab());
        context.env("PATH+matlabroot", matlabExecutablePath.getParent().getRemote());
    }

    private String getNodeSpecificExecutable(Launcher launcher) {
        return launcher.isUnix() ? "matlab" : "matlab.exe";
    }

    @Extension
    public static final class UseMatlabVersionDescriptor
    extends BuildWrapperDescriptor {
        MatlabReleaseInfo rel;
        String matlabRootFolder;
        Function<String, FormValidation> chkMatlabEmpty = matlabRootFolder -> {
            if (matlabRootFolder.isEmpty()) {
                return FormValidation.error((String)Message.getValue("Builder.matlab.root.empty.error"));
            }
            return FormValidation.ok();
        };
        Function<String, FormValidation> chkMatlabSupportsRunTests = matlabRootFolder -> {
            MatrixPatternResolver resolver = new MatrixPatternResolver((String)matlabRootFolder);
            if (!resolver.hasVariablePattern()) {
                try {
                    FilePath matlabRootPath = new FilePath(new File((String)matlabRootFolder));
                    this.rel = new MatlabReleaseInfo(matlabRootPath);
                    if (this.rel.verLessThan(8.1)) {
                        return FormValidation.error((String)Message.getValue("Builder.matlab.test.support.error"));
                    }
                }
                catch (MatlabVersionNotFoundException e) {
                    return FormValidation.warning((String)Message.getValue("Builder.invalid.matlab.root.warning"));
                }
            }
            return FormValidation.ok();
        };

        public String getMatlabRootFolder() {
            return this.matlabRootFolder;
        }

        public void setMatlabRootFolder(String matlabRootFolder) {
            this.matlabRootFolder = matlabRootFolder;
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return Message.getValue("Buildwrapper.display.name");
        }

        public FormValidation doCheckMatlabRootFolder(@QueryParameter String matlabRootFolder) {
            this.setMatlabRootFolder(matlabRootFolder);
            ArrayList<Function<String, FormValidation>> listOfCheckMethods = new ArrayList<Function<String, FormValidation>>();
            listOfCheckMethods.add(this.chkMatlabEmpty);
            listOfCheckMethods.add(this.chkMatlabSupportsRunTests);
            return FormValidationUtil.getFirstErrorOrWarning(listOfCheckMethods, matlabRootFolder);
        }
    }
}

