/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class MatlabInstallation
extends ToolInstallation
implements EnvironmentSpecific<MatlabInstallation>,
NodeSpecific<MatlabInstallation> {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public MatlabInstallation(String name, @CheckForNull String home, List<? extends ToolProperty<?>> properties) {
        super(Util.fixEmptyAndTrim((String)name), Util.fixEmptyAndTrim((String)home), properties);
    }

    public MatlabInstallation(String name) {
        super(name, null, null);
    }

    public MatlabInstallation forEnvironment(EnvVars envVars) {
        return new MatlabInstallation(this.getName(), envVars.expand(this.getHome()), this.getProperties().toList());
    }

    public MatlabInstallation forNode(@Nonnull Node node, TaskListener log) throws IOException, InterruptedException {
        return new MatlabInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    public void buildEnvVars(EnvVars env) {
        String home = this.getHome();
        if (home == null) {
            return;
        }
        env.put("PATH+matlabroot", home + "/bin");
    }

    public static MatlabInstallation[] getAll() {
        return ((DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class)).getInstallations();
    }

    public static boolean isEmpty() {
        return MatlabInstallation.getAll().length == 0;
    }

    public static MatlabInstallation getInstallation(String name) {
        for (MatlabInstallation inst : MatlabInstallation.getAll()) {
            if (!name.equals(inst.getName())) continue;
            return inst;
        }
        return null;
    }

    @Extension
    @Symbol(value={"matlab"})
    public static class DescriptorImpl
    extends ToolDescriptor<MatlabInstallation> {
        private volatile MatlabInstallation[] installations = new MatlabInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "MATLAB";
        }

        public MatlabInstallation[] getInstallations() {
            return Arrays.copyOf(this.installations, this.installations.length);
        }

        public MatlabInstallation newInstance(StaplerRequest req, JSONObject formData) {
            return (MatlabInstallation)((Object)req.bindJSON(this.clazz, formData));
        }

        public void setInstallations(MatlabInstallation ... matlabInstallations) {
            this.installations = matlabInstallations;
            this.save();
        }
    }
}

