/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.google.common.base.Charsets;
import com.mathworks.ci.BuildTargetNote;
import hudson.console.ConsoleLogFilter;
import hudson.console.LineTransformationOutputStream;
import hudson.model.Run;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import jenkins.util.JenkinsJVM;

public class BuildConsoleAnnotator
extends LineTransformationOutputStream {
    private final OutputStream out;
    private final Charset charset;
    private final byte[][] antNotes;

    public BuildConsoleAnnotator(OutputStream out, Charset charset) {
        this(out, charset, BuildConsoleAnnotator.createBuildNotes());
    }

    private BuildConsoleAnnotator(OutputStream out, Charset charset, byte[][] antNotes) {
        this.out = out;
        this.charset = charset;
        this.antNotes = antNotes;
    }

    private static byte[][] createBuildNotes() {
        JenkinsJVM.checkJenkinsJVM();
        try {
            ByteArrayOutputStream targetNote = new ByteArrayOutputStream();
            new BuildTargetNote().encodeTo(targetNote);
            ByteArrayOutputStream outcomeNote = new ByteArrayOutputStream();
            return new byte[][]{targetNote.toByteArray(), outcomeNote.toByteArray()};
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void eol(byte[] b, int len) throws IOException {
        String line = this.charset.decode(ByteBuffer.wrap(b, 0, len)).toString();
        if ((line = this.trimEOL(line)).contains("[MATLAB-Build-")) {
            this.out.write(this.antNotes[0]);
        }
        this.out.write(b, 0, len);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        super.close();
        this.out.close();
    }

    private static class ConsoleLogFilterImpl
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private byte[][] buildNotes = BuildConsoleAnnotator.createBuildNotes();

        private ConsoleLogFilterImpl() {
        }

        private Object readResolve() {
            if (this.buildNotes == null) {
                this.buildNotes = BuildConsoleAnnotator.createBuildNotes();
            }
            return this;
        }

        public OutputStream decorateLogger(Run build, OutputStream logger) throws IOException, InterruptedException {
            return new BuildConsoleAnnotator(logger, Charsets.UTF_8, this.buildNotes);
        }
    }
}

