/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci.actions;

import com.mathworks.ci.BuildConsoleAnnotator;
import com.mathworks.ci.MatlabExecutionException;
import com.mathworks.ci.actions.MatlabAction;
import com.mathworks.ci.parameters.BuildActionParameters;
import com.mathworks.ci.utilities.MatlabCommandRunner;
import hudson.model.Run;
import java.io.IOException;
import java.io.OutputStream;

public class RunMatlabBuildAction
extends MatlabAction {
    private BuildActionParameters params;

    public RunMatlabBuildAction(MatlabCommandRunner runner, BuildConsoleAnnotator annotator, BuildActionParameters params) {
        super(runner, annotator);
        this.params = params;
    }

    public RunMatlabBuildAction(BuildActionParameters params) throws IOException, InterruptedException {
        this(new MatlabCommandRunner(params), new BuildConsoleAnnotator(params.getTaskListener().getLogger(), params.getBuild().getCharset()), params);
    }

    public void run() throws IOException, InterruptedException, MatlabExecutionException {
        super.copyBuildPluginsToTemp();
        super.setBuildEnvVars();
        this.runner.redirectStdOut((OutputStream)((Object)this.annotator));
        String command = "addpath('" + this.runner.getTempFolder().getRemote() + "'); buildtool";
        if (this.params.getTasks() != null) {
            command = command + " " + this.params.getTasks();
        }
        if (this.params.getBuildOptions() != null) {
            command = command + " " + this.params.getBuildOptions();
        }
        try {
            this.runner.runMatlabCommand(command);
        }
        catch (Exception e) {
            this.params.getTaskListener().getLogger().println(e.getMessage());
            throw e;
        }
        finally {
            this.annotator.forceEol();
            Run<?, ?> build = this.params.getBuild();
            super.teardownAction(build);
        }
    }
}

