/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci.actions;

import com.mathworks.ci.BuildArtifactAction;
import com.mathworks.ci.BuildConsoleAnnotator;
import com.mathworks.ci.utilities.MatlabCommandRunner;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.RandomStringUtils;

public class MatlabAction {
    MatlabCommandRunner runner;
    BuildConsoleAnnotator annotator;
    String actionID;

    public String getActionID() {
        return this.actionID == null ? "" : this.actionID;
    }

    public MatlabAction(MatlabCommandRunner runner) {
        this.runner = runner;
    }

    public MatlabAction(MatlabCommandRunner runner, BuildConsoleAnnotator annotator) {
        this.runner = runner;
        this.actionID = RandomStringUtils.randomAlphanumeric((int)8);
        this.annotator = annotator;
    }

    public void copyBuildPluginsToTemp() throws IOException, InterruptedException {
        this.runner.copyFileToTempFolder("+ciplugins/+jenkins/getDefaultPlugins.m", "+ciplugins/+jenkins/getDefaultPlugins.m");
        this.runner.copyFileToTempFolder("+ciplugins/+jenkins/BuildReportPlugin.m", "+ciplugins/+jenkins/BuildReportPlugin.m");
        this.runner.copyFileToTempFolder("+ciplugins/+jenkins/TaskRunProgressPlugin.m", "+ciplugins/+jenkins/TaskRunProgressPlugin.m");
    }

    public void setBuildEnvVars() throws IOException, InterruptedException {
        this.runner.addEnvironmentVariable("MW_MATLAB_BUILDTOOL_DEFAULT_PLUGINS_FCN_OVERRIDE", "ciplugins.jenkins.getDefaultPlugins");
        this.runner.addEnvironmentVariable("MW_BUILD_PLUGIN_ACTION_ID", this.getActionID());
        this.runner.addEnvironmentVariable("MW_MATLAB_TEMP_FOLDER", this.runner.getTempFolder().toString());
    }

    public void teardownAction(Run<?, ?> build) {
        if (this.annotator != null) {
            this.moveJsonArtifactToBuildRoot(build, "buildArtifact");
        }
        try {
            this.runner.removeTempFolder();
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    private void moveJsonArtifactToBuildRoot(Run<?, ?> build, String artifactBaseName) {
        try {
            FilePath file = new FilePath(this.runner.getTempFolder(), artifactBaseName + ".json");
            if (file.exists()) {
                FilePath rootLocation = new FilePath(new File(build.getRootDir().getAbsolutePath(), artifactBaseName + this.getActionID() + ".json"));
                file.copyTo(rootLocation);
                file.delete();
                build.addAction((Action)new BuildArtifactAction(build, this.getActionID()));
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }
}

