/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.MatlabInstallation;
import com.mathworks.ci.MatlabItemListener;
import com.mathworks.ci.Message;
import hudson.Extension;
import hudson.matrix.Axis;
import hudson.matrix.AxisDescriptor;
import hudson.matrix.MatrixProject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class MatlabInstallationAxis
extends Axis {
    @DataBoundConstructor
    public MatlabInstallationAxis(List<String> values) {
        super(Message.getValue("Axis.matlab.key"), MatlabInstallationAxis.evaluateValues(values));
    }

    private static List<String> evaluateValues(List<String> values) {
        if (values == null || values.isEmpty()) {
            values = new ArrayList<String>(Arrays.asList("default"));
        }
        return values;
    }

    @Extension
    public static class DescriptorImpl
    extends AxisDescriptor {
        public String getDisplayName() {
            return Message.getValue("Axis.matlab.key");
        }

        public boolean isInstantiable() {
            return !this.isMatlabInstallationEmpty();
        }

        public boolean checkUseMatlabVersion(Object it) {
            return MatlabItemListener.getMatlabBuildWrapperCheckForPrj(((MatrixProject)it).getFullName()) && !this.isMatlabInstallationEmpty();
        }

        public MatlabInstallation[] getInstallations() {
            return MatlabInstallation.getAll();
        }

        public String getUseMatlabWarning() {
            return Message.getValue("Axis.use.matlab.warning");
        }

        public boolean isMatlabInstallationEmpty() {
            return MatlabInstallation.isEmpty();
        }

        public String getNoInstallationError() {
            return Message.getValue("Axis.no.installed.matlab.error");
        }
    }
}

