/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci.actions;

import com.mathworks.ci.BuildArtifactAction;
import com.mathworks.ci.BuildConsoleAnnotator;
import com.mathworks.ci.MatlabExecutionException;
import com.mathworks.ci.parameters.BuildActionParameters;
import com.mathworks.ci.utilities.MatlabCommandRunner;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang.RandomStringUtils;

public class RunMatlabBuildAction {
    private BuildActionParameters params;
    private MatlabCommandRunner runner;
    private BuildConsoleAnnotator annotator;
    private static String DEFAULT_PLUGIN = "+ciplugins/+jenkins/getDefaultPlugins.m";
    private static String BUILD_REPORT_PLUGIN = "+ciplugins/+jenkins/BuildReportPlugin.m";
    private static String TASK_RUN_PROGRESS_PLUGIN = "+ciplugins/+jenkins/TaskRunProgressPlugin.m";
    private String actionID;

    public String getActionID() {
        return this.actionID;
    }

    public RunMatlabBuildAction(MatlabCommandRunner runner, BuildConsoleAnnotator annotator, BuildActionParameters params) {
        this.runner = runner;
        this.actionID = RandomStringUtils.randomAlphanumeric((int)8);
        this.annotator = annotator;
        this.params = params;
    }

    public RunMatlabBuildAction(BuildActionParameters params) throws IOException, InterruptedException {
        this(new MatlabCommandRunner(params), new BuildConsoleAnnotator(params.getTaskListener().getLogger(), params.getBuild().getCharset()), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws IOException, InterruptedException, MatlabExecutionException {
        this.runner.copyFileToTempFolder(DEFAULT_PLUGIN, DEFAULT_PLUGIN);
        this.runner.copyFileToTempFolder(BUILD_REPORT_PLUGIN, BUILD_REPORT_PLUGIN);
        this.runner.copyFileToTempFolder(TASK_RUN_PROGRESS_PLUGIN, TASK_RUN_PROGRESS_PLUGIN);
        this.runner.addEnvironmentVariable("MW_MATLAB_BUILDTOOL_DEFAULT_PLUGINS_FCN_OVERRIDE", "ciplugins.jenkins.getDefaultPlugins");
        this.runner.addEnvironmentVariable("MW_BUILD_PLUGIN_ACTION_ID", this.getActionID());
        this.runner.addEnvironmentVariable("MW_MATLAB_TEMP_FOLDER", this.runner.getTempFolder().toString());
        this.runner.redirectStdOut((OutputStream)((Object)this.annotator));
        String command = "addpath('" + this.runner.getTempFolder().getRemote() + "'); buildtool";
        if (this.params.getTasks() != null) {
            command = command + " " + this.params.getTasks();
        }
        if (this.params.getBuildOptions() != null) {
            command = command + " " + this.params.getBuildOptions();
        }
        try {
            this.runner.runMatlabCommand(command);
            return;
        }
        catch (Exception e) {
            this.params.getTaskListener().getLogger().println(e.getMessage());
            throw e;
        }
        finally {
            this.annotator.forceEol();
            try {
                Run<?, ?> build = this.params.getBuild();
                FilePath jsonFile = new FilePath(this.runner.getTempFolder(), "buildArtifact.json");
                if (jsonFile.exists()) {
                    FilePath rootLocation = new FilePath(new File(build.getRootDir().getAbsolutePath(), "buildArtifact" + this.getActionID() + ".json"));
                    jsonFile.copyTo(rootLocation);
                    jsonFile.delete();
                    build.addAction((Action)new BuildArtifactAction(build, this.getActionID()));
                }
            }
            catch (Exception e) {
                System.err.println(e.toString());
            }
            finally {
                try {
                    this.runner.removeTempFolder();
                }
                catch (Exception e) {
                    System.err.println(e.toString());
                }
            }
        }
    }
}

