/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.BuildArtifactAction;
import com.mathworks.ci.BuildConsoleAnnotator;
import com.mathworks.ci.BuildOptions;
import com.mathworks.ci.MatlabBuild;
import com.mathworks.ci.Message;
import com.mathworks.ci.StartupOptions;
import com.mathworks.ci.Utilities;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class RunMatlabBuildBuilder
extends Builder
implements SimpleBuildStep,
MatlabBuild {
    private int buildResult;
    private String tasks;
    private StartupOptions startupOptions;
    private BuildOptions buildOptions;
    private static String DEFAULT_PLUGIN = "+ciplugins/+jenkins/getDefaultPlugins.m";
    private static String BUILD_REPORT_PLUGIN = "+ciplugins/+jenkins/BuildReportPlugin.m";
    private static String TASK_RUN_PROGRESS_PLUGIN = "+ciplugins/+jenkins/TaskRunProgressPlugin.m";

    @DataBoundConstructor
    public RunMatlabBuildBuilder() {
    }

    @DataBoundSetter
    public void setTasks(String tasks) {
        this.tasks = tasks;
    }

    @DataBoundSetter
    public void setStartupOptions(StartupOptions startupOptions) {
        this.startupOptions = startupOptions;
    }

    @DataBoundSetter
    public void setBuildOptions(BuildOptions buildOptions) {
        this.buildOptions = buildOptions;
    }

    public String getTasks() {
        return this.tasks;
    }

    public StartupOptions getStartupOptions() {
        return this.startupOptions;
    }

    public BuildOptions getBuildOptions() {
        return this.buildOptions;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment(listener);
        this.buildResult = this.execMatlabCommand(workspace, launcher, listener, env, build);
        FilePath jsonFile = new FilePath(workspace, ".matlab/buildArtifact.json");
        if (jsonFile.exists()) {
            jsonFile.copyTo(new FilePath(new File(build.getRootDir().getAbsolutePath() + "/buildArtifact.json")));
            jsonFile.delete();
        }
        build.addAction((Action)new BuildArtifactAction(build, workspace));
        if (this.buildResult != 0) {
            build.setResult(Result.FAILURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execMatlabCommand(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars, @Nonnull Run<?, ?> build) throws IOException, InterruptedException {
        Utilities.addMatlabToEnvPathFrmAxis(Computer.currentComputer(), listener, envVars);
        String uniqueTmpFldrName = this.getUniqueNameForRunnerFile();
        String uniqueBuildFile = "build_" + this.getUniqueNameForRunnerFile().replaceAll("-", "_");
        FilePath uniqueTmpFolderPath = this.getFilePathForUniqueFolder(launcher, uniqueTmpFldrName, workspace);
        this.createMatlabScriptByName(uniqueTmpFolderPath, uniqueBuildFile, listener, envVars);
        this.copyFileInWorkspace(DEFAULT_PLUGIN, DEFAULT_PLUGIN, uniqueTmpFolderPath);
        this.copyFileInWorkspace(BUILD_REPORT_PLUGIN, BUILD_REPORT_PLUGIN, uniqueTmpFolderPath);
        this.copyFileInWorkspace(TASK_RUN_PROGRESS_PLUGIN, TASK_RUN_PROGRESS_PLUGIN, uniqueTmpFolderPath);
        BuildConsoleAnnotator bca = new BuildConsoleAnnotator(listener.getLogger(), build.getCharset());
        String options = this.getStartupOptions() == null ? "" : this.getStartupOptions().getOptions();
        try {
            Launcher.ProcStarter matlabLauncher = this.getProcessToRunMatlabCommand(workspace, launcher, bca, envVars, "setenv('MW_ORIG_WORKING_FOLDER', cd('" + uniqueTmpFolderPath.getRemote().replaceAll("'", "''") + "'));" + uniqueBuildFile, options, uniqueTmpFldrName);
            listener.getLogger().println("#################### Starting command output ####################");
            int n = matlabLauncher.pwd(workspace).join();
            return n;
        }
        catch (Exception e) {
            listener.getLogger().println(e.getMessage());
            int n = 1;
            return n;
        }
        finally {
            bca.forceEol();
            if (uniqueTmpFolderPath.exists()) {
                uniqueTmpFolderPath.deleteRecursive();
            }
        }
    }

    private void createMatlabScriptByName(FilePath uniqueTmpFolderPath, String uniqueScriptName, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        FilePath matlabCommandFile = new FilePath(uniqueTmpFolderPath, uniqueScriptName + ".m");
        String tasks = envVars.expand(this.getTasks());
        String buildOptions = envVars.expand(this.getBuildOptions() == null ? "" : this.getBuildOptions().getOptions());
        envVars.put("MW_MATLAB_BUILDTOOL_DEFAULT_PLUGINS_FCN_OVERRIDE", "ciplugins.jenkins.getDefaultPlugins");
        String cmd = "buildtool";
        if (!tasks.trim().isEmpty()) {
            cmd = cmd + " " + tasks;
        }
        if (!buildOptions.trim().isEmpty()) {
            cmd = cmd + " " + buildOptions;
        }
        String matlabCommandFileContent = "addpath(pwd);cd(getenv('MW_ORIG_WORKING_FOLDER'));\n" + cmd;
        listener.getLogger().println("Generating MATLAB script with content:\n" + cmd + "\n");
        matlabCommandFile.write(matlabCommandFileContent, "UTF-8");
    }

    private Launcher.ProcStarter getProcessToRunMatlabCommand(FilePath workspace, Launcher launcher, BuildConsoleAnnotator bca, EnvVars envVars, String matlabCommand, String startupOpts, String uniqueName) throws IOException, InterruptedException {
        Launcher.ProcStarter matlabLauncher;
        ArgumentListBuilder args = new ArgumentListBuilder();
        if (launcher.isUnix()) {
            FilePath targetWorkspace = new FilePath(launcher.getChannel(), workspace.getRemote() + "/" + ".matlab");
            ByteArrayOutputStream kernelStream = new ByteArrayOutputStream();
            launcher.launch().cmds(new String[]{"uname"}).masks(new boolean[]{true}).stdout((OutputStream)kernelStream).join();
            String runnerName = uniqueName + "/run-matlab-command";
            String binaryName = kernelStream.toString("UTF-8").contains("Linux") ? "glnxa64/run-matlab-command" : "maci64/run-matlab-command";
            args.add(".matlab/" + runnerName);
            args.add(matlabCommand);
            args.add(startupOpts.split(" "));
            matlabLauncher = launcher.launch().envs((Map)envVars).cmds(args).stdout((OutputStream)((Object)bca));
            this.copyFileInWorkspace(binaryName, runnerName, targetWorkspace);
        } else {
            FilePath targetWorkspace = new FilePath(launcher.getChannel(), workspace.getRemote() + "\\" + ".matlab");
            String runnerName = uniqueName + "\\run-matlab-command.exe";
            args.add(new String[]{targetWorkspace.toString() + "\\" + runnerName, "\"" + matlabCommand + "\""});
            args.add(startupOpts.split(" "));
            matlabLauncher = launcher.launch().envs((Map)envVars).cmds(args).stdout((OutputStream)((Object)bca));
            this.copyFileInWorkspace("win64/run-matlab-command.exe", runnerName, targetWorkspace);
        }
        return matlabLauncher;
    }

    @Extension
    public static class RunMatlabBuildDescriptor
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return Message.getValue("Builder.build.builder.display.name");
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobtype) {
            return true;
        }
    }
}

