/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;

public interface MatlabBuild {
    default public Launcher.ProcStarter getProcessToRunMatlabCommand(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars, String matlabCommand, String startupOpts, String uniqueName) throws IOException, InterruptedException {
        Launcher.ProcStarter matlabLauncher;
        ArgumentListBuilder args = new ArgumentListBuilder();
        if (launcher.isUnix()) {
            FilePath targetWorkspace = new FilePath(launcher.getChannel(), workspace.getRemote() + "/" + ".matlab");
            ByteArrayOutputStream kernelStream = new ByteArrayOutputStream();
            launcher.launch().cmds(new String[]{"uname"}).masks(new boolean[]{true}).stdout((OutputStream)kernelStream).join();
            String runnerName = uniqueName + "/run-matlab-command";
            String binaryName = kernelStream.toString("UTF-8").contains("Linux") ? "glnxa64/run-matlab-command" : "maci64/run-matlab-command";
            args.add(".matlab/" + runnerName);
            args.add(matlabCommand);
            args.add(startupOpts.split(" "));
            matlabLauncher = launcher.launch().envs((Map)envVars).cmds(args).stdout(listener);
            this.copyFileInWorkspace(binaryName, runnerName, targetWorkspace);
        } else {
            FilePath targetWorkspace = new FilePath(launcher.getChannel(), workspace.getRemote() + "\\" + ".matlab");
            String runnerName = uniqueName + "\\run-matlab-command.exe";
            args.add(new String[]{targetWorkspace.toString() + "\\" + runnerName, "\"" + matlabCommand + "\""});
            args.add(startupOpts.split(" "));
            matlabLauncher = launcher.launch().envs((Map)envVars).cmds(args).stdout(listener);
            this.copyFileInWorkspace("win64/run-matlab-command.exe", runnerName, targetWorkspace);
        }
        return matlabLauncher;
    }

    default public void copyFileInWorkspace(String sourceFile, String targetFile, FilePath targetWorkspace) throws IOException, InterruptedException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        FilePath targetFilePath = new FilePath(targetWorkspace, targetFile);
        InputStream in = classLoader.getResourceAsStream(sourceFile);
        targetFilePath.copyFrom(in);
        targetFilePath.chmod(493);
    }

    default public FilePath getFilePathForUniqueFolder(Launcher launcher, String uniqueName, FilePath workspace) throws IOException, InterruptedException {
        String tmpDir = workspace.getRemote() + "/" + ".matlab";
        return new FilePath(launcher.getChannel(), tmpDir + "/" + uniqueName);
    }

    default public String getUniqueNameForRunnerFile() {
        return RandomStringUtils.randomAlphanumeric((int)8);
    }

    default public void prepareTmpFldr(FilePath tmpFldr, String runnerScript) throws IOException, InterruptedException {
        this.copyFileInWorkspace("matlab-script-generator.zip", "matlab-script-generator.zip", tmpFldr);
        FilePath zipFileLocation = new FilePath(tmpFldr, "matlab-script-generator.zip");
        runnerScript = this.replaceZipPlaceholder(runnerScript, zipFileLocation.getRemote());
        FilePath scriptFile = new FilePath(tmpFldr, this.getValidMatlabFileName(tmpFldr.getBaseName()) + ".m");
        scriptFile.write(runnerScript, "UTF-8");
    }

    default public String replaceZipPlaceholder(String script, String url) {
        script = script.replace("${ZIP_FILE}", url.replaceAll("'", "''"));
        return script;
    }

    default public String getRunnerScript(String script, String params, String uniqueTmpFldrName) {
        script = script.replace("${PARAMS}", params);
        return script;
    }

    default public String getValidMatlabFileName(String actualName) {
        return "runner_" + actualName.replaceAll("-", "_");
    }
}

