/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.MatlabBuild;
import com.mathworks.ci.Message;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.io.FilenameUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class RunMatlabTestsBuilder
extends Builder
implements SimpleBuildStep,
MatlabBuild {
    private int buildResult;
    private EnvVars env;
    private transient boolean tapChkBx;
    private transient boolean junitChkBx;
    private transient boolean coberturaChkBx;
    private transient boolean stmResultsChkBx;
    private transient boolean modelCoverageChkBx;
    private transient boolean pdfReportChkBx;
    private Artifact tapArtifact = new NullArtifact();
    private Artifact junitArtifact = new NullArtifact();
    private Artifact coberturaArtifact = new NullArtifact();
    private Artifact stmResultsArtifact = new NullArtifact();
    private Artifact modelCoverageArtifact = new NullArtifact();
    private Artifact pdfReportArtifact = new NullArtifact();

    @DataBoundConstructor
    public RunMatlabTestsBuilder() {
    }

    @DataBoundSetter
    public void setTapArtifact(TapArtifact tapArtifact) {
        this.tapArtifact = tapArtifact;
    }

    @DataBoundSetter
    public void setJunitArtifact(JunitArtifact junitArtifact) {
        this.junitArtifact = junitArtifact;
    }

    @DataBoundSetter
    public void setCoberturaArtifact(CoberturaArtifact coberturaArtifact) {
        this.coberturaArtifact = coberturaArtifact;
    }

    @DataBoundSetter
    public void setStmResultsArtifact(StmResultsArtifact stmResultsArtifact) {
        this.stmResultsArtifact = stmResultsArtifact;
    }

    @DataBoundSetter
    public void setModelCoverageArtifact(ModelCovArtifact modelCoverageArtifact) {
        this.modelCoverageArtifact = modelCoverageArtifact;
    }

    @DataBoundSetter
    public void setPdfReportArtifact(PdfArtifact pdfReportArtifact) {
        this.pdfReportArtifact = pdfReportArtifact;
    }

    public String getTapReportFilePath() {
        return this.getTapArtifact().getFilePath();
    }

    public Artifact getTapArtifact() {
        return this.tapArtifact;
    }

    public Artifact getJunitArtifact() {
        return this.junitArtifact;
    }

    public String getJunitReportFilePath() {
        return this.getJunitArtifact().getFilePath();
    }

    public Artifact getCoberturaArtifact() {
        return this.coberturaArtifact;
    }

    public String getCoberturaReportFilePath() {
        return this.getCoberturaArtifact().getFilePath();
    }

    public Artifact getStmResultsArtifact() {
        return this.stmResultsArtifact;
    }

    public String getStmResultsFilePath() {
        return this.getStmResultsArtifact().getFilePath();
    }

    public Artifact getModelCoverageArtifact() {
        return this.modelCoverageArtifact;
    }

    public String getModelCoverageFilePath() {
        return this.getModelCoverageArtifact().getFilePath();
    }

    public Artifact getPdfReportArtifact() {
        return this.pdfReportArtifact;
    }

    public String getPdfReportFilePath() {
        return this.getPdfReportArtifact().getFilePath();
    }

    private Artifact getArtifactObject(boolean isChecked, Artifact returnVal) {
        return isChecked ? returnVal : new NullArtifact();
    }

    private void setEnv(EnvVars env) {
        this.env = env;
    }

    private EnvVars getEnv() {
        return this.env;
    }

    protected Object readResolve() {
        this.pdfReportArtifact = Optional.ofNullable(this.pdfReportArtifact).orElseGet(() -> this.getArtifactObject(this.pdfReportChkBx, new PdfArtifact("matlabTestArtifacts/testreport.pdf")));
        this.tapArtifact = Optional.ofNullable(this.tapArtifact).orElseGet(() -> this.getArtifactObject(this.tapChkBx, new TapArtifact("matlabTestArtifacts/taptestresults.tap")));
        this.junitArtifact = Optional.ofNullable(this.junitArtifact).orElseGet(() -> this.getArtifactObject(this.junitChkBx, new JunitArtifact("matlabTestArtifacts/junittestresults.xml")));
        this.coberturaArtifact = Optional.ofNullable(this.coberturaArtifact).orElseGet(() -> this.getArtifactObject(this.coberturaChkBx, new CoberturaArtifact("matlabTestArtifacts/cobertura.xml")));
        this.stmResultsArtifact = Optional.ofNullable(this.stmResultsArtifact).orElseGet(() -> this.getArtifactObject(this.stmResultsChkBx, new StmResultsArtifact("matlabTestArtifacts/simulinktestresults.mldatx")));
        this.modelCoverageArtifact = Optional.ofNullable(this.modelCoverageArtifact).orElseGet(() -> this.getArtifactObject(this.modelCoverageChkBx, new ModelCovArtifact("matlabTestArtifacts/coberturamodelcoverage.xml")));
        return this;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.setEnv(build.getEnvironment(listener));
        this.buildResult = this.execMatlabCommand(workspace, launcher, listener, this.getEnv());
        if (this.buildResult != 0) {
            build.setResult(Result.FAILURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int execMatlabCommand(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        String uniqueTmpFldrName = this.getUniqueNameForRunnerFile();
        try {
            Launcher.ProcStarter matlabLauncher = this.getProcessToRunMatlabCommand(workspace, launcher, listener, envVars, this.constructCommandForTest(this.getInputArguments()), uniqueTmpFldrName);
            FilePath targetWorkspace = new FilePath(launcher.getChannel(), workspace.getRemote());
            this.copyFileInWorkspace("com/mathworks/ci/RunMatlabTestsBuilder/runMatlabTests.m", "runMatlabTests.m", targetWorkspace);
            int n = matlabLauncher.pwd(workspace).join();
            return n;
        }
        catch (Exception e) {
            listener.getLogger().println(e.getMessage());
            int n = 1;
            return n;
        }
        finally {
            FilePath matlabRunnerScript = this.getFilePathForUniqueFolder(launcher, uniqueTmpFldrName, workspace);
            if (matlabRunnerScript.exists()) {
                matlabRunnerScript.deleteRecursive();
            }
        }
    }

    public String constructCommandForTest(String inputArguments) {
        String matlabFunctionName = FilenameUtils.removeExtension((String)"runMatlabTests.m");
        String runCommand = "exit(" + matlabFunctionName + "(" + inputArguments + "))";
        return runCommand;
    }

    private String getInputArguments() {
        ArrayList inputArgsList = new ArrayList();
        HashMap<String, String> args = new HashMap<String, String>();
        ArrayList<Artifact> artifactList = new ArrayList<Artifact>(Arrays.asList(this.getPdfReportArtifact(), this.getTapArtifact(), this.getJunitArtifact(), this.getStmResultsArtifact(), this.getCoberturaArtifact(), this.getModelCoverageArtifact()));
        for (Artifact artifact : artifactList) {
            artifact.addFilePathArgTo(args);
        }
        args.forEach((key, val) -> inputArgsList.add("'" + key + "','" + val + "'"));
        return String.join((CharSequence)",", inputArgsList);
    }

    public static interface Artifact {
        public void addFilePathArgTo(Map<String, String> var1);

        public String getFilePath();

        public boolean getSelected();
    }

    public static abstract class AbstractArtifactImpl
    implements Artifact {
        private String filePath;

        protected AbstractArtifactImpl(String path) {
            this.filePath = path;
        }

        @Override
        public boolean getSelected() {
            return true;
        }

        public void setFilePath(String path) {
            this.filePath = path;
        }

        @Override
        public String getFilePath() {
            return this.filePath;
        }
    }

    public static class NullArtifact
    implements Artifact {
        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
        }

        @Override
        public boolean getSelected() {
            return false;
        }

        @Override
        public String getFilePath() {
            return null;
        }
    }

    public static class ModelCovArtifact
    extends AbstractArtifactImpl {
        private static final String COBERTURA_MODEL_COVERAGE_PATH = "CoberturaModelCoveragePath";

        @DataBoundConstructor
        public ModelCovArtifact(String modelCoverageFilePath) {
            super(modelCoverageFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(COBERTURA_MODEL_COVERAGE_PATH, this.getFilePath());
        }
    }

    public static class StmResultsArtifact
    extends AbstractArtifactImpl {
        private static final String STM_RESULTS_PATH = "SimulinkTestResultsPath";

        @DataBoundConstructor
        public StmResultsArtifact(String stmResultsFilePath) {
            super(stmResultsFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(STM_RESULTS_PATH, this.getFilePath());
        }
    }

    public static class CoberturaArtifact
    extends AbstractArtifactImpl {
        private static final String COBERTURA_CODE_COVERAGE_PATH = "CoberturaCodeCoveragePath";

        @DataBoundConstructor
        public CoberturaArtifact(String coberturaReportFilePath) {
            super(coberturaReportFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(COBERTURA_CODE_COVERAGE_PATH, this.getFilePath());
        }
    }

    public static class JunitArtifact
    extends AbstractArtifactImpl {
        private static final String JUNIT_RESULTS_PATH = "JUnitResultsPath";

        @DataBoundConstructor
        public JunitArtifact(String junitReportFilePath) {
            super(junitReportFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(JUNIT_RESULTS_PATH, this.getFilePath());
        }
    }

    public static class TapArtifact
    extends AbstractArtifactImpl {
        private static final String TAP_RESULTS_PATH = "TAPResultsPath";

        @DataBoundConstructor
        public TapArtifact(String tapReportFilePath) {
            super(tapReportFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(TAP_RESULTS_PATH, this.getFilePath());
        }
    }

    public static class PdfArtifact
    extends AbstractArtifactImpl {
        private static final String PDF_REPORT_PATH = "PDFReportPath";

        @DataBoundConstructor
        public PdfArtifact(String pdfReportFilePath) {
            super(pdfReportFilePath);
        }

        @Override
        public void addFilePathArgTo(Map<String, String> inputArgs) {
            inputArgs.put(PDF_REPORT_PATH, this.getFilePath());
        }
    }

    @Extension
    public static class RunMatlabTestsDescriptor
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return Message.getBuilderDisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobtype) {
            return true;
        }
    }
}

