/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.google.common.collect.ImmutableSet;
import com.mathworks.ci.MatlabRunTestsStepExecution;
import com.mathworks.ci.Message;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class RunMatlabTestsStep
extends Step {
    private String testResultsPDF;
    private String testResultsTAP;
    private String testResultsJUnit;
    private String codeCoverageCobertura;
    private String testResultsSimulinkTest;
    private String modelCoverageCobertura;

    @DataBoundConstructor
    public RunMatlabTestsStep() {
    }

    public String getTestResultsTAP() {
        return this.testResultsTAP;
    }

    @DataBoundSetter
    public void setTestResultsTAP(String testResultsTAP) {
        this.testResultsTAP = testResultsTAP;
    }

    public String getTestResultsPDF() {
        return this.testResultsPDF;
    }

    @DataBoundSetter
    public void setTestResultsPDF(String testResultsPDF) {
        this.testResultsPDF = testResultsPDF;
    }

    public String getTestResultsJUnit() {
        return this.testResultsJUnit;
    }

    @DataBoundSetter
    public void setTestResultsJUnit(String testResultsJUnit) {
        this.testResultsJUnit = testResultsJUnit;
    }

    public String getCodeCoverageCobertura() {
        return this.codeCoverageCobertura;
    }

    @DataBoundSetter
    public void setCodeCoverageCobertura(String codeCoverageCobertura) {
        this.codeCoverageCobertura = codeCoverageCobertura;
    }

    public String getTestResultsSimulinkTest() {
        return this.testResultsSimulinkTest;
    }

    @DataBoundSetter
    public void setTestResultsSimulinkTest(String testResultsSimulinkTest) {
        this.testResultsSimulinkTest = testResultsSimulinkTest;
    }

    public String getModelCoverageCobertura() {
        return this.modelCoverageCobertura;
    }

    @DataBoundSetter
    public void setModelCoverageCobertura(String modelCoverageCobertura) {
        this.modelCoverageCobertura = modelCoverageCobertura;
    }

    public StepExecution start(StepContext context) throws Exception {
        Launcher launcher = (Launcher)context.get(Launcher.class);
        FilePath workspace = (FilePath)context.get(FilePath.class);
        FilePath targetWorkspace = new FilePath(launcher.getChannel(), workspace.getRemote());
        this.copyScratchFileInWorkspace("com/mathworks/ci/RunMatlabTestsBuilder/runMatlabTests.m", "runMatlabTests.m", targetWorkspace);
        return new MatlabRunTestsStepExecution(context, this.constructCommandForTest(this.getInputArgs()));
    }

    public String constructCommandForTest(String inputArguments) {
        String matlabFunctionName = FilenameUtils.removeExtension((String)"runMatlabTests.m");
        String runCommand = "exit(" + matlabFunctionName + "(" + inputArguments + "))";
        return runCommand;
    }

    private String getInputArgs() {
        ArrayList inputArgs = new ArrayList();
        Map<String, String> args = this.getMatlabArgs();
        args.forEach((key, val) -> {
            if (val != null) {
                inputArgs.add("'" + key + "','" + val.replaceAll("'", "''") + "'");
            }
        });
        if (inputArgs.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)",", inputArgs);
    }

    private Map<String, String> getMatlabArgs() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("PDFReportPath", this.getTestResultsPDF());
        args.put("TAPResultsPath", this.getTestResultsTAP());
        args.put("JUnitResultsPath", this.getTestResultsJUnit());
        args.put("SimulinkTestResultsPath", this.getTestResultsSimulinkTest());
        args.put("CoberturaCodeCoveragePath", this.getCodeCoverageCobertura());
        args.put("CoberturaModelCoveragePath", this.getModelCoverageCobertura());
        return args;
    }

    private void copyScratchFileInWorkspace(String sourceFile, String targetFile, FilePath targetWorkspace) throws IOException, InterruptedException {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        FilePath targetFilePath = new FilePath(targetWorkspace, targetFile);
        InputStream in = classLoader.getResourceAsStream(sourceFile);
        targetFilePath.copyFrom(in);
        targetFilePath.chmod(493);
    }

    @Extension
    public static class RunTestsStepDescriptor
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, FilePath.class, Launcher.class, EnvVars.class, Run.class);
        }

        public String getFunctionName() {
            return Message.getValue("matlab.tests.build.step.name");
        }

        public String getDisplayName() {
            return Message.getValue("matlab.tests.step.display.name");
        }
    }
}

