/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.MatlabBuild;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public class MatlabRunTestsStepExecution
extends StepExecution
implements MatlabBuild {
    private static final long serialVersionUID = 6704588180717665100L;
    private String command;

    public MatlabRunTestsStepExecution(StepContext context, String command) {
        super(context);
        this.command = command;
    }

    private String getCommand() {
        return this.command;
    }

    public boolean start() throws Exception {
        Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        EnvVars env = (EnvVars)this.getContext().get(EnvVars.class);
        workspace.mkdirs();
        int res = this.execMatlabCommand(workspace, launcher, listener, env);
        this.getContext().setResult(res == 0 ? Result.SUCCESS : Result.FAILURE);
        this.getContext().onSuccess((Object)true);
        return false;
    }

    public void stop(Throwable cause) throws Exception {
        this.getContext().onFailure(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int execMatlabCommand(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        String uniqueTmpFldrName = this.getUniqueNameForRunnerFile();
        try {
            Launcher.ProcStarter matlabLauncher = this.getProcessToRunMatlabCommand(workspace, launcher, listener, envVars, envVars.expand(this.getCommand()), uniqueTmpFldrName);
            int n = matlabLauncher.pwd(workspace).join();
            return n;
        }
        catch (Exception e) {
            listener.getLogger().println(e.getMessage());
            int n = 1;
            return n;
        }
        finally {
            FilePath matlabRunnerScript = this.getFilePathForUniqueFolder(launcher, uniqueTmpFldrName, workspace);
            if (matlabRunnerScript.exists()) {
                matlabRunnerScript.deleteRecursive();
            }
        }
    }
}

