/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.Message;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;

public interface MatlabBuild {
    default public Launcher.ProcStarter getProcessToRunMatlabCommand(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars, String matlabCommand, String uniqueName) throws IOException, InterruptedException {
        Launcher.ProcStarter matlabLauncher;
        String tmpDir = this.getNodeSpecificTmpFolderPath(workspace);
        FilePath targetWorkspace = new FilePath(launcher.getChannel(), tmpDir);
        if (launcher.isUnix()) {
            String runnerScriptName = uniqueName + "/run_matlab_command.sh";
            matlabLauncher = launcher.launch().pwd(workspace).envs((Map)envVars).cmds(new String[]{tmpDir + "/" + runnerScriptName, matlabCommand}).stdout(listener);
            this.copyFileInWorkspace("run_matlab_command.sh", runnerScriptName, targetWorkspace);
        } else {
            String runnerScriptName = uniqueName + "\\run_matlab_command.bat";
            launcher = launcher.decorateByPrefix(new String[]{"cmd.exe", "/C"});
            matlabLauncher = launcher.launch().pwd(workspace).envs((Map)envVars).cmds(new String[]{tmpDir + "\\" + runnerScriptName, "\"" + matlabCommand + "\""}).stdout(listener);
            this.copyFileInWorkspace("run_matlab_command.bat", runnerScriptName, targetWorkspace);
        }
        return matlabLauncher;
    }

    default public void copyFileInWorkspace(String sourceFile, String targetFile, FilePath targetWorkspace) throws IOException, InterruptedException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        FilePath targetFilePath = new FilePath(targetWorkspace, targetFile);
        InputStream in = classLoader.getResourceAsStream(sourceFile);
        targetFilePath.copyFrom(in);
        targetFilePath.chmod(493);
    }

    default public FilePath getFilePathForUniqueFolder(Launcher launcher, String uniqueName, FilePath workspace) throws IOException, InterruptedException {
        String tmpDir = this.getNodeSpecificTmpFolderPath(workspace);
        return new FilePath(launcher.getChannel(), tmpDir + "/" + uniqueName);
    }

    default public String getNodeSpecificTmpFolderPath(FilePath workspace) throws IOException, InterruptedException {
        Computer cmp = workspace.toComputer();
        if (cmp == null) {
            throw new IOException(Message.getValue("build.workspace.computer.not.found"));
        }
        String tmpDir = (String)cmp.getSystemProperties().get("java.io.tmpdir");
        return tmpDir;
    }

    default public String getUniqueNameForRunnerFile() {
        return UUID.randomUUID().toString();
    }
}

