/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis.soap.mantis120;

import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisSite;
import hudson.plugins.mantis.model.MantisCategory;
import hudson.plugins.mantis.model.MantisIssue;
import hudson.plugins.mantis.model.MantisNote;
import hudson.plugins.mantis.model.MantisProject;
import hudson.plugins.mantis.soap.AbstractMantisSession;
import hudson.plugins.mantis.soap.mantis120.IssueData;
import hudson.plugins.mantis.soap.mantis120.IssueNoteData;
import hudson.plugins.mantis.soap.mantis120.MantisConnectLocator;
import hudson.plugins.mantis.soap.mantis120.MantisConnectPortType;
import hudson.plugins.mantis.soap.mantis120.ObjectRef;
import hudson.plugins.mantis.soap.mantis120.ProjectData;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisProperties;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.AxisClient;
import org.apache.axis.client.Stub;

public final class MantisSessionImpl
extends AbstractMantisSession {
    private final MantisConnectPortType portType;
    private static final Logger LOGGER = Logger.getLogger(MantisSessionImpl.class.getName());

    public MantisSessionImpl(MantisSite site) throws MantisHandlingException {
        LOGGER.info("Mantis version is 1.2.X");
        this.site = site;
        try {
            URL endpoint = new URL(site.getUrl(), "api/soap/mantisconnect.php");
            MantisConnectLocator locator = new MantisConnectLocator();
            EngineConfiguration config = this.createClientConfig();
            locator.setEngineConfiguration(config);
            locator.setEngine((AxisEngine)new AxisClient(config));
            this.portType = locator.getMantisConnectPort(endpoint);
            if (site.getBasicUserName() != null && site.getPlainBasicPassword() != null) {
                ((Stub)this.portType).setUsername(site.getBasicUserName());
                ((Stub)this.portType).setPassword(site.getPlainBasicPassword());
            }
            AxisProperties.setProperty((String)"axis.socketSecureFactory", (String)"org.apache.axis.components.net.SunFakeTrustSocketFactory");
        }
        catch (ServiceException e) {
            throw new MantisHandlingException(e);
        }
        catch (MalformedURLException e) {
            throw new MantisHandlingException(e);
        }
    }

    @Override
    public MantisIssue getIssue(int id) throws MantisHandlingException {
        IssueData data;
        try {
            data = this.portType.mc_issue_get(this.site.getUserName(), this.site.getPlainPassword(), BigInteger.valueOf(id));
        }
        catch (RemoteException e) {
            throw new MantisHandlingException(e);
        }
        return new MantisIssue(id, data.getSummary());
    }

    @Override
    public void addNote(int id, MantisNote note) throws MantisHandlingException {
        IssueNoteData data = new IssueNoteData();
        data.setText(note.getText());
        data.setView_state(new ObjectRef(BigInteger.valueOf(note.getViewState().getCode()), null));
        try {
            this.portType.mc_issue_note_add(this.site.getUserName(), this.site.getPlainPassword(), BigInteger.valueOf(id), data);
        }
        catch (RemoteException e) {
            throw new MantisHandlingException(e);
        }
    }

    @Override
    public String getVersion() throws MantisHandlingException {
        String version;
        try {
            version = this.portType.mc_version();
        }
        catch (RemoteException e) {
            throw new MantisHandlingException(e);
        }
        return version;
    }

    @Override
    public List<MantisProject> getProjects() throws MantisHandlingException {
        ProjectData[] data;
        ArrayList<MantisProject> projects = new ArrayList<MantisProject>();
        try {
            data = this.portType.mc_projects_get_user_accessible(this.site.getUserName(), this.site.getPlainPassword());
        }
        catch (RemoteException e) {
            throw new MantisHandlingException(e);
        }
        for (ProjectData p : data) {
            MantisProject mp = new MantisProject(p.getId().intValue(), p.getName(), this.subProjects(p));
            projects.add(mp);
        }
        return projects;
    }

    private List<MantisProject> subProjects(ProjectData p) {
        ProjectData[] subs;
        ArrayList<MantisProject> list = new ArrayList<MantisProject>();
        for (ProjectData sub : subs = p.getSubprojects()) {
            MantisProject mp = new MantisProject(sub.getId().intValue(), sub.getName(), this.subProjects(sub));
            list.add(mp);
        }
        return list;
    }

    @Override
    public List<MantisCategory> getCategories(int projectId) throws MantisHandlingException {
        String[] list;
        ArrayList<MantisCategory> categories = new ArrayList<MantisCategory>();
        try {
            list = this.portType.mc_project_get_categories(this.site.getUserName(), this.site.getPlainPassword(), BigInteger.valueOf(projectId));
        }
        catch (RemoteException e) {
            throw new MantisHandlingException(e);
        }
        for (String category : list) {
            categories.add(new MantisCategory(category));
        }
        return categories;
    }

    @Override
    public int addIssue(MantisIssue issue) throws MantisHandlingException {
        if (issue == null) {
            throw new MantisHandlingException("issue should not be null.");
        }
        IssueData data = new IssueData();
        MantisProject project = issue.getProject();
        if (project == null) {
            throw new MantisHandlingException("project is missing.");
        }
        MantisCategory category = issue.getCategory();
        if (category == null) {
            throw new MantisHandlingException("category is missing.");
        }
        ObjectRef pRef = new ObjectRef(BigInteger.valueOf(project.getId()), project.getName());
        data.setProject(pRef);
        data.setCategory(category.getName());
        data.setSummary(issue.getSummary());
        data.setDescription(issue.getDescription());
        ObjectRef viewStateRef = new ObjectRef(BigInteger.valueOf(issue.getViewState().getCode()), null);
        data.setView_state(viewStateRef);
        BigInteger addedIssueNo = null;
        try {
            addedIssueNo = this.portType.mc_issue_add(this.site.getUserName(), this.site.getPlainPassword(), data);
        }
        catch (RemoteException e) {
            throw new MantisHandlingException(e);
        }
        return addedIssueNo.intValue();
    }
}

