/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis.changeset;

import hudson.model.AbstractBuild;
import hudson.plugins.mantis.changeset.AbstractChangeSet;
import hudson.plugins.mantis.changeset.ChangeSetUtil;
import hudson.plugins.mantis.changeset.Messages;
import hudson.scm.EditType;
import hudson.scm.SubversionChangeLogSet;
import java.util.ArrayList;
import java.util.List;

public class SubversionChangeSet
extends AbstractChangeSet<SubversionChangeLogSet.LogEntry> {
    private static final long serialVersionUID = 1L;

    public SubversionChangeSet(int id, AbstractBuild<?, ?> build, SubversionChangeLogSet.LogEntry entry) {
        super(id, build, entry);
    }

    @Override
    public String createChangeLog() {
        StringBuilder text = new StringBuilder();
        text.append(Messages.ChangeSet_Revision(this.getRevision(), this.getChangeSetLink()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_Author(this.getAuthor()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_Log(this.getMsg()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_ChangedPaths_Header());
        text.append(CRLF);
        for (AffectedPath path : this.getAffectedPaths()) {
            text.append(Messages.ChangeSet_ChangedPaths_Path(path.getMark(), path.getPath()));
            text.append(CRLF);
        }
        text.append(CRLF);
        return text.toString();
    }

    protected String getRevision() {
        return String.valueOf(((SubversionChangeLogSet.LogEntry)this.entry).getRevision());
    }

    private List<AffectedPath> getAffectedPaths() {
        ArrayList<AffectedPath> paths = new ArrayList<AffectedPath>();
        for (SubversionChangeLogSet.Path path : ((SubversionChangeLogSet.LogEntry)this.entry).getPaths()) {
            paths.add(new AffectedPath(path.getEditType(), path.getValue()));
        }
        return paths;
    }

    private static class AffectedPath {
        private final String mark;
        private final String path;

        public AffectedPath(EditType type, String path) {
            this.path = path;
            this.mark = ChangeSetUtil.getEditTypeMark(type);
        }

        public String getMark() {
            return this.mark;
        }

        public String getPath() {
            return this.path;
        }
    }
}

