/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis.changeset;

import hudson.model.AbstractBuild;
import hudson.plugins.mantis.changeset.AbstractChangeSet;
import hudson.plugins.mantis.changeset.Messages;
import java.util.Collection;

public class GitChangeSet
extends AbstractChangeSet<hudson.plugins.git.GitChangeSet> {
    private static final long serialVersionUID = 1L;

    public GitChangeSet(int id, AbstractBuild<?, ?> build, hudson.plugins.git.GitChangeSet entry) {
        super(id, build, entry);
    }

    @Override
    public String createChangeLog() {
        StringBuilder text = new StringBuilder();
        text.append(Messages.ChangeSet_Revision(this.getRevision(), this.getChangeSetLink()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_Author(this.getAuthor()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_Log(this.getMsg()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_ChangedPaths_Header());
        text.append(CRLF);
        for (String path : this.getAffectedPaths()) {
            text.append(Messages.ChangeSet_ChangedPaths_Path("", path));
            text.append(CRLF);
        }
        text.append(CRLF);
        return text.toString();
    }

    protected String getRevision() {
        return String.valueOf(((hudson.plugins.git.GitChangeSet)this.entry).getId());
    }

    private Collection<String> getAffectedPaths() {
        return ((hudson.plugins.git.GitChangeSet)this.entry).getAffectedPaths();
    }
}

