/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis.changeset;

import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.plugins.mantis.changeset.CVSChangeSet;
import hudson.plugins.mantis.changeset.ChangeSet;
import hudson.plugins.mantis.changeset.CompatibleChangeSet;
import hudson.plugins.mantis.changeset.DefaultChangeSet;
import hudson.plugins.mantis.changeset.GitChangeSet;
import hudson.plugins.mantis.changeset.MercurialChangeSet;
import hudson.plugins.mantis.changeset.SubversionChangeSet;
import hudson.scm.CVSChangeLogSet;
import hudson.scm.ChangeLogSet;
import hudson.scm.SubversionChangeLogSet;

public final class ChangeSetFactory {
    private ChangeSetFactory() {
    }

    public static ChangeSet newInstance(int id) {
        return new CompatibleChangeSet(id);
    }

    public static ChangeSet newInstance(int id, AbstractBuild<?, ?> build, ChangeLogSet.Entry entry) {
        if (build == null || entry == null) {
            throw new IllegalArgumentException();
        }
        Hudson hudson = Hudson.getInstance();
        if (hudson.getPlugin("cvs") != null && entry instanceof CVSChangeLogSet.CVSChangeLog) {
            return new CVSChangeSet(id, build, (CVSChangeLogSet.CVSChangeLog)entry);
        }
        if (hudson.getPlugin("subversion") != null && entry instanceof SubversionChangeLogSet.LogEntry) {
            return new SubversionChangeSet(id, build, (SubversionChangeLogSet.LogEntry)entry);
        }
        if (hudson.getPlugin("mercurial") != null && entry instanceof hudson.plugins.mercurial.MercurialChangeSet) {
            return new MercurialChangeSet(id, build, (hudson.plugins.mercurial.MercurialChangeSet)entry);
        }
        if (hudson.getPlugin("git") != null && entry instanceof hudson.plugins.git.GitChangeSet) {
            return new GitChangeSet(id, build, (hudson.plugins.git.GitChangeSet)entry);
        }
        return new DefaultChangeSet(id, build, entry);
    }
}

