/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis.changeset;

import hudson.model.AbstractBuild;
import hudson.model.User;
import hudson.plugins.mantis.changeset.ChangeSet;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.logging.Logger;

public abstract class AbstractChangeSet<T extends ChangeLogSet.Entry>
implements ChangeSet,
Serializable {
    protected int id;
    protected AbstractBuild<?, ?> build;
    protected T entry;
    private static final Logger LOGGER = Logger.getLogger(AbstractChangeSet.class.getName());

    public AbstractChangeSet(int id, AbstractBuild<?, ?> build, T entry) {
        this.id = id;
        this.build = build;
        this.entry = entry;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public abstract String createChangeLog();

    protected RepositoryBrowser getRepositoryBrowser() {
        if (this.build == null || this.build.getProject() == null) {
            return null;
        }
        SCM scm = this.build.getProject().getScm();
        return scm.getBrowser();
    }

    protected String getChangeSetLink() {
        RepositoryBrowser browser = this.getRepositoryBrowser();
        if (browser == null) {
            return "";
        }
        String link = "";
        try {
            URL url = browser.getChangeSetLink(this.entry);
            if (url != null) {
                link = url.toString();
            }
        }
        catch (IOException e) {
            LOGGER.warning(e.getMessage());
        }
        return link;
    }

    protected String getAuthor() {
        User user = this.entry.getAuthor();
        if (user == null) {
            return "-";
        }
        return user.getId();
    }

    protected String getMsg() {
        if (this.entry == null) {
            return "-";
        }
        return this.entry.getMsg();
    }
}

