/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisProjectProperty;
import hudson.plugins.mantis.Messages;
import hudson.plugins.mantis.model.MantisCategory;
import hudson.plugins.mantis.model.MantisIssue;
import hudson.plugins.mantis.model.MantisNote;
import hudson.plugins.mantis.model.MantisProject;
import hudson.plugins.mantis.model.MantisViewState;
import hudson.plugins.mantis.soap.MantisSession;
import hudson.plugins.mantis.soap.MantisSessionFactory;
import hudson.util.Secret;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public final class MantisSite {
    private final URL url;
    private MantisVersion version = MantisVersion.V110;
    private final String userName;
    @Deprecated
    private String password;
    private Secret secretPassword;
    private final String basicUserName;
    @Deprecated
    private String basicPassword;
    private Secret secretBasicPassword;
    private static final Logger LOGGER = Logger.getLogger(MantisSite.class.getName());

    public static MantisSite get(AbstractProject<?, ?> p) {
        MantisSite site;
        MantisProjectProperty mpp = (MantisProjectProperty)p.getProperty(MantisProjectProperty.class);
        if (mpp != null && (site = mpp.getSite()) != null) {
            return site;
        }
        MantisSite[] sites = MantisProjectProperty.DESCRIPTOR.getSites();
        if (sites.length == 1) {
            return sites[0];
        }
        return null;
    }

    public URL getUrl() {
        return this.url;
    }

    public MantisVersion getVersion() {
        return this.version;
    }

    public String getUserName() {
        return this.userName;
    }

    @Deprecated
    public String getPassword() {
        return this.password;
    }

    public String getPlainPassword() {
        return Secret.toString((Secret)this.secretPassword);
    }

    public Secret getSecretPassword() {
        return this.secretPassword;
    }

    public String getName() {
        return this.url.toExternalForm();
    }

    public String getBasicUserName() {
        return this.basicUserName;
    }

    @Deprecated
    public String getBasicPassword() {
        return this.basicPassword;
    }

    public String getPlainBasicPassword() {
        return Secret.toString((Secret)this.secretBasicPassword);
    }

    public Secret getSecretBasicPassword() {
        return this.secretBasicPassword;
    }

    @DataBoundConstructor
    public MantisSite(URL url, String version, String userName, String password, String basicUserName, String basicPassword) {
        if (!url.toExternalForm().endsWith("/")) {
            try {
                this.url = new URL(url.toExternalForm() + '/');
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            this.url = url;
        }
        this.version = MantisVersion.getVersionSafely(version, MantisVersion.V110);
        this.userName = Util.fixEmptyAndTrim((String)userName);
        this.secretPassword = Secret.fromString((String)Util.fixEmptyAndTrim((String)password));
        this.basicUserName = Util.fixEmptyAndTrim((String)basicUserName);
        this.secretBasicPassword = Secret.fromString((String)Util.fixEmptyAndTrim((String)basicPassword));
    }

    public String getIssueLink(int issueNo) {
        String u = this.getUrl().toExternalForm();
        return String.format("%sview.php?id=%d", u, issueNo);
    }

    public boolean isConnect() {
        String urlString = this.url.toExternalForm();
        try {
            MantisSession session = this.createSession();
            List<MantisProject> list = session.getProjects();
        }
        catch (MantisHandlingException e) {
            LOGGER.log(Level.WARNING, Messages.MantisSite_FailedToConnectToMantis(urlString, e.getMessage()));
            return false;
        }
        LOGGER.log(Level.INFO, Messages.MantisSite_SucceedInConnectingToMantis(urlString));
        return true;
    }

    public MantisIssue getIssue(int id) throws MantisHandlingException {
        MantisSession session = this.createSession();
        return session.getIssue(id);
    }

    public void updateIssue(int id, String text, boolean keepNotePrivate) throws MantisHandlingException {
        MantisViewState viewState = keepNotePrivate ? MantisViewState.PRIVATE : MantisViewState.PUBLIC;
        MantisNote note = new MantisNote(text, viewState);
        MantisSession session = this.createSession();
        session.addNote(id, note);
    }

    public List<MantisProject> getProjects() throws MantisHandlingException {
        MantisSession session = this.createSession();
        return session.getProjects();
    }

    public List<MantisCategory> getCategories(int projectId) throws MantisHandlingException {
        MantisSession session = this.createSession();
        return session.getCategories(projectId);
    }

    public int addIssue(MantisIssue issue) throws MantisHandlingException {
        MantisSession session = this.createSession();
        return session.addIssue(issue);
    }

    private MantisSession createSession() throws MantisHandlingException {
        return MantisSessionFactory.getSession(this);
    }

    protected Object readResolve() {
        if (this.password != null) {
            this.secretPassword = Secret.fromString((String)this.password);
            this.password = null;
        }
        if (this.basicPassword != null) {
            this.secretBasicPassword = Secret.fromString((String)this.basicPassword);
            this.basicPassword = null;
        }
        return this;
    }

    public static enum MantisVersion {
        V110(Messages.MantisSite_MantisVersion_V110()),
        V120(Messages.MantisSite_MantisVersion_V120());

        private final String displayName;

        private MantisVersion(String displayName) {
            this.displayName = displayName;
        }

        public static MantisVersion getVersionSafely(String version, MantisVersion def) {
            MantisVersion ret = def;
            for (MantisVersion v : MantisVersion.values()) {
                if (!v.name().equalsIgnoreCase(version)) continue;
                ret = v;
                break;
            }
            return ret;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

