/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.Extension;
import hudson.Util;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisSite;
import hudson.plugins.mantis.Messages;
import hudson.plugins.mantis.Utility;
import hudson.plugins.mantis.model.MantisCategory;
import hudson.plugins.mantis.model.MantisProject;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public final class MantisProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final String ISSUE_ID_STRING = "%ID%";
    private static final String DEFAULT_PATTERN = "issue #?%ID%";
    private final String siteName;
    private final int projectId;
    private final String category;
    private final String pattern;
    private final String regex;
    private Pattern regexpPattern;
    private final boolean linkEnabled;

    public static MantisProjectProperty get(AbstractBuild<?, ?> build) {
        if (build == null) {
            return null;
        }
        Object job = build instanceof MatrixRun ? ((MatrixConfiguration)((MatrixRun)build).getProject()).getParent() : build.getProject();
        return (MantisProjectProperty)job.getProperty(MantisProjectProperty.class);
    }

    @DataBoundConstructor
    public MantisProjectProperty(String siteName, int projectId, String category, String pattern, String regex, boolean linkEnabled) {
        String name = siteName != null ? siteName : this.defaultSiteName();
        this.siteName = Util.fixEmptyAndTrim((String)name);
        this.projectId = projectId;
        this.category = Util.fixEmptyAndTrim((String)category);
        this.pattern = Util.fixEmptyAndTrim((String)pattern);
        this.regex = Util.fixEmptyAndTrim((String)regex);
        this.regexpPattern = this.regex != null ? Pattern.compile(this.regex) : this.createRegexp(this.pattern);
        this.linkEnabled = linkEnabled;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public String getCategory() {
        return this.category;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getRegex() {
        return this.regex;
    }

    public Pattern getRegexpPattern() {
        if (this.regexpPattern == null) {
            return this.createRegexp(this.pattern);
        }
        return this.regexpPattern;
    }

    public boolean isLinkEnabled() {
        return this.linkEnabled;
    }

    public MantisSite getSite() {
        MantisSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (MantisSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    private String defaultSiteName() {
        MantisSite[] sites = DESCRIPTOR.getSites();
        if (sites.length > 0) {
            return sites[0].getName();
        }
        return null;
    }

    private Pattern createRegexp(String p) {
        StringBuffer buf = new StringBuffer();
        buf.append("(?<=");
        if (p != null) {
            buf.append(Utility.escapeRegexp(p));
        } else {
            buf.append(DEFAULT_PATTERN);
        }
        buf.append(')');
        String pt = buf.toString().replace(ISSUE_ID_STRING, ")(\\d+)(?=");
        return Pattern.compile(pt);
    }

    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private final CopyOnWriteList<MantisSite> sites = new CopyOnWriteList();

        public DescriptorImpl() {
            super(MantisProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return Messages.MantisProjectProperty_DisplayName();
        }

        public MantisSite[] getSites() {
            return (MantisSite[])this.sites.toArray((Object[])new MantisSite[0]);
        }

        void addSite(MantisSite site) {
            this.sites.add((Object)site);
        }

        public MantisSite.MantisVersion[] getMantisVersions() {
            return MantisSite.MantisVersion.values();
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            MantisProjectProperty mpp = (MantisProjectProperty)((Object)req.bindJSON(MantisProjectProperty.class, formData));
            if (mpp.siteName == null) {
                mpp = null;
            }
            return mpp;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            this.sites.replaceBy((Collection)req.bindParametersToList(MantisSite.class, "m."));
            this.save();
            return true;
        }

        public ListBoxModel doFillSiteNameItems() {
            ListBoxModel m = new ListBoxModel();
            for (MantisSite site : this.getSites()) {
                m.add(site.getName());
            }
            return m;
        }

        public ListBoxModel doFillProjectIdItems(@QueryParameter String siteName) {
            List<MantisProject> projects;
            ListBoxModel model = new ListBoxModel();
            model.add("-", String.valueOf(-1));
            MantisSite site = null;
            for (MantisSite s : this.sites) {
                if (!s.getName().equals(siteName)) continue;
                site = s;
                break;
            }
            if (site == null) {
                return model;
            }
            try {
                projects = site.getProjects();
            }
            catch (MantisHandlingException e) {
                return model;
            }
            for (MantisProject p : projects) {
                model.add(p.getName(), "" + p.getId());
                for (MantisProjectItem sub : this.subProjects(p, 1)) {
                    model.add(sub.getName(), sub.getId());
                }
            }
            return model;
        }

        private List<MantisProjectItem> subProjects(MantisProject p, int depth) {
            ArrayList<MantisProjectItem> list = new ArrayList<MantisProjectItem>();
            for (MantisProject sub : p.getSubProjects()) {
                list.add(new MantisProjectItem(StringUtils.repeat((String)"\u00bb ", (int)depth) + sub.getName(), "" + sub.getId()));
                list.addAll(this.subProjects(sub, depth + 1));
            }
            return list;
        }

        public ListBoxModel doFillCategoryItems(@QueryParameter String siteName, @QueryParameter int projectId) {
            List<MantisCategory> categories;
            ListBoxModel model = new ListBoxModel();
            model.add("-", "Not Selected");
            if (projectId == -1) {
                return model;
            }
            MantisSite site = null;
            for (MantisSite s : this.sites) {
                if (!s.getName().equals(siteName)) continue;
                site = s;
                break;
            }
            if (site == null) {
                return model;
            }
            try {
                categories = site.getCategories(projectId);
            }
            catch (MantisHandlingException e) {
                return model;
            }
            for (MantisCategory category : categories) {
                model.add(category.getName());
            }
            return model;
        }

        public FormValidation doCheckRequired(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckLogin(@QueryParameter(value="m.url") String url, @QueryParameter(value="m.version") String version, @QueryParameter(value="m.userName") String userName, @QueryParameter(value="m.password") String password, @QueryParameter(value="m.basicUserName") String basicUserName, @QueryParameter(value="m.basicPassword") String basicPassword) throws IOException, ServletException {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            if (url == null) {
                return FormValidation.error((String)Messages.MantisProjectProperty_MantisUrlMandatory());
            }
            try {
                URL urL = new URL(url);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)Messages.MantisProjectProperty_MalformedURL());
            }
            MantisSite.MantisVersion v = MantisSite.MantisVersion.getVersionSafely(version, MantisSite.MantisVersion.V120);
            MantisSite site = new MantisSite(new URL(url), v.name(), userName, password, basicUserName, basicPassword);
            if (!site.isConnect()) {
                return FormValidation.error((String)Messages.MantisProjectProperty_UnableToLogin());
            }
            return FormValidation.ok((String)Messages.MantisProjectProperty_Verified());
        }

        public FormValidation doCheckPattern(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException, ServletException {
            project.checkPermission(Job.CONFIGURE);
            String p = Util.fixEmptyAndTrim((String)value);
            if (p != null && p.indexOf(MantisProjectProperty.ISSUE_ID_STRING) == -1) {
                return FormValidation.error((String)Messages.MantisProjectProperty_InvalidPattern(MantisProjectProperty.ISSUE_ID_STRING));
            }
            return FormValidation.ok();
        }

        private static class MantisProjectItem {
            private String name;
            private String id;

            public String getId() {
                return this.id;
            }

            public String getName() {
                return this.name;
            }

            public MantisProjectItem(String name, String id) {
                this.name = name;
                this.id = id;
            }
        }
    }
}

