/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import hudson.ExtensionList;
import hudson.ExtensionListView;
import hudson.ExtensionPoint;
import hudson.model.User;
import hudson.tasks.Mailer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MailAddressResolver
implements ExtensionPoint {
    private static final Pattern EMAIL_ADDRESS_REGEXP = Pattern.compile("^.*<([^>]+)>.*$");
    private static final Pattern WINDOWS_DOMAIN_REGEXP = Pattern.compile("[^\\\\ ]+\\\\([^\\\\ ]+)");
    public static final List<MailAddressResolver> LIST = ExtensionListView.createList(MailAddressResolver.class);
    private static final Logger LOGGER = Logger.getLogger(MailAddressResolver.class.getName());

    public abstract String findMailAddressFor(User var1);

    public static String resolve(User u) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Resolving e-mail address for \"" + u + "\" ID=" + u.getId());
        }
        for (MailAddressResolver r : MailAddressResolver.all()) {
            String email = r.findMailAddressFor(u);
            if (email == null) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(r + " resolved " + u.getId() + " to " + email);
            }
            return email;
        }
        String extractedAddress = MailAddressResolver.extractAddressFromId(u.getFullName());
        if (extractedAddress != null) {
            return extractedAddress;
        }
        if (u.getFullName().contains("@")) {
            return u.getFullName();
        }
        String ds = Mailer.descriptor().getDefaultSuffix();
        if (ds != null) {
            Matcher m = WINDOWS_DOMAIN_REGEXP.matcher(u.getFullName());
            if (m.matches() && u.getFullName().replace('\\', '_').equals(u.getId())) {
                return m.group(1) + ds;
            }
            return u.getId() + ds;
        }
        return null;
    }

    private static String extractAddressFromId(String id) {
        Matcher m = EMAIL_ADDRESS_REGEXP.matcher(id);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public static ExtensionList<MailAddressResolver> all() {
        return Jenkins.getInstance().getExtensionList(MailAddressResolver.class);
    }
}

