/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.model.UserPropertyDescriptor;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.MailAddressResolver;
import hudson.tasks.MailSender;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.plugins.mailer.tasks.i18n.Messages;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class Mailer
extends Notifier
implements SimpleBuildStep {
    protected static final Logger LOGGER = Logger.getLogger(Mailer.class.getName());
    public String recipients;
    public boolean dontNotifyEveryUnstableBuild;
    public boolean sendToIndividuals;
    private static Pattern ADDRESS_PATTERN = Pattern.compile("\\s*([^<]*)<([^>]+)>\\s*");
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="1.355")
    @SuppressFBWarnings(value={"MS_PKGPROTECT"}, justification="Deprecated API field")
    public static DescriptorImpl DESCRIPTOR;
    @Deprecated
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="It may used for debugging purposes. We have to keep it for the sake of the binary copatibility")
    public static boolean debug;

    public boolean isNotifyEveryUnstableBuild() {
        return !this.dontNotifyEveryUnstableBuild;
    }

    @Deprecated
    public Mailer() {
    }

    @DataBoundConstructor
    public Mailer(String recipients, boolean notifyEveryUnstableBuild, boolean sendToIndividuals) {
        this.recipients = recipients;
        this.dontNotifyEveryUnstableBuild = !notifyEveryUnstableBuild;
        this.sendToIndividuals = sendToIndividuals;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        if (debug) {
            listener.getLogger().println("Running mailer");
        }
        EnvVars env = build.getEnvironment(listener);
        String recip = env.expand(this.recipients);
        new MailSender(recip, this.dontNotifyEveryUnstableBuild, this.sendToIndividuals, Mailer.descriptor().getCharset()){

            @Override
            public boolean artifactMatches(String path, AbstractBuild<?, ?> build) {
                ArtifactArchiver aa = (ArtifactArchiver)build.getProject().getPublishersList().get(ArtifactArchiver.class);
                if (aa == null) {
                    LOGGER.finer("No ArtifactArchiver found");
                    return false;
                }
                String artifacts = aa.getArtifacts();
                for (String include : artifacts.split("[, ]+")) {
                    String pattern = include.replace(File.separatorChar, '/');
                    if (pattern.endsWith("/")) {
                        pattern = pattern + "**";
                    }
                    if (!SelectorUtils.matchPath((String)pattern, (String)path)) continue;
                    LOGGER.log(Level.FINER, "DescriptorImpl.artifactMatches true for {0} against {1}", new Object[]{path, pattern});
                    return true;
                }
                LOGGER.log(Level.FINER, "DescriptorImpl.artifactMatches for {0} matched none of {1}", new Object[]{path, artifacts});
                return false;
            }
        }.run(build, listener);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="1.16")
    @SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"}, justification="It's deprecated and required for API compatibility")
    public static InternetAddress StringToAddress(String strAddress, String charset) throws AddressException, UnsupportedEncodingException {
        return Mailer.stringToAddress(strAddress, charset);
    }

    @Nonnull
    public static InternetAddress stringToAddress(@Nonnull String strAddress, @Nonnull String charset) throws AddressException, UnsupportedEncodingException {
        Matcher m = ADDRESS_PATTERN.matcher(strAddress);
        if (!m.matches()) {
            return new InternetAddress(strAddress);
        }
        String personal = m.group(1);
        String address = m.group(2);
        return new InternetAddress(address, personal, charset);
    }

    public static DescriptorImpl descriptor() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins instance is not ready");
        }
        return (DescriptorImpl)jenkins.getDescriptorByType(DescriptorImpl.class);
    }

    static {
        debug = false;
    }

    public static class UserProperty
    extends hudson.model.UserProperty {
        private final String emailAddress;

        public UserProperty(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Exported
        public String getAddress() {
            if (this.hasExplicitlyConfiguredAddress()) {
                return this.emailAddress;
            }
            return MailAddressResolver.resolve(this.user);
        }

        public String getConfiguredAddress() {
            if (this.hasExplicitlyConfiguredAddress()) {
                return this.emailAddress;
            }
            return MailAddressResolver.resolveFast(this.user);
        }

        @CheckForNull
        public String getExplicitlyConfiguredAddress() {
            return Util.fixEmptyAndTrim((String)this.emailAddress);
        }

        public boolean hasExplicitlyConfiguredAddress() {
            return Util.fixEmptyAndTrim((String)this.emailAddress) != null;
        }

        @Extension
        public static final class DescriptorImpl
        extends UserPropertyDescriptor {
            public String getDisplayName() {
                return Messages.Mailer_UserProperty_DisplayName();
            }

            public UserProperty newInstance(User user) {
                return new UserProperty(null);
            }

            public UserProperty newInstance(@CheckForNull StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
                return new UserProperty(req != null ? req.getParameter("email.address") : null);
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String defaultSuffix;
        private String hudsonUrl;
        private String smtpAuthUsername;
        private Secret smtpAuthPassword;
        private String adminAddress;
        private String replyToAddress;
        private String smtpHost;
        private boolean useSsl;
        private String smtpPort;
        private String charset;
        private static transient AtomicInteger testEmailCount = new AtomicInteger(0);

        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Writing to a deprecated field")
        public DescriptorImpl() {
            this.load();
            DESCRIPTOR = this;
        }

        public String getDisplayName() {
            return Messages.Mailer_DisplayName();
        }

        public String getDefaultSuffix() {
            return this.defaultSuffix;
        }

        public String getReplyToAddress() {
            return this.replyToAddress;
        }

        public void setReplyToAddress(String address) {
            this.replyToAddress = Util.fixEmpty((String)address);
        }

        public Session createSession() {
            return DescriptorImpl.createSession(this.smtpHost, this.smtpPort, this.useSsl, this.smtpAuthUsername, this.smtpAuthPassword);
        }

        private static Session createSession(String smtpHost, String smtpPort, boolean useSsl, String smtpAuthUserName, Secret smtpAuthPassword) {
            smtpPort = Util.fixEmptyAndTrim((String)smtpPort);
            smtpAuthUserName = Util.fixEmptyAndTrim((String)smtpAuthUserName);
            Properties props = new Properties(System.getProperties());
            if (Util.fixEmptyAndTrim((String)smtpHost) != null) {
                props.put("mail.smtp.host", smtpHost);
            }
            if (smtpPort != null) {
                props.put("mail.smtp.port", smtpPort);
            }
            if (useSsl) {
                if (props.getProperty("mail.smtp.socketFactory.port") == null) {
                    String port = smtpPort == null ? "465" : smtpPort;
                    props.put("mail.smtp.port", port);
                    props.put("mail.smtp.socketFactory.port", port);
                }
                if (props.getProperty("mail.smtp.socketFactory.class") == null) {
                    props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                }
                props.put("mail.smtp.socketFactory.fallback", "false");
            }
            if (smtpAuthUserName != null) {
                props.put("mail.smtp.auth", "true");
            }
            props.put("mail.smtp.timeout", "60000");
            props.put("mail.smtp.connectiontimeout", "60000");
            return Session.getInstance((Properties)props, (Authenticator)DescriptorImpl.getAuthenticator(smtpAuthUserName, Secret.toString((Secret)smtpAuthPassword)));
        }

        private static Authenticator getAuthenticator(final String smtpAuthUserName, final String smtpAuthPassword) {
            if (smtpAuthUserName == null) {
                return null;
            }
            return new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(smtpAuthUserName, smtpAuthPassword);
                }
            };
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.smtpHost = this.nullify(json.getString("smtpServer"));
            this.setReplyToAddress(json.getString("replyToAddress"));
            this.defaultSuffix = this.nullify(json.getString("defaultSuffix"));
            if (json.has("useSMTPAuth")) {
                JSONObject auth = json.getJSONObject("useSMTPAuth");
                this.smtpAuthUsername = this.nullify(auth.getString("smtpAuthUserName"));
                this.smtpAuthPassword = Secret.fromString((String)this.nullify(auth.getString("smtpAuthPasswordSecret")));
            } else {
                this.smtpAuthUsername = null;
                this.smtpAuthPassword = null;
            }
            this.smtpPort = this.nullify(json.getString("smtpPort"));
            this.useSsl = json.getBoolean("useSsl");
            this.charset = json.getString("charset");
            if (this.charset == null || this.charset.length() == 0) {
                this.charset = "UTF-8";
            }
            this.save();
            return true;
        }

        private String nullify(String v) {
            if (v != null && v.length() == 0) {
                v = null;
            }
            return v;
        }

        public String getSmtpServer() {
            return this.smtpHost;
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="False positive. See https://sourceforge.net/p/findbugs/bugs/1411/")
        private JenkinsLocationConfiguration getJenkinsLocationConfiguration() {
            JenkinsLocationConfiguration jlc = JenkinsLocationConfiguration.get();
            if (jlc == null) {
                throw new IllegalStateException("JenkinsLocationConfiguration not available");
            }
            return jlc;
        }

        public String getAdminAddress() {
            return this.getJenkinsLocationConfiguration().getAdminAddress();
        }

        public String getUrl() {
            return this.getJenkinsLocationConfiguration().getUrl();
        }

        public String getSmtpAuthUserName() {
            return this.smtpAuthUsername;
        }

        public String getSmtpAuthPassword() {
            if (this.smtpAuthPassword == null) {
                return null;
            }
            return Secret.toString((Secret)this.smtpAuthPassword);
        }

        public Secret getSmtpAuthPasswordSecret() {
            return this.smtpAuthPassword;
        }

        public boolean getUseSsl() {
            return this.useSsl;
        }

        public String getSmtpPort() {
            return this.smtpPort;
        }

        public String getCharset() {
            String c = this.charset;
            if (c == null || c.length() == 0) {
                c = "UTF-8";
            }
            return c;
        }

        public void setDefaultSuffix(String defaultSuffix) {
            this.defaultSuffix = defaultSuffix;
        }

        public void setHudsonUrl(String hudsonUrl) {
            this.getJenkinsLocationConfiguration().setUrl(hudsonUrl);
        }

        public void setAdminAddress(String adminAddress) {
            this.getJenkinsLocationConfiguration().setAdminAddress(adminAddress);
        }

        public void setSmtpHost(String smtpHost) {
            this.smtpHost = smtpHost;
        }

        public void setUseSsl(boolean useSsl) {
            this.useSsl = useSsl;
        }

        public void setSmtpPort(String smtpPort) {
            this.smtpPort = smtpPort;
        }

        public void setCharset(String chaset) {
            this.charset = chaset;
        }

        public void setSmtpAuth(String userName, String password) {
            this.smtpAuthUsername = userName;
            this.smtpAuthPassword = Secret.fromString((String)password);
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            Mailer m = (Mailer)super.newInstance(req, formData);
            if (this.hudsonUrl == null) {
                this.hudsonUrl = Functions.inferHudsonURL((StaplerRequest)req);
                this.save();
            }
            return m;
        }

        public FormValidation doAddressCheck(@QueryParameter String value) {
            try {
                new InternetAddress(value);
                return FormValidation.ok();
            }
            catch (AddressException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckSmtpServer(@QueryParameter String value) {
            try {
                if (Util.fixEmptyAndTrim((String)value) != null) {
                    InetAddress.getByName(value);
                }
                return FormValidation.ok();
            }
            catch (UnknownHostException e) {
                return FormValidation.error((String)(Messages.Mailer_Unknown_Host_Name() + value));
            }
        }

        public FormValidation doCheckDefaultSuffix(@QueryParameter String value) {
            if (value.matches("@[A-Za-z0-9.\\-]+") || Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.Mailer_Suffix_Error());
        }

        @RequirePOST
        public FormValidation doSendTestMail(@QueryParameter String smtpServer, @QueryParameter String adminAddress, @QueryParameter boolean useSMTPAuth, @QueryParameter String smtpAuthUserName, @QueryParameter Secret smtpAuthPasswordSecret, @QueryParameter boolean useSsl, @QueryParameter String smtpPort, @QueryParameter String charset, @QueryParameter String sendTestMailTo) throws IOException, ServletException, InterruptedException {
            try {
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins == null) {
                    throw new IOException("Jenkins instance is not ready");
                }
                jenkins.checkPermission(Jenkins.ADMINISTER);
                if (!useSMTPAuth) {
                    smtpAuthUserName = null;
                    smtpAuthPasswordSecret = null;
                }
                MimeMessage msg = new MimeMessage(DescriptorImpl.createSession(smtpServer, smtpPort, useSsl, smtpAuthUserName, smtpAuthPasswordSecret));
                msg.setSubject(Messages.Mailer_TestMail_Subject(testEmailCount.incrementAndGet()), charset);
                msg.setText(Messages.Mailer_TestMail_Content(testEmailCount.get(), jenkins.getDisplayName()), charset);
                msg.setFrom((Address)Mailer.stringToAddress(adminAddress, charset));
                if (StringUtils.isNotBlank((String)this.replyToAddress)) {
                    msg.setReplyTo(new Address[]{Mailer.stringToAddress(this.replyToAddress, charset)});
                }
                msg.setSentDate(new Date());
                msg.setRecipient(Message.RecipientType.TO, (Address)Mailer.stringToAddress(sendTestMailTo, charset));
                Transport.send((Message)msg);
                return FormValidation.ok((String)Messages.Mailer_EmailSentSuccessfully());
            }
            catch (MessagingException e) {
                return FormValidation.errorWithMarkup((String)("<p>" + Messages.Mailer_FailedToSendEmail() + "</p><pre>" + Util.escape((String)Functions.printThrowable((Throwable)e)) + "</pre>"));
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

