/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.tasks.MailMessageIdAction;
import hudson.tasks.Mailer;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import jenkins.model.Jenkins;
import jenkins.plugins.mailer.tasks.MailAddressFilter;
import jenkins.plugins.mailer.tasks.MimeMessageBuilder;
import jenkins.plugins.mailer.tasks.i18n.Messages;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;

public class MailSender {
    private String recipients;
    private List<AbstractProject> includeUpstreamCommitters = new ArrayList<AbstractProject>();
    private boolean dontNotifyEveryUnstableBuild;
    private boolean sendToIndividuals;
    private String charset;
    @Deprecated
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="It may used for debugging purposes. We have to keep it for the sake of the binary copatibility")
    public static boolean debug = false;
    private static final int MAX_LOG_LINES = Integer.getInteger(MailSender.class.getName() + ".maxLogLines", 250);

    public MailSender(String recipients, boolean dontNotifyEveryUnstableBuild, boolean sendToIndividuals) {
        this(recipients, dontNotifyEveryUnstableBuild, sendToIndividuals, "UTF-8");
    }

    public MailSender(String recipients, boolean dontNotifyEveryUnstableBuild, boolean sendToIndividuals, String charset) {
        this(recipients, dontNotifyEveryUnstableBuild, sendToIndividuals, charset, Collections.emptyList());
    }

    public MailSender(String recipients, boolean dontNotifyEveryUnstableBuild, boolean sendToIndividuals, String charset, Collection<AbstractProject> includeUpstreamCommitters) {
        this.recipients = Util.fixNull((String)recipients);
        this.dontNotifyEveryUnstableBuild = dontNotifyEveryUnstableBuild;
        this.sendToIndividuals = sendToIndividuals;
        this.charset = charset;
        this.includeUpstreamCommitters.addAll(includeUpstreamCommitters);
    }

    @Deprecated
    public boolean execute(AbstractBuild<?, ?> build, BuildListener listener) throws InterruptedException {
        this.run((Run<?, ?>)build, (TaskListener)listener);
        return true;
    }

    public final void run(Run<?, ?> build, TaskListener listener) throws InterruptedException {
        try {
            MimeMessage mail = this.createMail(build, listener);
            if (mail != null) {
                Address[] allRecipients;
                Run pb = build.getPreviousBuild();
                if (pb != null && pb.getResult() == Result.SUCCESS) {
                    mail.removeHeader("In-Reply-To");
                    mail.removeHeader("References");
                }
                if ((allRecipients = mail.getAllRecipients()) != null) {
                    StringBuilder buf = new StringBuilder("Sending e-mails to:");
                    for (Address a : allRecipients) {
                        if (a == null) continue;
                        buf.append(' ').append(a);
                    }
                    listener.getLogger().println(buf);
                    Transport.send((Message)mail);
                    build.addAction((Action)new MailMessageIdAction(mail.getMessageID()));
                } else {
                    listener.getLogger().println(Messages.MailSender_ListEmpty());
                }
            }
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
    }

    private Result findPreviousBuildResult(Run<?, ?> b) throws InterruptedException {
        do {
            if ((b = b.getPreviousBuild()) != null && !b.isBuilding()) continue;
            return null;
        } while (b.getResult() == Result.ABORTED || b.getResult() == Result.NOT_BUILT);
        return b.getResult();
    }

    @Deprecated
    protected MimeMessage getMail(AbstractBuild<?, ?> build, BuildListener listener) throws MessagingException, UnsupportedEncodingException, InterruptedException {
        return this.createMail((Run<?, ?>)build, (TaskListener)listener);
    }

    @CheckForNull
    protected MimeMessage createMail(Run<?, ?> build, TaskListener listener) throws MessagingException, UnsupportedEncodingException, InterruptedException {
        Result prev;
        try {
            Method m = this.getClass().getDeclaredMethod("getMail", AbstractBuild.class, BuildListener.class);
            if (m.getDeclaringClass() != MailSender.class) {
                if (build instanceof AbstractBuild && listener instanceof BuildListener) {
                    return this.getMail((AbstractBuild)build, (BuildListener)listener);
                }
                throw new AbstractMethodError("you must override createMail rather than getMail");
            }
        }
        catch (NoSuchMethodException m) {
            // empty catch block
        }
        if (build.getResult() == Result.FAILURE) {
            return this.createFailureMail(build, listener);
        }
        if (build.getResult() == Result.UNSTABLE) {
            if (!this.dontNotifyEveryUnstableBuild) {
                return this.createUnstableMail(build, listener);
            }
            prev = this.findPreviousBuildResult(build);
            if (prev == Result.SUCCESS || prev == null) {
                return this.createUnstableMail(build, listener);
            }
        }
        if (build.getResult() == Result.SUCCESS) {
            prev = this.findPreviousBuildResult(build);
            if (prev == Result.FAILURE) {
                return this.createBackToNormalMail(build, Messages.MailSender_BackToNormal_Normal(), listener);
            }
            if (prev == Result.UNSTABLE) {
                return this.createBackToNormalMail(build, Messages.MailSender_BackToNormal_Stable(), listener);
            }
        }
        return null;
    }

    private MimeMessage createBackToNormalMail(Run<?, ?> build, String subject, TaskListener listener) throws MessagingException, UnsupportedEncodingException {
        MimeMessage msg = this.createEmptyMail(build, listener);
        msg.setSubject(this.getSubject(build, Messages.MailSender_BackToNormalMail_Subject(subject)), this.charset);
        msg.setText(DisplayURLProvider.get().getRunURL(build), this.charset);
        return msg;
    }

    private static ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet(Run<?, ?> build) {
        if (build instanceof AbstractBuild) {
            return ((AbstractBuild)build).getChangeSet();
        }
        return ChangeLogSet.createEmpty(build);
    }

    private MimeMessage createUnstableMail(Run<?, ?> build, TaskListener listener) throws MessagingException, UnsupportedEncodingException {
        MimeMessage msg = this.createEmptyMail(build, listener);
        String subject = Messages.MailSender_UnstableMail_Subject();
        Run prev = build.getPreviousBuild();
        boolean still = false;
        if (prev != null) {
            if (prev.getResult() == Result.SUCCESS) {
                subject = Messages.MailSender_UnstableMail_ToUnStable_Subject();
            } else if (prev.getResult() == Result.UNSTABLE) {
                subject = Messages.MailSender_UnstableMail_StillUnstable_Subject();
                still = true;
            }
        }
        msg.setSubject(this.getSubject(build, subject), this.charset);
        DisplayURLProvider displayURLProvider = DisplayURLProvider.get();
        String url = still && (!MailSender.getChangeSet(build).isEmptySet() || !MailSender.getChangeSet(prev).isEmptySet()) ? displayURLProvider.getChangesURL(build) : displayURLProvider.getRunURL(build);
        msg.setText(url, this.charset);
        return msg;
    }

    private MimeMessage createFailureMail(Run<?, ?> build, TaskListener listener) throws MessagingException, UnsupportedEncodingException, InterruptedException {
        MimeMessage msg = this.createEmptyMail(build, listener);
        msg.setSubject(this.getSubject(build, Messages.MailSender_FailureMail_Subject()), this.charset);
        StringBuilder buf = new StringBuilder();
        buf.append(DisplayURLProvider.get().getRunURL(build));
        boolean firstChange = true;
        for (ChangeLogSet.Entry entry : MailSender.getChangeSet(build)) {
            if (firstChange) {
                firstChange = false;
                buf.append(Messages.MailSender_FailureMail_Changes()).append("\n\n");
            }
            buf.append('[');
            buf.append(entry.getAuthor().getFullName());
            buf.append("] ");
            String m = entry.getMsg();
            if (m != null) {
                buf.append(m);
                if (!m.endsWith("\n")) {
                    buf.append('\n');
                }
            }
            buf.append('\n');
        }
        buf.append("------------------------------------------\n");
        try {
            List lines = build.getLog(MAX_LOG_LINES);
            String workspaceUrl = null;
            String artifactUrl = null;
            Pattern wsPattern = null;
            String baseUrl = Mailer.descriptor().getUrl();
            if (baseUrl != null) {
                workspaceUrl = baseUrl + Util.encode((String)build.getParent().getUrl()) + "ws/";
                artifactUrl = baseUrl + Util.encode((String)build.getUrl()) + "artifact/";
                FilePath ws = build instanceof AbstractBuild ? ((AbstractBuild)build).getWorkspace() : null;
                wsPattern = ws == null ? null : Pattern.compile("(" + Pattern.quote(ws.getRemote()) + "|" + Pattern.quote(ws.toURI().toString()) + ")[/\\\\]?([^:#\\s]*)");
            }
            for (String line : lines) {
                line = line.replace('\u0000', ' ');
                if (wsPattern != null) {
                    Matcher m = wsPattern.matcher(line);
                    int pos = 0;
                    while (m.find(pos)) {
                        String path = m.group(2).replace(File.separatorChar, '/');
                        String linkUrl = this.artifactMatches(path, (AbstractBuild)build) ? artifactUrl : workspaceUrl;
                        String prefix = line.substring(0, m.start()) + '<' + linkUrl + Util.encode((String)path) + '>';
                        pos = prefix.length();
                        line = prefix + line.substring(m.end());
                        m = wsPattern.matcher(line);
                    }
                }
                buf.append(line);
                buf.append('\n');
            }
        }
        catch (IOException e) {
            buf.append(Messages.MailSender_FailureMail_FailedToAccessBuildLog()).append("\n\n").append(Functions.printThrowable((Throwable)e));
        }
        msg.setText(buf.toString(), this.charset);
        return msg;
    }

    private MimeMessage createEmptyMail(final Run<?, ?> run, final TaskListener listener) throws MessagingException, UnsupportedEncodingException {
        MailMessageIdAction b;
        MimeMessageBuilder messageBuilder = new MimeMessageBuilder().setCharset(this.charset).setListener(listener);
        AbstractBuild build = run instanceof AbstractBuild ? (AbstractBuild)run : null;
        StringTokenizer tokens = new StringTokenizer(this.recipients);
        while (tokens.hasMoreTokens()) {
            String address = tokens.nextToken();
            if (build != null && address.startsWith("upstream-individuals:")) {
                String projectName = address.substring("upstream-individuals:".length());
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins == null) {
                    listener.getLogger().println("Jenkins is not ready. Cannot retrieve project " + projectName);
                    continue;
                }
                AbstractProject up = (AbstractProject)jenkins.getItem(projectName, (Item)run.getParent(), AbstractProject.class);
                if (up == null) {
                    listener.getLogger().println("No such project exist: " + projectName);
                    continue;
                }
                messageBuilder.addRecipients(this.getCulpritsOfEmailList(up, build, listener));
                continue;
            }
            messageBuilder.addRecipients(address);
        }
        if (build != null) {
            for (AbstractProject project : this.includeUpstreamCommitters) {
                messageBuilder.addRecipients(this.getCulpritsOfEmailList(project, build, listener));
            }
            if (this.sendToIndividuals) {
                Set culprits = build.getCulprits();
                if (debug) {
                    listener.getLogger().println("Trying to send e-mails to individuals who broke the run. sizeof(culprits)==" + culprits.size());
                }
                messageBuilder.addRecipients(this.getUserEmailList(listener, culprits));
            }
        }
        messageBuilder.setRecipientFilter(new MimeMessageBuilder.AddressFilter(){

            @Override
            public Set<InternetAddress> apply(Set<InternetAddress> recipients) {
                return MailAddressFilter.filterRecipients(run, listener, recipients);
            }
        });
        MimeMessage msg = messageBuilder.buildMimeMessage();
        msg.addHeader("X-Jenkins-Job", run.getParent().getFullName());
        Result result = run.getResult();
        msg.addHeader("X-Jenkins-Result", result != null ? result.toString() : "in progress");
        Run pb = run.getPreviousBuild();
        if (pb != null && (b = (MailMessageIdAction)pb.getAction(MailMessageIdAction.class)) != null) {
            MimeMessageBuilder.setInReplyTo(msg, b.messageId);
        }
        return msg;
    }

    String getCulpritsOfEmailList(AbstractProject upstreamProject, AbstractBuild<?, ?> currentBuild, TaskListener listener) throws AddressException, UnsupportedEncodingException {
        AbstractBuild previousBuildUpstreamBuild;
        AbstractBuild upstreamBuild = currentBuild.getUpstreamRelationshipBuild(upstreamProject);
        AbstractBuild previousBuild = currentBuild.getPreviousBuild();
        AbstractBuild abstractBuild = previousBuildUpstreamBuild = previousBuild != null ? previousBuild.getUpstreamRelationshipBuild(upstreamProject) : null;
        if (previousBuild == null && upstreamBuild == null && previousBuildUpstreamBuild == null) {
            listener.getLogger().println("Unable to compute the changesets in " + upstreamProject + ". Is the fingerprint configured?");
            return null;
        }
        if (previousBuild == null || upstreamBuild == null || previousBuildUpstreamBuild == null) {
            listener.getLogger().println("Unable to compute the changesets in " + upstreamProject);
            return null;
        }
        AbstractBuild b = previousBuildUpstreamBuild;
        StringBuilder culpritEmails = new StringBuilder();
        do {
            if ((b = b.getNextBuild()) == null) continue;
            String userEmails = this.getUserEmailList(listener, b.getCulprits());
            if (culpritEmails.length() > 0) {
                culpritEmails.append(",");
            }
            culpritEmails.append(userEmails);
        } while (b != upstreamBuild && b != null);
        return culpritEmails.toString();
    }

    @Nonnull
    private String getUserEmailList(TaskListener listener, Set<User> users) throws AddressException, UnsupportedEncodingException {
        StringBuilder userEmails = new StringBuilder();
        for (User a : users) {
            String adrs = Util.fixEmpty((String)((Mailer.UserProperty)a.getProperty(Mailer.UserProperty.class)).getAddress());
            if (debug) {
                listener.getLogger().println("  User " + a.getId() + " -> " + adrs);
            }
            if (adrs != null) {
                if (userEmails.length() > 0) {
                    userEmails.append(",");
                }
                userEmails.append(adrs);
                continue;
            }
            listener.getLogger().println(Messages.MailSender_NoAddress(a.getFullName()));
        }
        return userEmails.toString();
    }

    private String getSubject(Run<?, ?> build, String caption) {
        return caption + ' ' + build.getFullDisplayName();
    }

    protected boolean artifactMatches(String path, AbstractBuild<?, ?> build) {
        return false;
    }
}

