/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.mailer.tasks;

import hudson.DescriptorExtensionList;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.internet.InternetAddress;
import jenkins.model.Jenkins;
import jenkins.plugins.mailer.tasks.MailAddressFilterDescriptor;

public abstract class MailAddressFilter
implements Describable<MailAddressFilter>,
ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(MailAddressFilter.class.getName());

    public boolean shouldFilter(Run<?, ?> build, TaskListener listener, InternetAddress address) {
        if (Util.isOverridden(MailAddressFilter.class, this.getClass(), (String)"isFiltered", (Class[])new Class[]{AbstractBuild.class, BuildListener.class, InternetAddress.class}) && build instanceof AbstractBuild && listener instanceof BuildListener) {
            return this.isFiltered((AbstractBuild)build, (BuildListener)listener, address);
        }
        throw new AbstractMethodError("you must implement shouldFilter");
    }

    @Deprecated
    public boolean isFiltered(AbstractBuild<?, ?> build, BuildListener listener, InternetAddress address) {
        if (Util.isOverridden(MailAddressFilter.class, this.getClass(), (String)"shouldFilter", (Class[])new Class[]{Run.class, TaskListener.class, InternetAddress.class})) {
            return this.shouldFilter((Run<?, ?>)build, (TaskListener)listener, address);
        }
        throw new AbstractMethodError("you must implement shouldFilter");
    }

    public static Set<InternetAddress> filterRecipients(Run<?, ?> build, TaskListener listener, Set<InternetAddress> recipients) {
        LinkedHashSet<InternetAddress> rcp = new LinkedHashSet<InternetAddress>();
        for (InternetAddress address : recipients) {
            if (MailAddressFilter.isFilteredRecipient(address, listener, build)) continue;
            rcp.add(address);
        }
        return rcp;
    }

    @Deprecated
    public static Set<InternetAddress> getFilteredRecipients(AbstractBuild<?, ?> build, BuildListener listener, Set<InternetAddress> recipients) {
        return MailAddressFilter.filterRecipients(build, (TaskListener)listener, recipients);
    }

    private static boolean isFilteredRecipient(InternetAddress address, TaskListener listener, Run<?, ?> build) {
        LOGGER.log(Level.FINE, "Checking for filtered email address for \"{0}\"", address);
        for (MailAddressFilter filter : MailAddressFilter.allExtensions()) {
            LOGGER.log(Level.FINE, "Checking for filtered email address for \"{0}\" with \"{1}\"", new Object[]{address, filter.getClass().getName()});
            if (!filter.shouldFilter(build, listener, address)) continue;
            LOGGER.log(Level.FINE, "Filtered out email recipient \"{0}\"", address);
            return true;
        }
        return false;
    }

    public MailAddressFilterDescriptor getDescriptor() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            return (MailAddressFilterDescriptor)jenkins.getDescriptor(this.getClass());
        }
        throw new IllegalStateException("Jenkins is not active.");
    }

    public static DescriptorExtensionList<MailAddressFilter, MailAddressFilterDescriptor> all() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            return jenkins.getDescriptorList(MailAddressFilter.class);
        }
        throw new IllegalStateException("Jenkins is not active.");
    }

    public static ExtensionList<MailAddressFilter> allExtensions() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            return jenkins.getExtensionList(MailAddressFilter.class);
        }
        throw new IllegalStateException("Jenkins is not active.");
    }
}

