/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.sikakura;

import antlr.ANTLRException;
import com.gmail.sikakura.MailCommandBuilder;
import com.gmail.sikakura.Messages;
import hudson.Extension;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.console.AnnotatedLargeText;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.SCMedItem;
import hudson.scheduler.CronTabList;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.commons.jelly.XMLOutput;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailCommandTrigger
extends Trigger<SCMedItem> {
    private static final Logger LOGGER = Logger.getLogger(MailCommandTrigger.class.getName());

    @DataBoundConstructor
    public MailCommandTrigger(String spec) throws ANTLRException {
        super(spec);
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new MailCommandAction());
    }

    public File getLogFile() {
        return new File(((SCMedItem)this.job).getRootDir(), "mailcommander-polling.log");
    }

    public void run() {
        Store store;
        String address = null;
        String port = null;
        String username = null;
        String password = null;
        boolean isCommandExist = false;
        try {
            FileInputStream fis = new FileInputStream(new File(((SCMedItem)this.job).getRootDir(), "config.xml"));
            Document dom = new SAXReader().read((InputStream)fis);
            Element mailcommander = dom.getRootElement().element("builders").element(MailCommandBuilder.class.getName());
            address = mailcommander.elementText("address");
            port = mailcommander.elementText("port");
            username = mailcommander.elementText("username");
            password = mailcommander.elementText("password");
            fis.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        Properties props = new Properties();
        Session sess = Session.getDefaultInstance((Properties)props);
        try {
            store = sess.getStore("pop3");
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            return;
        }
        StringBuffer commands = new StringBuffer();
        for (CLICommand c : CLICommand.all()) {
            commands.append(c.getName());
        }
        try {
            store.connect(address, Integer.valueOf(port).intValue(), username, password);
            Folder rootFolder = store.getDefaultFolder();
            Folder inbox = rootFolder.getFolder("INBOX");
            inbox.open(1);
            Message[] messages = null;
            messages = inbox.getMessageCount() > 10 ? inbox.getMessages(inbox.getMessageCount() - 10 + 1, inbox.getMessageCount()) : inbox.getMessages();
            FetchProfile fp = new FetchProfile();
            fp.add("Subject");
            inbox.fetch(messages, fp);
            for (Message message : messages) {
                String findStr = message.getSubject().split(" ")[0];
                if (commands.indexOf(findStr) == -1) continue;
                isCommandExist = true;
                break;
            }
            inbox.close(true);
            store.close();
        }
        catch (MessagingException e) {
            e.printStackTrace();
            return;
        }
        if (isCommandExist) {
            ((SCMedItem)this.job).scheduleBuild(0, (Cause)new MailCommandTriggerCause());
        }
        try {
            StreamTaskListener listener = new StreamTaskListener(this.getLogFile());
            try {
                PrintStream logger = listener.getLogger();
                logger.println("Started on " + DateFormat.getDateTimeInstance().format(new Date()));
                if (isCommandExist) {
                    logger.println("Changes found");
                } else {
                    logger.println("No changes");
                }
            }
            catch (Error e) {
                e.printStackTrace(listener.error("Failed to record Mail Commander polling"));
                LOGGER.log(Level.SEVERE, "Failed to record SCM polling", e);
                throw e;
            }
            catch (RuntimeException e) {
                e.printStackTrace(listener.error("Failed to record Mail Commander polling"));
                LOGGER.log(Level.SEVERE, "Failed to record Mail Commander polling", e);
                throw e;
            }
            finally {
                listener.close();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to record Mail Commander polling", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class MailCommandAction
    implements Action {
        public AbstractProject<?, ?> getOwner() {
            return ((SCMedItem)MailCommandTrigger.this.job).asProject();
        }

        public String getIconFileName() {
            return "clipboard.gif";
        }

        public String getDisplayName() {
            return "Mail Command Action";
        }

        public String getUrlName() {
            return "mailcommandPollLog";
        }

        public String getLog() throws IOException {
            return Util.loadFile((File)MailCommandTrigger.this.getLogFile());
        }

        public void writeLogTo(XMLOutput out) throws IOException {
            new AnnotatedLargeText(MailCommandTrigger.this.getLogFile(), Charset.defaultCharset(), true, (Object)this).writeHtmlTo(0L, out.asWriter());
        }
    }

    public static class MailCommandTriggerCause
    extends Cause {
        public String getShortDescription() {
            return "Mail Commander Trigger";
        }

        public boolean equals(Object o) {
            return o instanceof MailCommandTriggerCause;
        }

        public int hashCode() {
            return 5;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return item instanceof BuildableItem;
        }

        public String getDisplayName() {
            return Messages.MailCommandTrigger_DisplayName();
        }

        public FormValidation doCheck(@QueryParameter String value) {
            return this.doCheckSpec(value);
        }

        public FormValidation doCheckSpec(@QueryParameter String value) {
            try {
                String msg = CronTabList.create((String)Util.fixNull((String)value)).checkSanity();
                if (msg != null) {
                    return FormValidation.warning((String)msg);
                }
                return FormValidation.ok();
            }
            catch (ANTLRException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

