/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.sikakura;

import com.gmail.sikakura.Messages;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Mailer;
import hudson.tasks.Publisher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailCommandPublisher
extends Publisher {
    private static final Logger LOGGER = Logger.getLogger(MailCommandPublisher.class.getName());
    public static DescriptorImpl DESCRIPTOR;

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        File logfile = build.getLogFile();
        StringBuffer logbuf = new StringBuffer();
        try {
            String line;
            FileReader in = new FileReader(logfile);
            BufferedReader br = new BufferedReader(in);
            while ((line = br.readLine()) != null) {
                logbuf.append(line);
                logbuf.append("\n");
            }
            br.close();
            in.close();
        }
        catch (IOException e) {
            listener.getLogger().println(e);
        }
        File addressFile = new File(build.getRootDir(), "tmp.address");
        String to_address = null;
        if (addressFile.exists()) {
            try {
                String line;
                FileReader in = new FileReader(addressFile);
                BufferedReader br = new BufferedReader(in);
                while ((line = br.readLine()) != null) {
                    to_address = line;
                }
                br.close();
                in.close();
            }
            catch (IOException e) {
                listener.getLogger().println(e);
            }
            if (to_address != null) {
                try {
                    MimeMessage msg = new MimeMessage(Mailer.descriptor().createSession());
                    msg.setRecipients(Message.RecipientType.TO, to_address);
                    msg.setFrom((Address)new InternetAddress(Mailer.descriptor().getAdminAddress()));
                    msg.setSubject("This is a result of mail command");
                    msg.setSentDate(new Date());
                    msg.setText(logbuf.toString());
                    Transport.send((Message)msg);
                }
                catch (MessagingException mex) {
                    listener.getLogger().println((Object)mex);
                    mex.printStackTrace();
                }
            }
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public static DescriptorImpl descriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
            DESCRIPTOR = this;
        }

        public String getDisplayName() {
            return Messages.MailCommandPublisher_DisplayName();
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) {
            MailCommandPublisher m = new MailCommandPublisher();
            return m;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

