/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.sikakura;

import hudson.Extension;
import hudson.Launcher;
import hudson.cli.CLI;
import hudson.cli.CLICommand;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import org.kohsuke.stapler.DataBoundConstructor;

public class MailCommandBuilder
extends Builder {
    private static final Logger LOGGER = Logger.getLogger(MailCommandBuilder.class.getName());
    private final String address;
    private final String port;
    private final String username;
    private final String password;
    String to_address;

    @DataBoundConstructor
    public MailCommandBuilder(String address, String port, String username, String password) {
        this.address = address;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTo_address() {
        return this.to_address;
    }

    public String receive(AbstractBuild build, BuildListener listener) {
        Store store;
        StringBuffer commands = new StringBuffer();
        for (CLICommand c : CLICommand.all()) {
            commands.append(c.getName());
        }
        Properties props = new Properties();
        Session sess = Session.getDefaultInstance((Properties)props);
        String subject = null;
        try {
            store = sess.getStore("pop3");
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            return null;
        }
        try {
            store.connect(this.address, Integer.valueOf(this.port).intValue(), this.username, this.password);
            Folder rootFolder = store.getDefaultFolder();
            Folder inbox = rootFolder.getFolder("INBOX");
            inbox.open(2);
            Message[] messages = null;
            messages = inbox.getMessageCount() > 10 ? inbox.getMessages(inbox.getMessageCount() - 10 + 1, inbox.getMessageCount()) : inbox.getMessages();
            FetchProfile fp = new FetchProfile();
            fp.add("Subject");
            inbox.fetch(messages, fp);
            for (Message message : messages) {
                String findStr = message.getSubject().split(" ")[0];
                if (commands.indexOf(findStr) == -1) continue;
                subject = message.getSubject();
                InternetAddress[] addresses = (InternetAddress[])message.getFrom();
                this.saveFile(build, "tmp.address", addresses[0].getAddress());
                if ("groovy".indexOf(findStr) != -1) {
                    this.saveFile(build, "groovy.script", (String)message.getContent());
                }
                message.setFlag(Flags.Flag.DELETED, true);
                break;
            }
            inbox.close(true);
            store.close();
        }
        catch (MessagingException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(AbstractBuild build, String filename, String contents) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(build.getRootDir(), filename));
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            BufferedWriter bw = new BufferedWriter(osw);
            bw.write(contents);
            bw.close();
            osw.close();
            fos.close();
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        String head;
        String command = this.receive(build, listener);
        if (Hudson.getInstance().getRootUrl() == null) {
            listener.getLogger().println("Please save a once System property!");
            return false;
        }
        if (command == null) {
            listener.getLogger().println("Don't find command mail.");
            return true;
        }
        StringBuilder sb = new StringBuilder("-s");
        sb.append(" ");
        sb.append(Hudson.getInstance().getRootUrl());
        sb.append(" ");
        sb.append(command);
        List<String> args = Arrays.asList(sb.toString().split(" "));
        String url = System.getenv("JENKINS_URL");
        while (!args.isEmpty() && (head = args.get(0)).equals("-s") && args.size() >= 2) {
            url = args.get(1);
            args = args.subList(2, args.size());
        }
        if (url == null) {
            return false;
        }
        if (args.isEmpty()) {
            args = Arrays.asList("help");
        }
        CLI cli = null;
        int resultInt = -1;
        try {
            cli = new CLI(new URL(url));
            args = new ArrayList<String>(args);
            if (command.compareTo("groovy") == 0) {
                File path = new File(build.getRootDir(), "groovy.script");
                args.add(path.getAbsolutePath());
            }
            resultInt = cli.execute(args, System.in, (OutputStream)listener.getLogger(), (OutputStream)listener.getLogger());
            cli.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return resultInt == 0;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Mail Commander";
        }
    }
}

