/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Environment;
import hudson.model.EnvironmentList;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.logstash.LogstashConfiguration;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class BuildData {
    private static final Logger LOGGER = Logger.getLogger(MethodHandles.lookup().lookupClass().getCanonicalName());
    private String id;
    private String result;
    private String projectName;
    private String fullProjectName;
    private String displayName;
    private String fullDisplayName;
    private String description;
    private String url;
    private String buildHost;
    private String buildLabel;
    private int buildNum;
    private long buildDuration;
    private transient String timestamp;
    private transient Run<?, ?> build;
    private String rootProjectName;
    private String rootFullProjectName;
    private String rootProjectDisplayName;
    private int rootBuildNum;
    private Map<String, String> buildVariables;
    private Set<String> sensitiveBuildVariables;
    private TestData testResults = null;

    public BuildData(AbstractBuild<?, ?> build, Date currentTime, TaskListener listener) {
        this.initData((Run<?, ?>)build, currentTime);
        this.rootProjectName = build.getRootBuild().getProject().getName();
        this.rootFullProjectName = build.getRootBuild().getProject().getFullName();
        this.rootProjectDisplayName = build.getRootBuild().getDisplayName();
        this.rootBuildNum = build.getRootBuild().getNumber();
        this.buildVariables = build.getBuildVariables();
        this.sensitiveBuildVariables = build.getSensitiveBuildVariables();
        HashMap buildEnvVariables = new HashMap();
        EnvironmentList buildEnvironments = build.getEnvironments();
        if (buildEnvironments != null) {
            for (Environment env : buildEnvironments) {
                if (env == null) continue;
                env.buildEnvVars(buildEnvVariables);
                if (buildEnvVariables.isEmpty()) continue;
                this.buildVariables.putAll(buildEnvVariables);
                buildEnvVariables.clear();
            }
        }
        try {
            this.buildVariables.putAll((Map<String, String>)build.getEnvironment(listener));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable update logstash buildVariables with EnvVars from " + build.getDisplayName(), e);
        }
        for (String key : this.sensitiveBuildVariables) {
            this.buildVariables.remove(key);
        }
    }

    public BuildData(Run<?, ?> build, Date currentTime, TaskListener listener) {
        this.initData(build, currentTime);
        this.rootProjectName = this.projectName;
        this.rootFullProjectName = this.fullProjectName;
        this.rootProjectDisplayName = this.displayName;
        this.rootBuildNum = this.buildNum;
        try {
            this.buildVariables = build.getEnvironment(listener);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.WARNING, "Unable to get environment for " + build.getDisplayName(), e);
            this.buildVariables = new HashMap<String, String>();
        }
    }

    private void initData(Run<?, ?> build, Date currentTime) {
        this.build = build;
        Executor executor = build.getExecutor();
        if (executor == null) {
            this.buildHost = "master";
            this.buildLabel = "master";
        } else {
            Node node = executor.getOwner().getNode();
            if (node == null) {
                this.buildHost = "master";
                this.buildLabel = "master";
            } else {
                this.buildHost = StringUtils.isBlank((String)node.getDisplayName()) ? "master" : node.getDisplayName();
                this.buildLabel = StringUtils.isBlank((String)node.getLabelString()) ? "master" : node.getLabelString();
            }
        }
        this.id = build.getId();
        this.projectName = build.getParent().getName();
        this.fullProjectName = build.getParent().getFullName();
        this.displayName = build.getDisplayName();
        this.fullDisplayName = build.getFullDisplayName();
        this.description = build.getDescription();
        this.url = build.getUrl();
        this.buildNum = build.getNumber();
        this.buildDuration = currentTime.getTime() - build.getStartTimeInMillis();
        this.timestamp = LogstashConfiguration.getInstance().getDateFormatter().format(build.getTimestamp().getTime());
        this.updateResult();
    }

    public void updateResult() {
        if (this.result == null && this.build.getResult() != null) {
            Result result = this.build.getResult();
            this.result = result == null ? null : result.toString();
        }
        Action testResultAction = this.build.getAction(AbstractTestResultAction.class);
        if (this.testResults == null && testResultAction != null) {
            this.testResults = new TestData(testResultAction);
        }
    }

    public String toString() {
        Gson gson = new GsonBuilder().create();
        return gson.toJson((Object)this);
    }

    public JSONObject toJson() {
        String data = this.toString();
        return JSONObject.fromObject((Object)data);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result.toString();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getFullProjectName() {
        return this.fullProjectName;
    }

    public void setFullProjectName(String fullProjectName) {
        this.fullProjectName = fullProjectName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getFullDisplayName() {
        return this.fullDisplayName;
    }

    public void setFullDisplayName(String fullDisplayName) {
        this.fullDisplayName = fullDisplayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getBuildHost() {
        return this.buildHost;
    }

    public void setBuildHost(String buildHost) {
        this.buildHost = buildHost;
    }

    public String getBuildLabel() {
        return this.buildLabel;
    }

    public void setBuildLabel(String buildLabel) {
        this.buildLabel = buildLabel;
    }

    public int getBuildNum() {
        return this.buildNum;
    }

    public void setBuildNum(int buildNum) {
        this.buildNum = buildNum;
    }

    public long getBuildDuration() {
        return this.buildDuration;
    }

    public void setBuildDuration(long buildDuration) {
        this.buildDuration = buildDuration;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Calendar timestamp) {
        this.timestamp = LogstashConfiguration.getInstance().getDateFormatter().format(timestamp.getTime());
    }

    public String getRootProjectName() {
        return this.rootProjectName;
    }

    public void setRootProjectName(String rootProjectName) {
        this.rootProjectName = rootProjectName;
    }

    public String getRootFullProjectName() {
        return this.rootFullProjectName;
    }

    public void setRootFullProjectName(String rootFullProjectName) {
        this.rootFullProjectName = rootFullProjectName;
    }

    public String getRootProjectDisplayName() {
        return this.rootProjectDisplayName;
    }

    public void setRootProjectDisplayName(String rootProjectDisplayName) {
        this.rootProjectDisplayName = rootProjectDisplayName;
    }

    public int getRootBuildNum() {
        return this.rootBuildNum;
    }

    public void setRootBuildNum(int rootBuildNum) {
        this.rootBuildNum = rootBuildNum;
    }

    public Map<String, String> getBuildVariables() {
        return this.buildVariables;
    }

    public void setBuildVariables(Map<String, String> buildVariables) {
        this.buildVariables = buildVariables;
    }

    public Set<String> getSensitiveBuildVariables() {
        return this.sensitiveBuildVariables;
    }

    public void setSensitiveBuildVariables(Set<String> sensitiveBuildVariables) {
        this.sensitiveBuildVariables = sensitiveBuildVariables;
    }

    public TestData getTestResults() {
        return this.testResults;
    }

    public void setTestResults(TestData testResults) {
        this.testResults = testResults;
    }

    public static class TestData {
        private final int totalCount;
        private final int skipCount;
        private final int failCount;
        private final int passCount;
        private final List<FailedTest> failedTestsWithErrorDetail;
        private final List<String> failedTests;

        public TestData() {
            this(null);
        }

        public TestData(Action action) {
            AbstractTestResultAction testResultAction = null;
            if (action instanceof AbstractTestResultAction) {
                testResultAction = (AbstractTestResultAction)action;
            }
            if (testResultAction == null) {
                this.passCount = 0;
                this.failCount = 0;
                this.skipCount = 0;
                this.totalCount = 0;
                this.failedTests = Collections.emptyList();
                this.failedTestsWithErrorDetail = Collections.emptyList();
                return;
            }
            this.totalCount = testResultAction.getTotalCount();
            this.skipCount = testResultAction.getSkipCount();
            this.failCount = testResultAction.getFailCount();
            this.passCount = this.totalCount - this.skipCount - this.failCount;
            this.failedTests = new ArrayList<String>();
            this.failedTestsWithErrorDetail = new ArrayList<FailedTest>();
            for (TestResult result : testResultAction.getFailedTests()) {
                this.failedTests.add(result.getFullName());
                this.failedTestsWithErrorDetail.add(new FailedTest(result.getFullName(), result.getErrorDetails()));
            }
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public int getSkipCount() {
            return this.skipCount;
        }

        public int getFailCount() {
            return this.failCount;
        }

        public int getPassCount() {
            return this.passCount;
        }

        public List<FailedTest> getFailedTestsWithErrorDetail() {
            return this.failedTestsWithErrorDetail;
        }

        public List<String> getFailedTests() {
            return this.failedTests;
        }

        public static class FailedTest {
            private final String fullName;
            private final String errorDetails;

            public FailedTest(String fullName, String errorDetails) {
                this.fullName = fullName;
                this.errorDetails = errorDetails;
            }

            public String getFullName() {
                return this.fullName;
            }

            public String getErrorDetails() {
                return this.errorDetails;
            }
        }
    }
}

