/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.logstash.LogstashConfiguration;
import jenkins.plugins.logstash.persistence.BuildData;
import jenkins.plugins.logstash.persistence.LogstashIndexerDao;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class LogstashWriter {
    private final OutputStream errorStream;
    private final Run<?, ?> build;
    private final TaskListener listener;
    private final BuildData buildData;
    private final String jenkinsUrl;
    private final LogstashIndexerDao dao;
    private boolean connectionBroken;
    private final Charset charset;

    public LogstashWriter(Run<?, ?> run, OutputStream error, TaskListener listener, Charset charset) {
        this.errorStream = error != null ? error : System.err;
        this.build = run;
        this.listener = listener;
        this.charset = charset;
        this.dao = this.getDaoOrNull();
        if (this.dao == null) {
            this.jenkinsUrl = "";
            this.buildData = null;
        } else {
            this.jenkinsUrl = this.getJenkinsUrl();
            this.buildData = this.getBuildData();
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    LogstashIndexerDao getDao() {
        return this.dao;
    }

    public void write(String line) {
        if (!this.isConnectionBroken() && StringUtils.isNotEmpty((String)line)) {
            this.write(Arrays.asList(line));
        }
    }

    public void writeBuildLog(int maxLines) {
        if (!this.isConnectionBroken()) {
            List<String> logLines;
            try {
                logLines = maxLines < 0 ? this.build.getLog(Integer.MAX_VALUE) : this.build.getLog(maxLines);
            }
            catch (IOException e) {
                String msg = "[logstash-plugin]: Unable to serialize log data.\n" + ExceptionUtils.getStackTrace((Throwable)e);
                this.logErrorMessage(msg);
                logLines = Arrays.asList(msg.split("\n"));
            }
            this.write(logLines);
        }
    }

    public boolean isConnectionBroken() {
        return this.connectionBroken || this.build == null || this.dao == null || this.buildData == null;
    }

    LogstashIndexerDao getIndexerDao() {
        return LogstashConfiguration.getInstance().getIndexerInstance();
    }

    BuildData getBuildData() {
        if (this.build instanceof AbstractBuild) {
            return new BuildData((AbstractBuild)this.build, new Date(), this.listener);
        }
        return new BuildData(this.build, new Date(), this.listener);
    }

    String getJenkinsUrl() {
        return Jenkins.getInstance().getRootUrl();
    }

    private void write(List<String> lines) {
        this.buildData.updateResult();
        JSONObject payload = this.dao.buildPayload(this.buildData, this.jenkinsUrl, lines);
        try {
            this.dao.push(payload.toString());
        }
        catch (IOException e) {
            String msg = "[logstash-plugin]: Failed to send log data: " + this.dao.getDescription() + ".\n[logstash-plugin]: No Further logs will be sent to " + this.dao.getDescription() + ".\n" + ExceptionUtils.getStackTrace((Throwable)e);
            this.logErrorMessage(msg);
        }
    }

    private LogstashIndexerDao getDaoOrNull() {
        try {
            LogstashIndexerDao dao = this.getIndexerDao();
            if (dao == null) {
                this.logErrorMessage("[logstash-plugin]: Unable to instantiate LogstashIndexerDao with current configuration.\n");
            }
            return dao;
        }
        catch (IllegalArgumentException e) {
            String msg = ExceptionUtils.getMessage((Throwable)e) + "\n[logstash-plugin]: Unable to instantiate LogstashIndexerDao with current configuration.\n";
            this.logErrorMessage(msg);
            return null;
        }
    }

    private void logErrorMessage(String msg) {
        try {
            this.connectionBroken = true;
            this.errorStream.write(msg.getBytes(this.charset));
            this.errorStream.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

