/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.plugins.logparser.LogParserLogPart;
import hudson.plugins.logparser.LogParserUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogParserReader {
    private final BufferedReader reader;
    int logPartNum = 0;
    boolean endOfFile = false;

    public LogParserReader(BufferedReader reader) {
        this.reader = reader;
    }

    public synchronized LogParserLogPart readLogPart(int threadNum) throws IOException {
        String line;
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.log(Level.INFO, "Start reading log part " + this.logPartNum + " in thread #" + threadNum);
        int numLines = LogParserUtils.getLinesPerThread();
        String[] lines = new String[numLines];
        LogParserLogPart result = new LogParserLogPart();
        int counter = 0;
        while (counter < numLines && (line = this.reader.readLine()) != null) {
            lines[counter++] = line;
        }
        logger.log(Level.INFO, "Done reading log part " + this.logPartNum);
        result.setLines(lines);
        result.setLogPartNum(this.logPartNum);
        if (result.isEmpty()) {
            this.endOfFile = true;
        }
        ++this.logPartNum;
        return result;
    }

    public boolean isEndOfFile() {
        return this.endOfFile;
    }

    public void setEndOfFile(boolean endOfFile) {
        this.endOfFile = endOfFile;
    }
}

