/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.loadcomplete;

import com.smartbear.jenkins.plugins.loadcomplete.LCLog;
import com.smartbear.jenkins.plugins.loadcomplete.Messages;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.jenkinsci.remoting.RoleChecker;

public class Utils {
    private Utils() {
    }

    public static boolean isWindows(VirtualChannel channel, TaskListener listener) {
        try {
            return (Boolean)channel.call((Callable)new Callable<Boolean, Exception>(){

                public void checkRoles(RoleChecker roleChecker) throws SecurityException {
                }

                public Boolean call() throws Exception {
                    String os = System.getProperty("os.name");
                    if (os != null) {
                        os = os.toLowerCase();
                    }
                    return os != null && os.contains("windows");
                }
            });
        }
        catch (Exception e) {
            LCLog.error(listener, Messages.LCTestBuilder_RemoteCallingFailed(), e);
            return false;
        }
    }

    public static long getSystemTime(VirtualChannel channel, TaskListener listener) {
        try {
            return (Long)channel.call((Callable)new Callable<Long, Exception>(){

                public void checkRoles(RoleChecker roleChecker) throws SecurityException {
                }

                public Long call() throws Exception {
                    return System.currentTimeMillis();
                }
            });
        }
        catch (Exception e) {
            LCLog.error(listener, Messages.LCTestBuilder_RemoteCallingFailed(), e);
            return 0L;
        }
    }

    public static class BusyNodeList {
        private Map<WeakReference<Node>, Semaphore> nodeLocks = new HashMap<WeakReference<Node>, Semaphore>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock(Node node, TaskListener listener) throws InterruptedException {
            Semaphore semaphore = null;
            BusyNodeList busyNodeList = this;
            synchronized (busyNodeList) {
                for (WeakReference<Node> nodeRef : this.nodeLocks.keySet()) {
                    Node actualNode = (Node)nodeRef.get();
                    if (actualNode == null || actualNode != node) continue;
                    semaphore = this.nodeLocks.get(nodeRef);
                }
                if (semaphore == null) {
                    semaphore = new Semaphore(1, true);
                    this.nodeLocks.put(new WeakReference<Node>(node), semaphore);
                } else {
                    listener.getLogger().println();
                    LCLog.info(listener, Messages.LCTestBuilder_WaitingForNodeRelease(), new Object[0]);
                }
            }
            semaphore.acquire();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(Node node) throws InterruptedException {
            Semaphore semaphore = null;
            BusyNodeList busyNodeList = this;
            synchronized (busyNodeList) {
                for (WeakReference<Node> nodeRef : this.nodeLocks.keySet()) {
                    Node actualNode = (Node)nodeRef.get();
                    if (actualNode == null || actualNode != node) continue;
                    semaphore = this.nodeLocks.get(nodeRef);
                }
            }
            if (semaphore != null) {
                semaphore.release();
            }
            Thread.sleep(200L);
            busyNodeList = this;
            synchronized (busyNodeList) {
                ArrayList<WeakReference<Node>> toRemove = new ArrayList<WeakReference<Node>>();
                for (WeakReference<Object> nodeRef : this.nodeLocks.keySet()) {
                    Node actualNode = (Node)nodeRef.get();
                    if (actualNode == null || actualNode != node || (semaphore = this.nodeLocks.get(nodeRef)).availablePermits() <= 0) continue;
                    toRemove.add(nodeRef);
                }
                for (WeakReference<Object> nodeRef : toRemove) {
                    this.nodeLocks.remove(nodeRef);
                }
            }
        }
    }
}

