/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.loadcomplete;

import com.smartbear.jenkins.plugins.loadcomplete.LCInstallation;
import com.smartbear.jenkins.plugins.loadcomplete.LCInstallationsScanner;
import com.smartbear.jenkins.plugins.loadcomplete.LCLog;
import com.smartbear.jenkins.plugins.loadcomplete.LCLogInfo;
import com.smartbear.jenkins.plugins.loadcomplete.LCReportAction;
import com.smartbear.jenkins.plugins.loadcomplete.LCSummaryAction;
import com.smartbear.jenkins.plugins.loadcomplete.Messages;
import com.smartbear.jenkins.plugins.loadcomplete.Utils;
import com.smartbear.jenkins.plugins.loadcomplete.Workspace;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.tasks.junit.TestResultAction;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class LCTestBuilder
extends Builder
implements Serializable,
SimpleBuildStep {
    private static final String SILENT_MODE_ARG = "/SilentMode";
    private static final String NS_ARG = "/ns";
    private static final String RUN_ARG = "/run";
    private static final String EXIT_ARG = "/exit";
    private static final String EXPORT_LOG_ARG = "/ExportLog:";
    private static final String ERROR_LOG_ARG = "/ErrorLog:";
    private static final String TEST_ARG = "/test:";
    private static final String FORCE_CONVERSION_ARG = "/ForceConversion";
    private static final String DEBUG_FLAG_NAME = "LOADCOMPLETE_PLUGIN_DEBUG";
    private boolean DEBUG = false;
    private String project;
    private String test;
    private String executorVersion;
    private String actionOnWarnings;
    private String actionOnErrors;
    private boolean useTimeout;
    private String timeout;
    private boolean generatePDF;
    private boolean generateMHT;
    private static Utils.BusyNodeList busyNodes = new Utils.BusyNodeList();

    @DataBoundConstructor
    public LCTestBuilder(String project, String test) {
        this.project = project != null ? project : "";
        this.test = test != null ? test : "";
        this.executorVersion = "any";
        this.actionOnWarnings = BuildStepAction.NONE.toString();
        this.actionOnErrors = BuildStepAction.MAKE_UNSTABLE.toString();
        this.useTimeout = false;
        this.timeout = "";
        this.generatePDF = true;
        this.generateMHT = false;
    }

    @DataBoundSetter
    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    @DataBoundSetter
    public void setTest(String test) {
        this.test = test;
    }

    public String getTest() {
        return this.test;
    }

    @DataBoundSetter
    public void setExecutorVersion(String executorVersion) {
        this.executorVersion = executorVersion;
    }

    public String getExecutorVersion() {
        return this.executorVersion;
    }

    @DataBoundSetter
    public void setActionOnWarnings(String actionOnWarnings) {
        this.actionOnWarnings = actionOnWarnings;
    }

    public String getActionOnWarnings() {
        return this.actionOnWarnings;
    }

    @DataBoundSetter
    public void setActionOnErrors(String actionOnErrors) {
        this.actionOnErrors = actionOnErrors;
    }

    public String getActionOnErrors() {
        return this.actionOnErrors;
    }

    @DataBoundSetter
    public void setUseTimeout(boolean useTimeout) {
        this.useTimeout = useTimeout;
    }

    public boolean getUseTimeout() {
        return this.useTimeout;
    }

    @DataBoundSetter
    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setGeneratePDF(boolean generatePDF) {
        this.generatePDF = generatePDF;
    }

    public boolean getGeneratePDF() {
        return this.generatePDF;
    }

    @DataBoundSetter
    public void setGenerateMHT(boolean generateMHT) {
        this.generateMHT = generateMHT;
    }

    public boolean getGenerateMHT() {
        return this.generateMHT;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        Node currentNode = run.getExecutor().getOwner().getNode();
        busyNodes.lock(currentNode, taskListener);
        try {
            this.performInternal(run, filePath, launcher, taskListener);
        }
        finally {
            busyNodes.release(currentNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performInternal(Run<?, ?> run, FilePath filePath, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        Workspace workspace;
        String testDisplayName;
        PrintStream logger = listener.getLogger();
        logger.println();
        EnvVars env = run.getEnvironment(listener);
        this.DEBUG = false;
        try {
            this.DEBUG = Boolean.parseBoolean(env.expand("${LOADCOMPLETE_PLUGIN_DEBUG}"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.DEBUG) {
            LCLog.debug(listener, Messages.LCTestBuilder_Debug_Enabled(), new Object[0]);
        }
        try {
            testDisplayName = this.makeDisplayName(run, listener);
        }
        catch (Exception e) {
            LCLog.error(listener, Messages.LCTestBuilder_ExceptionOccurred(), e.toString());
            LCLog.info(listener, Messages.LCTestBuilder_MarkingBuildAsFailed(), new Object[0]);
            run.setResult(Result.FAILURE);
            return false;
        }
        LCLog.info(listener, Messages.LCTestBuilder_TestStartedMessage(), testDisplayName);
        if (!Utils.isWindows(launcher.getChannel(), listener)) {
            LCLog.error(listener, Messages.LCTestBuilder_NotWindowsOS(), new Object[0]);
            LCLog.info(listener, Messages.LCTestBuilder_MarkingBuildAsFailed(), new Object[0]);
            run.setResult(Result.FAILURE);
            return false;
        }
        LCInstallationsScanner scanner = new LCInstallationsScanner(launcher.getChannel(), listener);
        List<LCInstallation> installations = scanner.getInstallations();
        StringBuilder msgBuilder = new StringBuilder();
        msgBuilder.append(Messages.LCTestBuilder_FoundedInstallations());
        for (LCInstallation i : installations) {
            msgBuilder.append("\n\t").append(i);
        }
        LCLog.info(listener, msgBuilder.toString(), new Object[0]);
        LCInstallation chosenInstallation = scanner.findInstallation(installations, this.getExecutorVersion());
        if (chosenInstallation == null) {
            LCLog.error(listener, Messages.LCTestBuilder_InstallationNotFound(), new Object[0]);
            LCLog.info(listener, Messages.LCTestBuilder_MarkingBuildAsFailed(), new Object[0]);
            run.setResult(Result.FAILURE);
            return false;
        }
        if (chosenInstallation.compareVersion("4.95", false) < 0) {
            LCLog.error(listener, Messages.LCTestBuilder_UnsupportedVersion(), new Object[0]);
            LCLog.info(listener, Messages.LCTestBuilder_MarkingBuildAsFailed(), new Object[0]);
            run.setResult(Result.FAILURE);
            return false;
        }
        LCLog.info(listener, Messages.LCTestBuilder_ChosenInstallation() + "\n\t" + chosenInstallation, new Object[0]);
        try {
            workspace = new Workspace(run, filePath);
        }
        catch (IOException e) {
            LCLog.error(listener, Messages.LCTestBuilder_ExceptionOccurred(), e.toString());
            LCLog.info(listener, Messages.LCTestBuilder_MarkingBuildAsFailed(), new Object[0]);
            run.setResult(Result.FAILURE);
            return false;
        }
        ArgumentListBuilder args = this.makeCommandLineArgs(run, launcher, listener, workspace, chosenInstallation);
        LCReportAction LCReportAction2 = new LCReportAction(run, workspace.getLogId(), testDisplayName, run.getExecutor().getOwner().getNode().getDisplayName());
        int exitCode = -2;
        boolean result = false;
        Proc process = null;
        try {
            LCLog.info(listener, Messages.LCTestBuilder_LaunchingTestRunner(), new Object[0]);
            long timeout = this.getTimeoutValue(null, env);
            long startTime = Utils.getSystemTime(launcher.getChannel(), listener);
            Launcher.ProcStarter processStarter = launcher.launch().cmds(args).envs((Map)run.getEnvironment(listener));
            process = processStarter.start();
            exitCode = timeout == -1L ? process.join() : process.joinWithTimeout(timeout, TimeUnit.SECONDS, listener);
            process = null;
            long stopTime = Utils.getSystemTime(launcher.getChannel(), listener);
            LCLog.info(listener, Messages.LCTestBuilder_ExitCodeMessage(), exitCode);
            this.processFiles(listener, workspace, LCReportAction2, startTime, stopTime, exitCode);
            if (exitCode == 0) {
                result = true;
            } else if (exitCode == 1) {
                LCLog.warning(listener, Messages.LCTestBuilder_BuildStepHasWarnings(), new Object[0]);
                if (this.actionOnWarnings.equals(BuildStepAction.MAKE_UNSTABLE.name())) {
                    LCLog.info(listener, Messages.LCTestBuilder_MarkingBuildAsUnstable(), new Object[0]);
                    run.setResult(Result.UNSTABLE);
                    result = true;
                } else if (this.actionOnWarnings.equals(BuildStepAction.MAKE_FAILED.name())) {
                    LCLog.info(listener, Messages.LCTestBuilder_MarkingBuildAsFailed(), new Object[0]);
                    run.setResult(Result.FAILURE);
                } else {
                    result = true;
                }
            } else {
                LCLog.warning(listener, Messages.LCTestBuilder_BuildStepHasErrors(), new Object[0]);
                if (this.actionOnErrors.equals(BuildStepAction.MAKE_UNSTABLE.name())) {
                    LCLog.info(listener, Messages.LCTestBuilder_MarkingBuildAsUnstable(), new Object[0]);
                    run.setResult(Result.UNSTABLE);
                } else if (this.actionOnErrors.equals(BuildStepAction.MAKE_FAILED.name())) {
                    LCLog.info(listener, Messages.LCTestBuilder_MarkingBuildAsFailed(), new Object[0]);
                    run.setResult(Result.FAILURE);
                }
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            LCLog.error(listener, Messages.LCTestBuilder_ExceptionOccurred(), e.getCause() == null ? e.toString() : e.getCause().toString());
            LCLog.info(listener, Messages.LCTestBuilder_MarkingBuildAsFailed(), new Object[0]);
            run.setResult(Result.FAILURE);
        }
        finally {
            if (process != null) {
                try {
                    process.kill();
                }
                catch (Exception e) {}
            }
            LCReportAction2.setExitCode(exitCode);
            LCReportAction2.setResult(result);
            LCSummaryAction currentAction = this.getOrCreateAction(run);
            currentAction.addReport(LCReportAction2);
        }
        LCLog.info(listener, Messages.LCTestBuilder_TestExecutionFinishedMessage(), testDisplayName);
        return true;
    }

    private TestResultAction getTestResultAction(AbstractBuild<?, ?> build) {
        return (TestResultAction)build.getAction(TestResultAction.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFiles(TaskListener listener, Workspace workspace, LCReportAction testResult, long startTime, long stopTime, int exitCode) throws IOException, InterruptedException {
        String logFileName;
        boolean hasError = false;
        BufferedReader br = null;
        try {
            if (workspace.getSlaveErrorFilePath().exists()) {
                br = new BufferedReader(new InputStreamReader(workspace.getSlaveErrorFilePath().read(), Charset.forName("UTF-8")));
                String errorString = br.readLine().trim();
                LCLog.warning(listener, Messages.LCTestBuilder_ErrorMessage(), errorString);
                testResult.setError(errorString);
                hasError = true;
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            workspace.getSlaveErrorFilePath().delete();
        }
        String extraInfo = "";
        if (!hasError && exitCode > -1 && exitCode < 3) {
            extraInfo = " " + Messages.LCTestBuilder_CheckLogGenerationOptions();
        }
        if (workspace.getSlaveZIPFilePath().exists()) {
            try {
                workspace.getSlaveZIPFilePath().copyTo(workspace.getMasterZIPFilePath());
                logFileName = workspace.getMasterZIPFilePath().getName();
                testResult.setZipLogFileName(logFileName);
                LCLogInfo info = new LCLogInfo(startTime, stopTime);
                testResult.setLogInfo(info);
            }
            finally {
                workspace.getSlaveZIPFilePath().delete();
            }
        } else {
            LCLog.warning(listener, Messages.LCTestBuilder_UnableToFindLogFile() + extraInfo, workspace.getSlaveZIPFilePath().getName());
            testResult.setLogInfo(new LCLogInfo(startTime, stopTime));
        }
        if (this.getGeneratePDF()) {
            if (workspace.getSlavePDFFilePath().exists()) {
                try {
                    workspace.getSlavePDFFilePath().copyTo(workspace.getMasterPDFFilePath());
                    logFileName = workspace.getMasterPDFFilePath().getName();
                    testResult.setPdfLogFileName(logFileName);
                }
                finally {
                    workspace.getSlavePDFFilePath().delete();
                }
            } else {
                LCLog.warning(listener, Messages.LCTestBuilder_UnableToFindLogFile() + extraInfo, workspace.getSlavePDFFilePath().getName());
            }
        }
        if (this.getGenerateMHT()) {
            if (workspace.getSlaveMHTFilePath().exists()) {
                try {
                    workspace.getSlaveMHTFilePath().copyTo(workspace.getMasterMHTFilePath());
                    logFileName = workspace.getMasterMHTFilePath().getName();
                    testResult.setMhtLogFileName(logFileName);
                }
                finally {
                    workspace.getSlaveMHTFilePath().delete();
                }
            } else {
                LCLog.warning(listener, Messages.LCTestBuilder_UnableToFindLogFile() + extraInfo, workspace.getSlaveMHTFilePath().getName());
            }
        }
    }

    private String makeDisplayName(Run<?, ?> run, TaskListener listener) throws IOException, InterruptedException {
        StringBuilder builder = new StringBuilder();
        EnvVars env = run.getEnvironment(listener);
        String projectFileName = new FilePath(new File(env.expand(this.getProject()))).getBaseName();
        builder.append(projectFileName);
        builder.append("/");
        builder.append(env.expand(this.getTest()));
        return builder.toString();
    }

    private long getTimeoutValue(BuildListener listener, EnvVars env) {
        if (this.getUseTimeout()) {
            try {
                long timeout = Long.parseLong(env.expand(this.getTimeout()));
                if (timeout > 0L) {
                    return timeout;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (listener != null) {
                LCLog.warning((TaskListener)listener, Messages.LCTestBuilder_InvalidTimeoutValue(), env.expand(this.getTimeout()));
            }
        }
        return -1L;
    }

    private ArgumentListBuilder makeCommandLineArgs(Run<?, ?> run, Launcher launcher, TaskListener listener, Workspace workspace, LCInstallation installation) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        FilePath execPath = new FilePath(launcher.getChannel(), installation.getExecutorPath());
        args.add(execPath.getRemote());
        EnvVars env = run.getEnvironment(listener);
        args.add((Object)new FilePath(workspace.getSlaveWorkspacePath(), env.expand(this.getProject()).replaceAll("\"", "\"\"")));
        args.add(TEST_ARG + env.expand(this.getTest()).replaceAll("\"", "\"\""));
        args.add(SILENT_MODE_ARG);
        args.add(FORCE_CONVERSION_ARG);
        args.add(NS_ARG);
        args.add(RUN_ARG);
        args.add(EXIT_ARG);
        args.add(ERROR_LOG_ARG + workspace.getSlaveErrorFilePath().getRemote());
        args.add(EXPORT_LOG_ARG + workspace.getSlaveZIPFilePath().getRemote());
        if (this.getGeneratePDF()) {
            args.add(EXPORT_LOG_ARG + workspace.getSlavePDFFilePath().getRemote());
        }
        if (this.getGenerateMHT()) {
            args.add(EXPORT_LOG_ARG + workspace.getSlaveMHTFilePath().getRemote());
        }
        return args;
    }

    private LCSummaryAction getOrCreateAction(Run<?, ?> run) {
        LCSummaryAction currentAction = (LCSummaryAction)run.getAction(LCSummaryAction.class);
        if (currentAction == null) {
            currentAction = new LCSummaryAction(run);
            run.addAction((Action)currentAction);
        }
        return currentAction;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"loadcompletetest"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            super(LCTestBuilder.class);
            this.load();
        }

        public String getPluginUrl() {
            return "loadcomplete";
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)super.newInstance(req, formData);
        }

        public FormValidation doCheckProject(@QueryParameter String value) throws IOException, ServletException {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.LCTestBuilder_Descriptor_ValueNotSpecified());
            }
            if (value.contains("\"")) {
                return FormValidation.error((String)String.format(Messages.LCTestBuilder_Descriptor_InvalidCharacter(), "\""));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTest(@QueryParameter String value) throws IOException, ServletException {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.LCTestBuilder_Descriptor_ValueNotSpecified());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) throws IOException, ServletException {
            try {
                Integer.parseInt(value);
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.LCTestBuilder_Descriptor_IsNotNumber());
            }
        }

        public ListBoxModel doFillExecutorVersionItems() {
            ListBoxModel model = new ListBoxModel();
            model.add(Messages.LCTestBuilder_Descriptor_LatestTagText(), "any");
            model.add("4", "4");
            return model;
        }

        public ListBoxModel doFillActionOnWarningsItems() {
            ListBoxModel model = new ListBoxModel();
            model.add(Messages.BuildStepAction_None(), BuildStepAction.NONE.name());
            model.add(Messages.BuildStepAction_MakeUnstable(), BuildStepAction.MAKE_UNSTABLE.name());
            model.add(Messages.BuildStepAction_MakeFailed(), BuildStepAction.MAKE_FAILED.name());
            return model;
        }

        public ListBoxModel doFillActionOnErrorsItems() {
            ListBoxModel model = new ListBoxModel();
            model.add(Messages.BuildStepAction_None(), BuildStepAction.NONE.name());
            model.add(Messages.BuildStepAction_MakeUnstable(), BuildStepAction.MAKE_UNSTABLE.name());
            model.add(Messages.BuildStepAction_MakeFailed(), BuildStepAction.MAKE_FAILED.name());
            return model;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.LCTestBuilder_DisplayName();
        }
    }

    public static enum BuildStepAction {
        NONE,
        MAKE_UNSTABLE,
        MAKE_FAILED;

    }
}

