/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.loadcomplete;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class LCLogInfo
implements Serializable {
    private final long startTime;
    private final long stopTime;
    private final long testDuration;
    private String XML = null;

    public LCLogInfo(long startTime, long stopTime) {
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.testDuration = stopTime > startTime ? stopTime - startTime : 0L;
    }

    @Exported(name="timestamp")
    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    @Exported(name="duration")
    public long getTestDuration() {
        return this.testDuration;
    }

    public String formatStartTime() {
        Date date = new Date(this.startTime);
        return DateFormat.getDateTimeInstance().format(date);
    }

    public String formatStopTime() {
        Date date = new Date(this.stopTime);
        return DateFormat.getDateTimeInstance().format(date);
    }

    public String formatTestDuration() {
        long timeInSeconds = this.testDuration / 1000L;
        long s = timeInSeconds % 60L;
        long m = timeInSeconds / 60L % 60L;
        long h = timeInSeconds / 3600L;
        return String.format("%d:%02d:%02d", h, m, s);
    }

    public String getXML() {
        return this.XML;
    }

    public void setXML(String XML) {
        this.XML = XML;
    }
}

