/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt.lib.libvirt;

import hudson.plugins.libvirt.lib.IConnect;
import hudson.plugins.libvirt.lib.IDomain;
import hudson.plugins.libvirt.lib.VirtException;
import hudson.plugins.libvirt.lib.libvirt.LibVirtDomainImpl;
import org.libvirt.Connect;
import org.libvirt.LibvirtException;

public class LibVirtConnectImpl
implements IConnect {
    private final Connect connect;

    public LibVirtConnectImpl(Connect connect) {
        this.connect = connect;
    }

    public LibVirtConnectImpl(String hypervisorUri, boolean b) throws VirtException {
        try {
            this.connect = new Connect(hypervisorUri, b);
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    @Override
    public long getVersion() throws VirtException {
        try {
            return this.connect.getVersion();
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    @Override
    public int[] listDomains() throws VirtException {
        try {
            return this.connect.listDomains();
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    @Override
    public String[] listDefinedDomains() throws VirtException {
        try {
            return this.connect.listDefinedDomains();
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    @Override
    public IDomain domainLookupByName(String c) throws VirtException {
        try {
            return new LibVirtDomainImpl(this.connect.domainLookupByName(c));
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    @Override
    public IDomain domainLookupByID(int c) throws VirtException {
        try {
            return new LibVirtDomainImpl(this.connect.domainLookupByID(c));
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    @Override
    public void close() throws VirtException {
        try {
            this.connect.close();
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    @Override
    public boolean isConnected() throws VirtException {
        try {
            return this.connect.isConnected();
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }
}

