/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt.lib;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.plugins.libvirt.lib.IConnect;
import hudson.plugins.libvirt.lib.VirtException;
import hudson.plugins.libvirt.lib.jlibvirt.JLibVirtConnectImpl;
import hudson.plugins.libvirt.lib.libvirt.LibVirtConnectImpl;

public class ConnectionBuilder {
    private boolean useNativeJava = false;
    private String uri;
    private boolean readOnly = false;
    private String hypervisorType;
    private String userName;
    private String hypervisorHost;
    private int hypervisorPort = 22;
    private String hypervisorSysUrl;
    private String protocol = "ssh://";
    private StandardUsernameCredentials credentials;

    public static ConnectionBuilder newBuilder() {
        return new ConnectionBuilder();
    }

    public ConnectionBuilder hypervisorType(String hypervisorType) {
        this.hypervisorType = hypervisorType;
        return this;
    }

    public ConnectionBuilder userName(String userName) {
        this.userName = userName;
        return this;
    }

    public ConnectionBuilder hypervisorHost(String hypervisorHost) {
        this.hypervisorHost = hypervisorHost;
        return this;
    }

    public ConnectionBuilder hypervisorPort(int hypervisorPort) {
        this.hypervisorPort = hypervisorPort;
        return this;
    }

    public ConnectionBuilder hypervisorSysUrl(String hypervisorSysUrl) {
        this.hypervisorSysUrl = hypervisorSysUrl;
        return this;
    }

    public ConnectionBuilder protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public ConnectionBuilder withCredentials(StandardUsernameCredentials standardUsernameCredentials) {
        this.credentials = standardUsernameCredentials;
        return this;
    }

    public ConnectionBuilder useUri(String uri) {
        this.uri = uri;
        return this;
    }

    public ConnectionBuilder readOnly() {
        this.readOnly = true;
        return this;
    }

    public ConnectionBuilder useNativeJava(boolean b) {
        this.useNativeJava = b;
        return this;
    }

    public IConnect build() throws VirtException {
        if (this.useNativeJava) {
            if (this.uri == null) {
                this.uri = this.constructNativeHypervisorURI();
            }
            StandardUsernamePasswordCredentials standardUsernamePasswordCredentials = (StandardUsernamePasswordCredentials)this.credentials;
            return new JLibVirtConnectImpl(this.hypervisorHost, this.hypervisorPort, this.credentials.getUsername(), standardUsernamePasswordCredentials.getPassword().getPlainText(), this.uri, this.readOnly);
        }
        if (this.uri == null) {
            this.uri = this.constructHypervisorURI();
        }
        return new LibVirtConnectImpl(this.uri, this.readOnly);
    }

    public String constructHypervisorURI() {
        String separator = this.hypervisorSysUrl.contains("?") ? "&" : "?";
        return this.hypervisorType.toLowerCase() + "+" + this.protocol + this.userName + "@" + this.hypervisorHost + ":" + this.hypervisorPort + "/" + this.hypervisorSysUrl + separator + "no_tty=1";
    }

    public String constructNativeHypervisorURI() {
        String separator = this.hypervisorSysUrl.contains("?") ? "&" : "?";
        return this.hypervisorType.toLowerCase() + ":///" + this.hypervisorSysUrl + separator + "no_tty=1";
    }
}

