/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.plugins.libvirt.Hypervisor;
import hudson.plugins.libvirt.VirtualMachineLauncher;
import hudson.plugins.libvirt.VirtualMachineSlave;
import hudson.plugins.libvirt.lib.IDomain;
import hudson.slaves.OfflineCause;
import hudson.slaves.SlaveComputer;
import hudson.util.StreamTaskListener;
import hudson.util.io.ReopenableRotatingFileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualMachineSlaveComputer
extends SlaveComputer {
    private static final Logger logger = Logger.getLogger(VirtualMachineSlaveComputer.class.getName());
    private final TaskListener taskListener = new StreamTaskListener((OutputStream)new ReopenableRotatingFileOutputStream(this.getLogFile(), 10));

    public VirtualMachineSlaveComputer(Slave slave) {
        super(slave);
    }

    public Future<?> disconnect(OfflineCause cause) {
        VirtualMachineSlave slave = (VirtualMachineSlave)this.getNode();
        String virtualMachineName = slave.getVirtualMachineName();
        VirtualMachineLauncher vmL = (VirtualMachineLauncher)this.getLauncher();
        Hypervisor hypervisor = vmL.findOurHypervisorInstance();
        logger.log(Level.INFO, "Virtual machine \"" + virtualMachineName + "\" (slave \"" + this.getDisplayName() + "\") is to be shut down. reason: " + cause + " (" + cause.getClass().getName() + ")");
        this.taskListener.getLogger().println("Virtual machine \"" + virtualMachineName + "\" (slave \"" + this.getDisplayName() + "\") is to be shut down.");
        try {
            Map<String, IDomain> computers = hypervisor.getDomains();
            IDomain domain = computers.get(virtualMachineName);
            if (domain != null) {
                if (domain.isRunningOrBlocked()) {
                    String snapshotName = slave.getSnapshotName();
                    if (snapshotName != null && snapshotName.length() > 0) {
                        this.taskListener.getLogger().println("Reverting to " + snapshotName + " and shutting down.");
                        domain.revertToSnapshot(domain.snapshotLookupByName(snapshotName));
                    } else {
                        this.taskListener.getLogger().println("Shutting down.");
                        System.err.println("method: " + slave.getShutdownMethod());
                        if (slave.getShutdownMethod().equals("suspend")) {
                            domain.suspend();
                        } else if (slave.getShutdownMethod().equals("destroy")) {
                            domain.destroy();
                        } else {
                            domain.shutdown();
                        }
                    }
                } else {
                    this.taskListener.getLogger().println("Already suspended, no shutdown required.");
                }
                Hypervisor vmC = vmL.findOurHypervisorInstance();
                vmC.markVMOffline(this.getDisplayName(), vmL.getVirtualMachineName());
            } else {
                this.taskListener.getLogger().println("\"" + virtualMachineName + "\" not found on Hypervisor, can not shut down!");
                LogRecord rec = new LogRecord(Level.WARNING, "Can not shut down {0} on Hypervisor {1}, domain not found!");
                rec.setParameters(new Object[]{virtualMachineName, hypervisor.getHypervisorURI()});
                logger.log(rec);
            }
        }
        catch (Throwable t) {
            this.taskListener.fatalError(t.getMessage(), new Object[]{t});
            LogRecord rec = new LogRecord(Level.SEVERE, "Error while shutting down {0} on Hypervisor {1}.");
            rec.setParameters(new Object[]{slave.getVirtualMachineName(), hypervisor.getHypervisorURI()});
            rec.setThrown(t);
            logger.log(rec);
        }
        return super.disconnect(cause);
    }
}

