/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import hudson.Plugin;
import hudson.model.Hudson;
import hudson.plugins.libvirt.Hypervisor;
import hudson.plugins.libvirt.VirtualMachine;
import hudson.slaves.Cloud;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginImpl
extends Plugin {
    private static final Logger LOGGER = Logger.getLogger(PluginImpl.class.getName());
    private static PluginImpl instance;

    public PluginImpl() {
        instance = this;
    }

    public static PluginImpl getInstance() {
        return instance;
    }

    public void start() throws Exception {
        LOGGER.log(Level.FINE, "Starting libvirt-slave plugin");
    }

    public void stop() throws Exception {
        LOGGER.log(Level.FINE, "Stopping libvirt-slave plugin.");
    }

    public synchronized Collection<Hypervisor> getServers() {
        Collection clouds = Collections2.filter((Collection)Jenkins.getInstance().clouds, (Predicate)new Predicate<Cloud>(){

            public boolean apply(@Nullable Cloud input) {
                return input instanceof Hypervisor;
            }
        });
        return clouds;
    }

    public Hypervisor getServer(final String host) {
        return (Hypervisor)((Object)Iterables.find(this.getServers(), (Predicate)new Predicate<Hypervisor>(){

            public boolean apply(@Nullable Hypervisor input) {
                return host.equals(input.getHypervisorHost());
            }
        }));
    }

    public FormValidation doCheckStartupWaitingPeriodSeconds(@QueryParameter String secsValue) throws IOException, ServletException {
        try {
            int v = Integer.parseInt(secsValue);
            if (v < 0) {
                return FormValidation.error((String)"Negative value..");
            }
            if (v == 0) {
                return FormValidation.warning((String)"You declared this virtual machine to be ready right away. It probably needs a couple of seconds before it is ready to process jobs!");
            }
            return FormValidation.ok();
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)"Not a number..");
        }
    }

    public FormValidation doCheckStartupTimesToRetryOnFailure(@QueryParameter String retriesValue) throws IOException, ServletException {
        try {
            int v = Integer.parseInt(retriesValue);
            if (v < 0) {
                return FormValidation.error((String)"Negative value.");
            }
            return FormValidation.ok();
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)"Not a number.");
        }
    }

    public void doComputerNameValues(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="value") String value) throws IOException, ServletException {
        ListBoxModel m = new ListBoxModel();
        List<VirtualMachine> virtualMachines = null;
        for (Cloud cloud : Jenkins.getInstance().clouds) {
            if (!(cloud instanceof Hypervisor)) continue;
            Hypervisor hypervisor = (Hypervisor)cloud;
            if (value == null || !value.equals(hypervisor.getHypervisorDescription())) continue;
            virtualMachines = hypervisor.getVirtualMachines();
            break;
        }
        if (virtualMachines != null) {
            for (VirtualMachine vm : virtualMachines) {
                m.add((Object)new ListBoxModel.Option(vm.getName(), vm.getName()));
            }
            if (m.size() > 0) {
                ((ListBoxModel.Option)m.get((int)0)).selected = true;
            }
        }
        m.writeTo(req, rsp);
    }

    public void doSnapshotNameValues(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="vm") String vm, @QueryParameter(value="hypervisor") String hypervisor) throws IOException, ServletException {
        ListBoxModel m = new ListBoxModel();
        m.add((Object)new ListBoxModel.Option("", ""));
        for (Cloud cloud : Hudson.getInstance().clouds) {
            String[] ss;
            if (!(cloud instanceof Hypervisor)) continue;
            Hypervisor hypHandle = (Hypervisor)cloud;
            if (hypervisor == null || !hypervisor.equals(hypHandle.getHypervisorURI())) continue;
            for (String sshot : ss = hypHandle.getSnapshots(vm)) {
                m.add((Object)new ListBoxModel.Option(sshot, sshot));
            }
        }
        m.writeTo(req, rsp);
    }
}

