/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.plugins.ldap;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import jenkins.security.plugins.ldap.LdapEntryMapper;
import jenkins.security.plugins.ldap.SetContextClassLoader;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.security.authentication.AuthenticationServiceException;

@Restricted(value={NoExternalUse.class})
public class LDAPExtendedTemplate
extends LdapTemplate {
    public LDAPExtendedTemplate(ContextSource dirContextFactory) {
        super(dirContextFactory);
    }

    /*
     * Exception decompiling
     */
    @CheckForNull
    public <T> T searchForFirstEntry(@NonNull String base, @NonNull String filter, Object[] filterArgs, String[] attributeNames, @NonNull LdapEntryMapper<T> mapper) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NonNull
    public <T> List<? extends T> searchForAllEntries(@NonNull String base, @NonNull String filter, Object[] filterArgs, String[] attributeNames, @NonNull LdapEntryMapper<T> mapper) {
        ArrayList<T> results = new ArrayList<T>();
        try (SetContextClassLoader sccl = new SetContextClassLoader();
             SearchResultEnumeration<T> searchEnum = this.searchForAllEntriesEnum(base, filter, filterArgs, attributeNames, mapper);){
            while (searchEnum.hasMore()) {
                results.add(searchEnum.next());
            }
        }
        catch (NamingException e) {
            throw new AuthenticationServiceException("Error processing search results", (Throwable)e);
        }
        return results;
    }

    @NonNull
    private <T> SearchResultEnumeration<T> searchForAllEntriesEnum(@NonNull String base, @NonNull String filter, Object[] params, String[] attributeNames, @NonNull LdapEntryMapper<T> mapper) {
        return (SearchResultEnumeration)this.executeReadOnly(ctx -> {
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(attributeNames);
            NamingEnumeration<SearchResult> searchResults = ctx.search(base, filter, params, controls);
            return new SearchResultEnumeration(searchResults, mapper, this.getDnSuffix(base, ctx.getNameInNamespace()));
        });
    }

    private String getDnSuffix(String base, String nameInNamespace) {
        StringBuilder suffix = new StringBuilder();
        if (!StringUtils.isEmpty((String)base)) {
            suffix.append(",").append(base);
        }
        if (!StringUtils.isEmpty((String)nameInNamespace)) {
            suffix.append(",").append(nameInNamespace);
        }
        return suffix.toString();
    }

    private static final class SearchResultEnumeration<T>
    implements AutoCloseable,
    NamingEnumeration<T> {
        private final NamingEnumeration<SearchResult> searchResults;
        private final LdapEntryMapper<T> mapper;
        private final String dnSuffix;

        SearchResultEnumeration(NamingEnumeration<SearchResult> searchResults, LdapEntryMapper<T> mapper, String dnSuffix) {
            this.searchResults = searchResults;
            this.mapper = mapper;
            this.dnSuffix = dnSuffix;
        }

        @Override
        public void close() throws NamingException {
            this.searchResults.close();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.searchResults.hasMore();
        }

        @Override
        public T next() throws NamingException {
            SearchResult searchResult = this.searchResults.next();
            return this.mapper.mapAttributes(searchResult.getName() + this.dnSuffix, searchResult.getAttributes());
        }

        @Override
        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException e) {
                throw new AuthenticationServiceException("Unable to check for more elements", (Throwable)e);
            }
        }

        @Override
        public T nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new AuthenticationServiceException("Unable to get next element", (Throwable)e);
            }
        }
    }
}

