/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Main;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserAttributesHelper;
import hudson.security.UserMayOrMayNotExistException2;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Scrambler;
import hudson.util.Secret;
import hudson.util.VersionNumber;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import jenkins.model.IdStrategy;
import jenkins.model.Jenkins;
import jenkins.security.plugins.ldap.FromGroupSearchLDAPGroupMembershipStrategy;
import jenkins.security.plugins.ldap.LDAPConfiguration;
import jenkins.security.plugins.ldap.LDAPExtendedTemplate;
import jenkins.security.plugins.ldap.LDAPGroupMembershipStrategy;
import jenkins.security.plugins.ldap.LdapEntryMapper;
import jenkins.security.plugins.ldap.Messages;
import jenkins.security.plugins.ldap.SetContextClassLoader;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapUserDetails;
import org.springframework.security.ldap.userdetails.LdapUserDetailsImpl;

public class LDAPSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    private static final boolean FORCE_USERNAME_LOWERCASE = Boolean.getBoolean(LDAPSecurityRealm.class.getName() + ".forceUsernameLowercase");
    private static final boolean FORCE_GROUPNAME_LOWERCASE = Boolean.getBoolean(LDAPSecurityRealm.class.getName() + ".forceGroupnameLowercase");
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public transient String server;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public transient String rootDN;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public transient boolean inhibitInferRootDN;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public transient String userSearchBase;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public transient String userSearch;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public transient String groupSearchBase;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public transient String groupSearchFilter;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public transient String groupMembershipFilter;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public transient LDAPGroupMembershipStrategy groupMembershipStrategy;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public transient String managerDN;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    private transient String managerPassword;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    private transient Secret managerPasswordSecret;
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public final boolean disableMailAddressResolver;
    private List<LDAPConfiguration> configurations;
    private final CacheConfiguration cache;
    private transient Map<String, CacheEntry<DelegatedLdapUserDetails>> userDetailsCache = null;
    private transient Map<String, CacheEntry<GroupDetailsImpl>> groupDetailsCache = null;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    private transient Map<String, String> extraEnvVars;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    private transient String displayNameAttributeName;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    private transient String mailAddressAttributeName;
    private final IdStrategy userIdStrategy;
    private final IdStrategy groupIdStrategy;
    private boolean disableRolePrefixing;
    @Restricted(value={NoExternalUse.class})
    public static final Logger LOGGER = Logger.getLogger(LDAPSecurityRealm.class.getName());
    public static final String GROUP_SEARCH = System.getProperty(LDAPSecurityRealm.class.getName() + ".groupSearch", "(& (cn={0}) (| (objectclass=groupOfNames) (objectclass=groupOfUniqueNames) (objectclass=posixGroup)))");

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String managerDN, String managerPassword, boolean inhibitInferRootDN) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, managerDN, managerPassword, inhibitInferRootDN, false);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, managerDN, managerPassword, inhibitInferRootDN, disableMailAddressResolver, null);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, null, null, managerDN, managerPassword, inhibitInferRootDN, disableMailAddressResolver, cache);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, String groupMembershipFilter, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, groupMembershipFilter, managerDN, managerPassword, inhibitInferRootDN, disableMailAddressResolver, cache, null);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, String groupMembershipFilter, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache, EnvironmentProperty[] environmentProperties) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, groupMembershipFilter, managerDN, managerPassword, inhibitInferRootDN, disableMailAddressResolver, cache, environmentProperties, null, null);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, String groupMembershipFilter, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache, EnvironmentProperty[] environmentProperties, String displayNameAttributeName, String mailAddressAttributeName) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, groupMembershipFilter, managerDN, Secret.fromString((String)managerPassword), inhibitInferRootDN, disableMailAddressResolver, cache, environmentProperties, null, null);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, String groupMembershipFilter, String managerDN, Secret managerPasswordSecret, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache, EnvironmentProperty[] environmentProperties, String displayNameAttributeName, String mailAddressAttributeName) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, new FromGroupSearchLDAPGroupMembershipStrategy(groupMembershipFilter), managerDN, managerPasswordSecret, inhibitInferRootDN, disableMailAddressResolver, cache, environmentProperties, displayNameAttributeName, mailAddressAttributeName);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, LDAPGroupMembershipStrategy groupMembershipStrategy, String managerDN, Secret managerPasswordSecret, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache, EnvironmentProperty[] environmentProperties, String displayNameAttributeName, String mailAddressAttributeName) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, groupMembershipStrategy, managerDN, managerPasswordSecret, inhibitInferRootDN, disableMailAddressResolver, cache, environmentProperties, displayNameAttributeName, mailAddressAttributeName, IdStrategy.CASE_INSENSITIVE, IdStrategy.CASE_INSENSITIVE);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, LDAPGroupMembershipStrategy groupMembershipStrategy, String managerDN, Secret managerPasswordSecret, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache, EnvironmentProperty[] environmentProperties, String displayNameAttributeName, String mailAddressAttributeName, IdStrategy userIdStrategy, IdStrategy groupIdStrategy) {
        this(LDAPSecurityRealm.createLdapConfiguration(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, groupMembershipStrategy, managerDN, managerPasswordSecret, inhibitInferRootDN, environmentProperties, displayNameAttributeName, mailAddressAttributeName), disableMailAddressResolver, cache, userIdStrategy, groupIdStrategy);
    }

    @DataBoundConstructor
    public LDAPSecurityRealm(List<LDAPConfiguration> configurations, boolean disableMailAddressResolver, CacheConfiguration cache, IdStrategy userIdStrategy, IdStrategy groupIdStrategy) {
        if (configurations == null || configurations.isEmpty()) {
            throw new IllegalArgumentException(Messages.LDAPSecurityRealm_AtLeastOne());
        }
        if (!(configurations.size() <= 1 || Main.isUnitTest && Boolean.getBoolean(LDAPSecurityRealm.class.getName() + "do a bad thing during testing"))) {
            for (int i = 0; i < configurations.size(); ++i) {
                LDAPConfiguration ci = configurations.get(i);
                for (int k = i + 1; k < configurations.size(); ++k) {
                    LDAPConfiguration ck = configurations.get(k);
                    if (!ci.isConfiguration(ck.getId())) continue;
                    throw new IllegalArgumentException(Messages.LDAPSecurityRealm_NotSameServer());
                }
            }
        }
        this.configurations = configurations;
        this.disableMailAddressResolver = disableMailAddressResolver;
        this.cache = cache;
        this.userIdStrategy = userIdStrategy;
        this.groupIdStrategy = groupIdStrategy;
    }

    private static List<LDAPConfiguration> createLdapConfiguration(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, LDAPGroupMembershipStrategy groupMembershipStrategy, String managerDN, Secret managerPasswordSecret, boolean inhibitInferRootDN, EnvironmentProperty[] environmentProperties, String displayNameAttributeName, String mailAddressAttributeName) {
        LDAPConfiguration conf = new LDAPConfiguration(server, rootDN, inhibitInferRootDN, managerDN, managerPasswordSecret);
        conf.setUserSearchBase(userSearchBase);
        conf.setUserSearch(userSearch);
        conf.setGroupSearchBase(groupSearchBase);
        conf.setGroupSearchFilter(groupSearchFilter);
        conf.setGroupMembershipStrategy(groupMembershipStrategy);
        conf.setEnvironmentProperties(environmentProperties);
        conf.setDisplayNameAttributeName(displayNameAttributeName);
        conf.setMailAddressAttributeName(mailAddressAttributeName);
        return Collections.singletonList(conf);
    }

    public List<LDAPConfiguration> getConfigurations() {
        return this.configurations;
    }

    private boolean hasConfiguration() {
        return this.configurations != null && !this.configurations.isEmpty();
    }

    public boolean isDisableRolePrefixing() {
        return this.disableRolePrefixing;
    }

    @DataBoundSetter
    public void setDisableRolePrefixing(boolean disableRolePrefixing) {
        this.disableRolePrefixing = disableRolePrefixing;
    }

    private Object readResolve() {
        if (this.managerPassword != null) {
            this.managerPasswordSecret = Secret.fromString((String)Scrambler.descramble((String)this.managerPassword));
            this.managerPassword = null;
        }
        if (this.server != null) {
            LDAPConfiguration conf = new LDAPConfiguration(this.server, this.rootDN, this.inhibitInferRootDN, this.managerDN, this.managerPasswordSecret);
            this.server = null;
            this.rootDN = null;
            this.managerDN = null;
            this.managerPasswordSecret = null;
            conf.setMailAddressAttributeName(this.mailAddressAttributeName);
            this.mailAddressAttributeName = null;
            conf.setDisplayNameAttributeName(this.displayNameAttributeName);
            this.displayNameAttributeName = null;
            conf.setExtraEnvVars(this.extraEnvVars);
            this.extraEnvVars = null;
            if (this.groupMembershipStrategy == null) {
                conf.setGroupMembershipStrategy(new FromGroupSearchLDAPGroupMembershipStrategy(this.groupMembershipFilter));
                this.groupMembershipFilter = null;
            } else {
                conf.setGroupMembershipStrategy(this.groupMembershipStrategy);
                this.groupMembershipStrategy = null;
            }
            conf.setGroupSearchBase(this.groupSearchBase);
            this.groupSearchBase = null;
            conf.setGroupSearchFilter(this.groupSearchFilter);
            this.groupSearchFilter = null;
            conf.setUserSearch(this.userSearch);
            this.userSearch = null;
            conf.setUserSearchBase(this.userSearchBase);
            this.userSearchBase = null;
            this.configurations = new ArrayList<LDAPConfiguration>();
            this.configurations.add(conf);
        }
        return this;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public String getServerUrl() {
        return this.hasConfiguration() ? this.configurations.get(0).getServerUrl() : null;
    }

    public IdStrategy getUserIdStrategy() {
        return this.userIdStrategy == null ? IdStrategy.CASE_INSENSITIVE : this.userIdStrategy;
    }

    public IdStrategy getGroupIdStrategy() {
        return this.groupIdStrategy == null ? IdStrategy.CASE_INSENSITIVE : this.groupIdStrategy;
    }

    public CacheConfiguration getCache() {
        return this.cache;
    }

    public Integer getCacheSize() {
        return this.cache == null ? null : Integer.valueOf(this.cache.getSize());
    }

    public Integer getCacheTTL() {
        return this.cache == null ? null : Integer.valueOf(this.cache.getTtl());
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public String getGroupMembershipFilter() {
        return this.hasConfiguration() ? this.configurations.get(0).getGroupSearchFilter() : null;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public LDAPGroupMembershipStrategy getGroupMembershipStrategy() {
        return this.hasConfiguration() ? this.configurations.get(0).getGroupMembershipStrategy() : null;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public String getGroupSearchFilter() {
        return this.hasConfiguration() ? this.configurations.get(0).getGroupSearchFilter() : null;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public Map<String, String> getExtraEnvVars() {
        return this.hasConfiguration() ? this.configurations.get(0).getExtraEnvVars() : Collections.emptyMap();
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public EnvironmentProperty[] getEnvironmentProperties() {
        return this.hasConfiguration() ? this.configurations.get(0).getEnvironmentProperties() : new EnvironmentProperty[]{};
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public String getManagerPassword() {
        return this.hasConfiguration() ? this.configurations.get(0).getManagerPassword() : null;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public Secret getManagerPasswordSecret() {
        return this.hasConfiguration() ? this.configurations.get(0).getManagerPasswordSecret() : null;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public String getLDAPURL() {
        return this.hasConfiguration() ? this.configurations.get(0).getLDAPURL() : null;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public String getDisplayNameAttributeName() {
        return this.hasConfiguration() ? this.configurations.get(0).getDisplayNameAttributeName() : "displayname";
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public String getMailAddressAttributeName() {
        return this.hasConfiguration() ? this.configurations.get(0).getMailAddressAttributeName() : "mail";
    }

    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    public LDAPConfiguration getConfigurationFor(LdapUserDetails d) {
        if (d instanceof DelegatedLdapUserDetails) {
            return this.getConfigurationFor(((DelegatedLdapUserDetails)d).getConfigurationId());
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean hasMultiConfiguration() {
        return this.hasConfiguration() && this.configurations.size() > 1;
    }

    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    public LDAPConfiguration getConfigurationFor(String configurationId) {
        if (this.configurations != null) {
            for (LDAPConfiguration configuration : this.configurations) {
                if (!configuration.isConfiguration(configurationId)) continue;
                return configuration;
            }
        }
        LOGGER.log(Level.FINE, "Unable to find configuration for {0}", configurationId);
        return null;
    }

    @CheckForNull
    private static LDAPConfiguration _getConfigurationFor(String configurationId) {
        SecurityRealm securityRealm = Jenkins.getActiveInstance().getSecurityRealm();
        if (securityRealm instanceof LDAPSecurityRealm) {
            return ((LDAPSecurityRealm)securityRealm).getConfigurationFor(configurationId);
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public static String toProviderUrl(String serverUrl, String rootDN) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String s : serverUrl.split("\\s+")) {
            if (s.trim().length() == 0 || (s = LDAPSecurityRealm.getProviderUrl(s, rootDN)) == null) continue;
            if (first) {
                first = false;
            } else {
                buf.append(' ');
            }
            buf.append(s);
        }
        return buf.toString();
    }

    private static String getProviderUrl(String server, String rootDN) {
        if (!(server = LDAPSecurityRealm.addPrefix(server)).endsWith("/")) {
            server = server + '/';
        }
        if (rootDN != null && !(rootDN = rootDN.trim()).isEmpty()) {
            try {
                server = server + new URI(null, null, rootDN, null).toASCIIString();
            }
            catch (URISyntaxException e) {
                LOGGER.log(Level.WARNING, "Unable to build URL with rootDN: " + server, e);
                return null;
            }
        }
        return server;
    }

    @Nonnull
    public SecurityRealm.SecurityComponents createSecurityComponents() {
        DelegateLDAPUserDetailsService details = new DelegateLDAPUserDetailsService();
        LDAPAuthenticationManager manager = new LDAPAuthenticationManager(details);
        for (LDAPConfiguration conf : this.configurations) {
            LDAPConfiguration.ApplicationContext appContext = conf.createApplicationContext(this);
            manager.addDelegate(appContext.authenticationManager, conf.getId(), appContext.ldapUserSearch);
            details.addDelegate(new LDAPUserDetailsService(appContext.ldapUserSearch, appContext.ldapAuthoritiesPopulator, conf.getGroupMembershipStrategy(), conf.getId()));
        }
        return new SecurityRealm.SecurityComponents((AuthenticationManager)manager, (UserDetailsService)details);
    }

    protected UserDetails authenticate2(String username, String password) throws AuthenticationException {
        return this.updateUserDetails((UserDetails)this.getSecurityComponents().manager2.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)LDAPSecurityRealm.fixUsername(username), (Object)password)).getPrincipal(), null);
    }

    public UserDetails loadUserByUsername2(String username) throws UsernameNotFoundException {
        return this.updateUserDetails(this.getSecurityComponents().userDetails2.loadUserByUsername(LDAPSecurityRealm.fixUsername(username)), null);
    }

    public Authentication updateUserDetails(Authentication authentication, @CheckForNull LdapUserSearch ldapUserSearch) {
        UserDetails userDetails = this.updateUserDetails((UserDetails)authentication.getPrincipal(), ldapUserSearch);
        return new DelegatedLdapAuthentication(authentication, userDetails, authentication instanceof DelegatedLdapAuthentication ? ((DelegatedLdapAuthentication)authentication).getConfigurationId() : null);
    }

    public UserDetails updateUserDetails(UserDetails userDetails, @CheckForNull LdapUserSearch ldapUserSearch) {
        if (userDetails instanceof LdapUserDetails) {
            return this.updateUserDetails((LdapUserDetails)userDetails, ldapUserSearch);
        }
        return userDetails;
    }

    public DelegatedLdapUserDetails updateUserDetails(LdapUserDetails d, @CheckForNull LdapUserSearch ldapUserSearch) {
        Attribute attribute;
        String mailAddressAttributeName;
        String displayNameAttributeName;
        User u = User.get((String)LDAPSecurityRealm.fixUsername(d.getUsername()));
        LDAPConfiguration configuration = this.getConfigurationFor(d);
        if (configuration != null) {
            displayNameAttributeName = configuration.getDisplayNameAttributeName();
            mailAddressAttributeName = configuration.getMailAddressAttributeName();
            if (StringUtils.isEmpty((String)displayNameAttributeName)) {
                displayNameAttributeName = "displayname";
            }
            if (StringUtils.isEmpty((String)mailAddressAttributeName)) {
                mailAddressAttributeName = "mail";
            }
        } else {
            displayNameAttributeName = "displayname";
            mailAddressAttributeName = "mail";
        }
        Attributes attributes = DelegatedLdapUserDetails.getAttributes(d, ldapUserSearch);
        try {
            String displayName;
            attribute = attributes.get(displayNameAttributeName);
            String string = displayName = attribute == null ? null : (String)attribute.get();
            if (StringUtils.isNotBlank((String)displayName) && u.getId().equals(u.getFullName()) && !u.getFullName().equals(displayName)) {
                u.setFullName(displayName);
            }
        }
        catch (NamingException e) {
            LOGGER.log(Level.FINEST, "Could not retrieve display name attribute", e);
        }
        if (!this.disableMailAddressResolver) {
            try {
                Mailer.UserProperty existing;
                String mailAddress;
                attribute = attributes.get(mailAddressAttributeName);
                String string = mailAddress = attribute == null ? null : (String)attribute.get();
                if (StringUtils.isNotBlank((String)mailAddress) && ((existing = (Mailer.UserProperty)u.getProperty(Mailer.UserProperty.class)) == null || !existing.hasExplicitlyConfiguredAddress())) {
                    u.addProperty((UserProperty)new Mailer.UserProperty(mailAddress));
                }
            }
            catch (NamingException e) {
                LOGGER.log(Level.FINEST, "Could not retrieve email address attribute", e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to associate the e-mail address", e);
            }
        }
        return new DelegatedLdapUserDetails(d, d instanceof DelegatedLdapUserDetails ? ((DelegatedLdapUserDetails)d).configurationId : "???", attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupDetails loadGroupByGroupname2(String groupname, boolean fetchMembers) throws UsernameNotFoundException {
        GroupDetailsImpl group;
        GroupDetailsImpl cachedGroup;
        LDAPSecurityRealm lDAPSecurityRealm;
        groupname = LDAPSecurityRealm.fixGroupname(groupname);
        if (this.cache != null) {
            CacheEntry<GroupDetailsImpl> cached;
            lDAPSecurityRealm = this;
            synchronized (lDAPSecurityRealm) {
                cached = this.groupDetailsCache != null ? this.groupDetailsCache.get(groupname) : null;
            }
            if (cached != null && cached.isValid()) {
                GroupDetailsImpl cachedValue = cached.getValue();
                cachedGroup = !fetchMembers || cachedValue.getMembers() != null ? cachedValue : null;
            } else {
                cachedGroup = null;
            }
        } else {
            cachedGroup = null;
        }
        GroupDetailsImpl groupDetailsImpl = group = cachedGroup != null ? cachedGroup : this.searchForGroupName(groupname, fetchMembers);
        if (this.cache != null && cachedGroup == null) {
            lDAPSecurityRealm = this;
            synchronized (lDAPSecurityRealm) {
                if (this.groupDetailsCache == null) {
                    this.groupDetailsCache = new CacheMap<String, GroupDetailsImpl>(this.cache.getSize());
                }
                this.groupDetailsCache.put(groupname, new CacheEntry<GroupDetailsImpl>(this.cache.getTtl(), group));
            }
        }
        return group;
    }

    @Nonnull
    private GroupDetailsImpl searchForGroupName(String groupname, boolean fetchMembers) throws UsernameNotFoundException {
        for (LDAPConfiguration conf : this.configurations) {
            try {
                String searchBase = conf.getGroupSearchBase() != null ? conf.getGroupSearchBase() : "";
                String searchFilter = conf.getGroupSearchFilter() != null ? conf.getGroupSearchFilter() : GROUP_SEARCH;
                LDAPExtendedTemplate template = conf.getLdapTemplate();
                GroupDetailsImpl groupDetails = template.searchForFirstEntry(searchBase, searchFilter, new Object[]{groupname}, null, new GroupDetailsMapper());
                if (groupDetails == null) continue;
                if (fetchMembers) {
                    Set<String> members = conf.getGroupMembershipStrategy().getGroupMembers(groupDetails.getDn(), conf);
                    groupDetails = new GroupDetailsImpl(groupDetails.getDn(), groupDetails.getName(), members);
                }
                return groupDetails;
            }
            catch (AuthenticationException e) {
                LDAPSecurityRealm.throwUnlessConfigIsIgnorable(e, conf);
            }
            catch (RuntimeException e) {
                LDAPSecurityRealm.throwUnlessConfigIsIgnorable(new UserMayOrMayNotExistException2("Failed to search LDAP for group: " + groupname, (Throwable)e), conf);
            }
        }
        throw new UsernameNotFoundException(groupname);
    }

    private static String fixGroupname(String groupname) {
        return FORCE_GROUPNAME_LOWERCASE ? groupname.toLowerCase() : groupname;
    }

    private static String fixUsername(String username) {
        return FORCE_USERNAME_LOWERCASE ? username.toLowerCase() : username;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private static <T extends Exception> void throwUnlessConfigIsIgnorable(T e, @CheckForNull LDAPConfiguration config) throws T {
        boolean shouldThrow = config == null || !config.isIgnoreIfUnavailable();
        LOGGER.log(Level.WARNING, String.format("Failed communication with ldap server %s (%s), will %s the next configuration", config == null ? "null" : config.getId(), config == null ? "null" : config.getServer(), shouldThrow ? "_not_ try" : "try"), e);
        if (shouldThrow) {
            throw e;
        }
    }

    private static String addPrefix(String server) {
        if (server.contains("://")) {
            return server;
        }
        return "ldap://" + server;
    }

    public static class EnvironmentProperty
    extends AbstractDescribableImpl<EnvironmentProperty>
    implements Serializable {
        private final String name;
        private final String value;

        @DataBoundConstructor
        public EnvironmentProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public static Map<String, String> toMap(List<EnvironmentProperty> properties) {
            if (properties != null) {
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                for (EnvironmentProperty property : properties) {
                    result.put(property.getName(), property.getValue());
                }
                return result;
            }
            return null;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<EnvironmentProperty> {
            public String getDisplayName() {
                return "";
            }
        }
    }

    private static class CacheMap<K, V>
    extends LinkedHashMap<K, CacheEntry<V>> {
        private final int cacheSize;

        public CacheMap(int cacheSize) {
            super(cacheSize + 1);
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, CacheEntry<V>> eldest) {
            return this.size() > this.cacheSize || eldest.getValue() == null || !eldest.getValue().isValid();
        }
    }

    private static class CacheEntry<T> {
        private final long expires;
        private final T value;

        public CacheEntry(int ttlSeconds, T value) {
            this.expires = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(ttlSeconds);
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isValid() {
            return System.currentTimeMillis() < this.expires;
        }
    }

    public static class CacheConfiguration
    extends AbstractDescribableImpl<CacheConfiguration> {
        private final int size;
        private final int ttl;

        @DataBoundConstructor
        public CacheConfiguration(int size, int ttl) {
            this.size = Math.max(10, Math.min(size, 1000));
            this.ttl = Math.max(30, Math.min(ttl, 3600));
        }

        public int getSize() {
            return this.size;
        }

        public int getTtl() {
            return this.ttl;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<CacheConfiguration> {
            public String getDisplayName() {
                return "";
            }

            public ListBoxModel doFillSizeItems() {
                ListBoxModel m = new ListBoxModel();
                m.add("10");
                m.add("20");
                m.add("50");
                m.add("100");
                m.add("200");
                m.add("500");
                m.add("1000");
                return m;
            }

            public ListBoxModel doFillTtlItems() {
                ListBoxModel m = new ListBoxModel();
                for (int ttl : new int[]{30, 60, 120, 300, 600, 900, 1800, 3600}) {
                    m.add(Util.getTimeSpanString((long)((long)ttl * 1000L)), Integer.toString(ttl));
                }
                return m;
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public static final String DEFAULT_DISPLAYNAME_ATTRIBUTE_NAME = "displayname";
        public static final String DEFAULT_MAILADDRESS_ATTRIBUTE_NAME = "mail";
        public static final String DEFAULT_USER_SEARCH = "uid={0}";

        public String getDisplayName() {
            return Messages.LDAPSecurityRealm_DisplayName();
        }

        public IdStrategy getDefaultIdStrategy() {
            return IdStrategy.CASE_INSENSITIVE;
        }

        public SecurityRealm newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (!formData.has("configurations")) {
                throw new Descriptor.FormException(Messages.LDAPSecurityRealm_AtLeastOne(), "configurations");
            }
            Object configurations = formData.get("configurations");
            if (configurations instanceof JSONArray) {
                if (((JSONArray)configurations).isEmpty()) {
                    throw new Descriptor.FormException(Messages.LDAPSecurityRealm_AtLeastOne(), "configurations");
                }
                if (((JSONArray)configurations).size() > 1) {
                    List confs = req.bindJSONToList(LDAPConfiguration.class, configurations);
                    for (int i = 0; i < confs.size(); ++i) {
                        LDAPConfiguration ci = (LDAPConfiguration)((Object)confs.get(i));
                        for (int k = i + 1; k < confs.size(); ++k) {
                            LDAPConfiguration ck = (LDAPConfiguration)((Object)confs.get(k));
                            if (!ci.isConfiguration(ck.getId())) continue;
                            throw new Descriptor.FormException(Messages.LDAPSecurityRealm_NotSameServer(), "configurations");
                        }
                    }
                }
            } else {
                if (!(configurations instanceof JSONObject)) {
                    throw new Descriptor.FormException(Messages.LDAPSecurityRealm_AtLeastOne(), "configurations");
                }
                if (((JSONObject)configurations).isNullObject()) {
                    throw new Descriptor.FormException(Messages.LDAPSecurityRealm_AtLeastOne(), "configurations");
                }
            }
            return (SecurityRealm)super.newInstance(req, formData);
        }

        @Restricted(value={NoExternalUse.class})
        public boolean hasEnableSecurityForm() {
            VersionNumber currentVersion = Jenkins.getVersion();
            return currentVersion != null && currentVersion.isOlderThan(new VersionNumber("2.214"));
        }

        @RequirePOST
        public FormValidation doValidate(StaplerRequest req) throws Exception {
            if (!Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            JSONObject json = JSONObject.fromObject((Object)IOUtils.toString((InputStream)req.getInputStream()));
            String user = json.getString("testUser");
            String password = json.getString("testPassword");
            JSONObject realmCfg = this.hasEnableSecurityForm() ? json.getJSONObject("useSecurity").getJSONObject("realm") : json.getJSONObject("realm");
            LDAPSecurityRealm realm = (LDAPSecurityRealm)((Object)req.bindJSON(LDAPSecurityRealm.class, realmCfg));
            return this.validate(realm, user, password);
        }

        private void rsp(StringBuilder response, String kind, String testId, String message, Object ... extras) {
            response.append("<div class='").append(kind).append("' data-test='");
            response.append(Util.escape((String)testId));
            response.append("'>");
            response.append(message);
            boolean needBr = true;
            for (Object extra : extras) {
                if (extra instanceof String) {
                    if (needBr) {
                        response.append("<br/>");
                    }
                    response.append(extra);
                    needBr = true;
                    continue;
                }
                if (!(extra instanceof Collection)) continue;
                response.append("<ul>");
                for (String item : (Collection)extra) {
                    response.append("<li>");
                    response.append(item);
                    response.append("</li>");
                }
                response.append("</ul>");
                needBr = false;
            }
            response.append("</div>");
        }

        private void ok(StringBuilder response, String testId, String message, Object ... extras) {
            this.rsp(response, "validation-ok", testId, message, extras);
        }

        private void warning(StringBuilder response, String testId, String message, Object ... extras) {
            this.rsp(response, "warning", testId, message, extras);
        }

        private void error(StringBuilder response, String testId, String message, Object ... extras) {
            this.rsp(response, "error", testId, message, extras);
        }

        public FormValidation validate(LDAPSecurityRealm realm, String user, String password) {
            LDAPConfiguration.LDAPConfigurationDescriptor confDescriptor = (LDAPConfiguration.LDAPConfigurationDescriptor)Jenkins.getActiveInstance().getDescriptorByType(LDAPConfiguration.LDAPConfigurationDescriptor.class);
            for (LDAPConfiguration configuration : realm.getConfigurations()) {
                FormValidation connectionCheck = confDescriptor.doCheckServer(configuration.getServerUrl(), configuration.getManagerDN(), configuration.getManagerPasswordSecret());
                if (connectionCheck.kind == FormValidation.Kind.OK) continue;
                return connectionCheck;
            }
            StringBuilder response = new StringBuilder(1024);
            response.append("<div>").append(Messages.LDAPSecurityRealm_LoginHeader()).append("</div>");
            boolean potentialLockout = false;
            boolean likelyLockout = false;
            LdapUserDetails loginDetails = null;
            try {
                loginDetails = (LdapUserDetails)realm.getSecurityComponents().manager2.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)LDAPSecurityRealm.fixUsername(user), (Object)password)).getPrincipal();
                this.ok(response, "authentication", Messages.LDAPSecurityRealm_AuthenticationSuccessful(), new Object[0]);
            }
            catch (AuthenticationException e) {
                if (StringUtils.isBlank((String)password)) {
                    this.warning(response, "authentication", Messages.LDAPSecurityRealm_AuthenticationFailedEmptyPass(user), new Object[0]);
                }
                this.error(response, "authentication", Messages.LDAPSecurityRealm_AuthenticationFailed(user), new Object[0]);
                potentialLockout = true;
                likelyLockout = true;
            }
            HashSet<String> loginAuthorities = new HashSet<String>();
            if (loginDetails != null) {
                this.ok(response, "authentication-username", Messages.LDAPSecurityRealm_UserId(Util.escape((String)loginDetails.getUsername())), new Object[0]);
                this.ok(response, "authentication-dn", Messages.LDAPSecurityRealm_UserDn(Util.escape((String)loginDetails.getDn())), new Object[0]);
                LDAPConfiguration loginConfiguration = realm.getConfigurationFor(loginDetails);
                assert (loginConfiguration != null);
                if (realm.hasMultiConfiguration()) {
                    this.ok(response, "authentication-configuration", Messages.LDAPSecurityRealm_UserConfiguration(Util.escape((String)loginConfiguration.getServer())), new Object[0]);
                }
                this.validateDisplayName(loginConfiguration, response, loginDetails, "authentication-displayname");
                if (!realm.disableMailAddressResolver) {
                    this.validateEmailAddress(loginConfiguration, response, loginDetails, "authentication-email");
                }
                for (Object a : loginDetails.getAuthorities()) {
                    loginAuthorities.add(a.getAuthority());
                }
                if (loginDetails.getAuthorities().size() < 1) {
                    this.error(response, "authentication-groups", Messages.LDAPSecurityRealm_NoGroupMembership(), new Object[0]);
                } else if (loginDetails.getAuthorities().size() == 1) {
                    this.warning(response, "authentication-groups", Messages.LDAPSecurityRealm_BasicGroupMembership(), Messages.LDAPSecurityRealm_BasicGroupMembershipDetail());
                } else {
                    ArrayList<String> authorities = new ArrayList<String>();
                    for (Object a : loginDetails.getAuthorities()) {
                        if (SecurityRealm.AUTHENTICATED_AUTHORITY2.equals(a)) continue;
                        authorities.add("<code>" + Util.escape((String)a.getAuthority()) + "</code>");
                    }
                    this.ok(response, "authentication-groups", Messages.LDAPSecurityRealm_GroupMembership(), authorities);
                }
            }
            response.append("<div>").append(Messages.LDAPSecurityRealm_LookupHeader()).append("</div>");
            LdapUserDetails lookUpDetails = null;
            try {
                lookUpDetails = (LdapUserDetails)realm.getSecurityComponents().userDetails2.loadUserByUsername(LDAPSecurityRealm.fixUsername(user));
                this.ok(response, "lookup", Messages.LDAPSecurityRealm_UserLookupSuccessful(), new Object[0]);
            }
            catch (UserMayOrMayNotExistException2 e1) {
                this.rsp(response, loginDetails == null ? "warning" : "error", "lookup", Messages.LDAPSecurityRealm_UserLookupInconclusive(user), this.isAnyManagerBlank(realm) ? Messages.LDAPSecurityRealm_UserLookupManagerDnRequired() : Messages.LDAPSecurityRealm_UserLookupManagerDnPermissions());
            }
            catch (UsernameNotFoundException e1) {
                this.rsp(response, loginDetails == null ? "warning" : "error", "lookup", Messages.LDAPSecurityRealm_UserLookupDoesNotExist(user), this.isAnyManagerBlank(realm) ? Messages.LDAPSecurityRealm_UserLookupManagerDnRequired() : Messages.LDAPSecurityRealm_UserLookupManagerDnPermissions(), Messages.LDAPSecurityRealm_UserLookupSettingsCorrect());
            }
            catch (AuthenticationException e) {
                Object cause;
                for (cause = e.getCause(); cause != null && !(cause instanceof BadCredentialsException); cause = ((Throwable)cause).getCause()) {
                }
                if (cause != null) {
                    this.error(response, "lookup", Messages.LDAPSecurityRealm_UserLookupBadCredentials(), this.isAnyManagerBlank(realm) ? Messages.LDAPSecurityRealm_UserLookupManagerDnCorrect() : Messages.LDAPSecurityRealm_UserLookupManagerDnPermissions());
                    potentialLockout = true;
                }
                this.error(response, "lookup", Messages.LDAPSecurityRealm_UserLookupFailed(user), Util.escape((String)e.getLocalizedMessage()));
                potentialLockout = true;
            }
            if (loginDetails == null && lookUpDetails != null) {
                this.ok(response, "lookup-username", Messages.LDAPSecurityRealm_UserId(Util.escape((String)lookUpDetails.getUsername())), new Object[0]);
                this.ok(response, "lookup-dn", Messages.LDAPSecurityRealm_UserDn(Util.escape((String)lookUpDetails.getDn())), new Object[0]);
                LDAPConfiguration lookupConfiguration = realm.getConfigurationFor(lookUpDetails);
                assert (lookupConfiguration != null);
                if (realm.hasMultiConfiguration()) {
                    this.ok(response, "lookup-configuration", Messages.LDAPSecurityRealm_UserConfiguration(Util.escape((String)lookupConfiguration.getServer())), new Object[0]);
                }
                this.validateDisplayName(lookupConfiguration, response, lookUpDetails, "lookup-displayname");
                if (!realm.disableMailAddressResolver) {
                    this.validateEmailAddress(lookupConfiguration, response, lookUpDetails, "lookup-email");
                }
            }
            HashSet<String> lookupAuthorities = new HashSet<String>();
            if (lookUpDetails != null) {
                for (Object a : lookUpDetails.getAuthorities()) {
                    lookupAuthorities.add(a.getAuthority());
                }
                if (loginDetails == null || !loginAuthorities.equals(lookupAuthorities)) {
                    if (lookUpDetails.getAuthorities().size() < 1) {
                        this.error(response, "lookup-groups", Messages.LDAPSecurityRealm_NoGroupMembership(), new Object[0]);
                    } else if (lookUpDetails.getAuthorities().size() == 1) {
                        this.warning(response, "lookup-groups", Messages.LDAPSecurityRealm_BasicGroupMembership(), Messages.LDAPSecurityRealm_BasicGroupMembershipDetail());
                    } else {
                        ArrayList<String> authorities = new ArrayList<String>();
                        for (GrantedAuthority a : lookUpDetails.getAuthorities()) {
                            if (SecurityRealm.AUTHENTICATED_AUTHORITY2.equals(a)) continue;
                            authorities.add("<code>" + Util.escape((String)a.getAuthority()) + "</code>");
                        }
                        this.ok(response, "lookup-groups", Messages.LDAPSecurityRealm_GroupMembership(), authorities);
                    }
                }
            }
            if (loginDetails != null && lookUpDetails != null) {
                Class<?> lookUpValue;
                Attribute lookUpAttr;
                Class<?> loginValue;
                Attribute loginAttr;
                LDAPConfiguration loginConfiguration = realm.getConfigurationFor(loginDetails);
                LDAPConfiguration lookupConfiguration = realm.getConfigurationFor(lookUpDetails);
                assert (loginConfiguration == lookupConfiguration) : "The lookup user details and login user details are not from the same server configuration";
                if (!StringUtils.equals((String)loginDetails.getUsername(), (String)lookUpDetails.getUsername())) {
                    this.error(response, "consistency-username", Messages.LDAPSecurityRealm_UsernameMismatch(loginDetails.getUsername(), lookUpDetails.getUsername()), new Object[0]);
                    potentialLockout = true;
                }
                try {
                    LdapName loginDN = new LdapName(loginDetails.getDn());
                    LdapName lookupDN = new LdapName(lookUpDetails.getDn());
                    if (!loginDN.equals(lookupDN)) {
                        this.error(response, "consistency-dn", Messages.LDAPSecurityRealm_DnMismatch(loginDN, loginDN), new Object[0]);
                        potentialLockout = true;
                    }
                }
                catch (InvalidNameException inEx) {
                    this.error(response, "consistency-dn-parse", Messages.LDAPSecurityRealm_DnParse(inEx.getMessage()), new Object[0]);
                    potentialLockout = true;
                }
                Attributes loginAttributes = DelegatedLdapUserDetails.getAttributes(loginDetails, null);
                Attributes lookupAttributes = DelegatedLdapUserDetails.getAttributes(lookUpDetails, null);
                if (StringUtils.isNotBlank((String)loginConfiguration.getDisplayNameAttributeName())) {
                    loginAttr = loginAttributes.get(loginConfiguration.getDisplayNameAttributeName());
                    try {
                        loginValue = loginAttr == null ? null : loginAttr.get();
                    }
                    catch (NamingException e) {
                        loginValue = e.getClass();
                    }
                    lookUpAttr = lookupAttributes.get(lookupConfiguration.getDisplayNameAttributeName());
                    try {
                        lookUpValue = lookUpAttr == null ? null : lookUpAttr.get();
                    }
                    catch (NamingException e) {
                        lookUpValue = e.getClass();
                    }
                    if (loginValue == null ? lookUpValue != null : !loginValue.equals(lookUpValue)) {
                        this.error(response, "consistency-displayname", Messages.LDAPSecurityRealm_DisplayNameMismatch(loginValue, lookUpValue), new Object[0]);
                        potentialLockout = true;
                    }
                }
                if (!realm.disableMailAddressResolver && StringUtils.isNotBlank((String)loginConfiguration.getMailAddressAttributeName())) {
                    loginAttr = loginAttributes.get(loginConfiguration.getMailAddressAttributeName());
                    try {
                        loginValue = loginAttr == null ? null : loginAttr.get();
                    }
                    catch (NamingException e) {
                        loginValue = e.getClass();
                    }
                    lookUpAttr = lookupAttributes.get(lookupConfiguration.getMailAddressAttributeName());
                    try {
                        lookUpValue = lookUpAttr == null ? null : lookUpAttr.get();
                    }
                    catch (NamingException e) {
                        lookUpValue = e.getClass();
                    }
                    if (loginValue == null ? lookUpValue != null : !loginValue.equals(lookUpValue)) {
                        this.error(response, "consistency-email", Messages.LDAPSecurityRealm_EmailAddressMismatch(loginValue, lookUpValue), new Object[0]);
                        potentialLockout = true;
                    }
                }
                if (loginAuthorities.equals(lookupAuthorities)) {
                    this.ok(response, "consistency", Messages.LDAPSecurityRealm_GroupMembershipMatch(), new Object[0]);
                } else {
                    this.error(response, "consistency", Messages.LDAPSecurityRealm_GroupMembershipMismatch(), new Object[0]);
                    potentialLockout = true;
                }
            }
            HashSet<String> groups = new HashSet<String>(loginAuthorities);
            TreeSet<String> badGroups = new TreeSet<String>();
            groups.addAll(lookupAuthorities);
            groups.remove(SecurityRealm.AUTHENTICATED_AUTHORITY2.getAuthority());
            for (String group : groups) {
                try {
                    realm.loadGroupByGroupname2(group, false);
                }
                catch (UsernameNotFoundException e) {
                    badGroups.add(group);
                }
            }
            if (groups.isEmpty()) {
                this.warning(response, "resolve-groups", Messages.LDAPSecurityRealm_GroupLookupNotPossible(), Messages.LDAPSecurityRealm_GroupLookupNotPossibleDetail());
            } else if (badGroups.isEmpty()) {
                this.ok(response, "resolve-groups", Messages.LDAPSecurityRealm_GroupLookupSuccessful(groups.size()), new Object[0]);
            } else {
                ArrayList<String> escaped = new ArrayList<String>(badGroups.size());
                for (String group : badGroups) {
                    escaped.add("<code>" + Util.escape((String)group) + "</code>");
                }
                this.warning(response, "resolve-groups", Messages.LDAPSecurityRealm_GroupLookupFailed(badGroups.size()), escaped, this.isAnyManagerBlank(realm) ? Messages.LDAPSecurityRealm_GroupLookupManagerDnRequired() : Messages.LDAPSecurityRealm_GroupLookupManagerDnPermissions(), Messages.LDAPSecurityRealm_GroupLookupSettingsCorrect());
            }
            if (potentialLockout) {
                response.append("<div>").append(Messages.LDAPSecurityRealm_LockoutHeader()).append("</div>");
                this.error(response, "lockout", likelyLockout ? Messages.LDAPSecurityRealm_PotentialLockout(user) : Messages.LDAPSecurityRealm_PotentialLockout2(user), new Object[0]);
            }
            return FormValidation.okWithMarkup((String)response.toString());
        }

        private boolean isAnyManagerBlank(LDAPSecurityRealm realm) {
            for (LDAPConfiguration configuration : realm.getConfigurations()) {
                if (!StringUtils.isBlank((String)configuration.getManagerDN())) continue;
                return true;
            }
            return false;
        }

        private void validateEmailAddress(LDAPConfiguration configuration, StringBuilder response, LdapUserDetails details, String testId) {
            Attributes attributes = DelegatedLdapUserDetails.getAttributes(details, null);
            Attribute attribute = attributes.get(configuration.getMailAddressAttributeName());
            if (attribute == null) {
                ArrayList<String> alternatives = new ArrayList<String>();
                for (Attribute attribute2 : Collections.list(attributes.getAll())) {
                    alternatives.add("<code>" + Util.escape((String)attribute2.getID()) + "</code>");
                }
                this.warning(response, testId, Messages.LDAPSecurityRealm_NoEmailAddress(), Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)configuration.getMailAddressAttributeName())), Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
            } else {
                try {
                    String mailAddress = (String)attribute.get();
                    if (StringUtils.isNotBlank((String)mailAddress)) {
                        this.ok(response, testId, Messages.LDAPSecurityRealm_UserEmail(Util.escape((String)mailAddress)), new Object[0]);
                    } else {
                        ArrayList<String> alternatives = new ArrayList<String>();
                        for (Attribute attribute3 : Collections.list(attributes.getAll())) {
                            alternatives.add("<code>" + Util.escape((String)attribute3.getID()) + "</code>");
                        }
                        this.warning(response, testId, Messages.LDAPSecurityRealm_EmptyEmailAddress(), Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)configuration.getMailAddressAttributeName())), Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
                    }
                }
                catch (NamingException e) {
                    ArrayList<String> alternatives = new ArrayList<String>();
                    for (Attribute attribute4 : Collections.list(attributes.getAll())) {
                        alternatives.add("<code>" + Util.escape((String)attribute4.getID()) + "</code>");
                    }
                    this.error(response, testId, Messages.LDAPSecurityRealm_CouldNotRetrieveEmailAddress(), Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)configuration.getMailAddressAttributeName())), Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
                }
            }
        }

        private void validateDisplayName(LDAPConfiguration configuration, StringBuilder response, LdapUserDetails details, String testId) {
            Attributes attributes = DelegatedLdapUserDetails.getAttributes(details, null);
            Attribute attribute = attributes.get(configuration.getDisplayNameAttributeName());
            if (attribute == null) {
                ArrayList<String> alternatives = new ArrayList<String>();
                for (Attribute attribute2 : Collections.list(attributes.getAll())) {
                    alternatives.add("<code>" + Util.escape((String)attribute2.getID()) + "</code>");
                }
                this.warning(response, testId, Messages.LDAPSecurityRealm_NoDisplayName(), Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)configuration.getDisplayNameAttributeName())), Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
            } else {
                try {
                    String displayName = (String)attribute.get();
                    if (displayName != null) {
                        this.ok(response, testId, Messages.LDAPSecurityRealm_UserDisplayName(Util.escape((String)displayName)), new Object[0]);
                    } else {
                        ArrayList<String> alternatives = new ArrayList<String>();
                        for (Attribute attribute3 : Collections.list(attributes.getAll())) {
                            alternatives.add("<code>" + Util.escape((String)attribute3.getID()) + "</code>");
                        }
                        this.warning(response, testId, Messages.LDAPSecurityRealm_EmptyDisplayName(), Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)configuration.getDisplayNameAttributeName())), Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
                    }
                }
                catch (NamingException e) {
                    ArrayList<String> alternatives = new ArrayList<String>();
                    for (Attribute attribute4 : Collections.list(attributes.getAll())) {
                        alternatives.add("<code>" + Util.escape((String)attribute4.getID()) + "</code>");
                    }
                    this.error(response, testId, Messages.LDAPSecurityRealm_CouldNotRetrieveDisplayName(), Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)configuration.getDisplayNameAttributeName())), Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
                }
            }
        }
    }

    public static final class AuthoritiesPopulatorImpl
    extends DefaultLdapAuthoritiesPopulator {
        String rolePrefix = "ROLE_";
        boolean convertToUpperCase = true;
        private GrantedAuthority defaultRole = null;

        public AuthoritiesPopulatorImpl(ContextSource contextSource, String groupSearchBase) {
            super(contextSource, Util.fixNull((String)groupSearchBase));
            super.setRolePrefix("");
            super.setConvertToUpperCase(false);
        }

        public Set<GrantedAuthority> getAdditionalRoles(DirContextOperations user, String username) {
            return Collections.singleton(SecurityRealm.AUTHENTICATED_AUTHORITY2);
        }

        public void setRolePrefix(String rolePrefix) {
            this.rolePrefix = rolePrefix;
        }

        public void setConvertToUpperCase(boolean convertToUpperCase) {
            this.convertToUpperCase = convertToUpperCase;
        }

        public Set<GrantedAuthority> getGroupMembershipRoles(String userDn, String username) {
            Set names = super.getGroupMembershipRoles(userDn, username);
            HashSet<GrantedAuthority> r = new HashSet<GrantedAuthority>(names.size() * 2);
            r.addAll(names);
            if (this.isGeneratingPrefixRoles()) {
                for (GrantedAuthority ga : names) {
                    String role = ga.getAuthority();
                    if (this.convertToUpperCase) {
                        role = role.toUpperCase();
                    }
                    r.add((GrantedAuthority)new SimpleGrantedAuthority(this.rolePrefix + role));
                }
            }
            return r;
        }

        public boolean isGeneratingPrefixRoles() {
            return StringUtils.isNotBlank((String)this.rolePrefix) || this.convertToUpperCase;
        }

        public boolean _isConvertToUpperCase() {
            return this.convertToUpperCase;
        }

        public String _getRolePrefix() {
            return this.rolePrefix;
        }

        public GrantedAuthority getDefaultRole() {
            return this.defaultRole;
        }

        public void setDefaultRole(String defaultRole) {
            super.setDefaultRole(defaultRole);
            this.defaultRole = new SimpleGrantedAuthority(defaultRole);
        }
    }

    private static final class WrappedAuthoritiesPopulator
    implements LdapAuthoritiesPopulator {
        private final LDAPGroupMembershipStrategy strategy;
        private final LdapAuthoritiesPopulator populator;

        private WrappedAuthoritiesPopulator(LDAPGroupMembershipStrategy strategy, LdapAuthoritiesPopulator populator) {
            this.strategy = strategy;
            this.populator = populator;
            strategy.setAuthoritiesPopulator(populator);
        }

        public Collection<? extends GrantedAuthority> getGrantedAuthorities(DirContextOperations userData, String username) {
            if (this.strategy.getAuthoritiesPopulator() != this.populator) {
                this.strategy.setAuthoritiesPopulator(this.populator);
            }
            return this.strategy.getGrantedAuthorities(userData, username);
        }
    }

    public static final class LdapAuthenticationProviderImpl
    extends LdapAuthenticationProvider {
        public LdapAuthenticationProviderImpl(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator, LDAPGroupMembershipStrategy groupMembershipStrategy) {
            super(authenticator, (LdapAuthoritiesPopulator)(groupMembershipStrategy != null ? new WrappedAuthoritiesPopulator(groupMembershipStrategy, authoritiesPopulator) : authoritiesPopulator));
        }
    }

    public static class LDAPUserDetailsService
    implements UserDetailsService {
        public final LdapUserSearch ldapSearch;
        public final LdapAuthoritiesPopulator authoritiesPopulator;
        public final LDAPGroupMembershipStrategy groupMembershipStrategy;
        public final String configurationId;
        private final LRUMap attributesCache = new LRUMap(32);

        LDAPUserDetailsService(LdapUserSearch ldapSearch, LdapAuthoritiesPopulator authoritiesPopulator, LDAPGroupMembershipStrategy groupMembershipStrategy, String configurationId) {
            this.ldapSearch = ldapSearch;
            this.authoritiesPopulator = authoritiesPopulator;
            this.groupMembershipStrategy = groupMembershipStrategy;
            this.configurationId = configurationId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        public DelegatedLdapUserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
            username = LDAPSecurityRealm.fixUsername(username);
            try (SetContextClassLoader sccl = new SetContextClassLoader();){
                LDAPSecurityRealm lDAPSecurityRealm;
                LDAPSecurityRealm ldapSecurityRealm;
                SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
                if (securityRealm instanceof LDAPSecurityRealm && (securityRealm.getSecurityComponents().userDetails2 == this || securityRealm.getSecurityComponents().userDetails2 instanceof DelegateLDAPUserDetailsService && ((DelegateLDAPUserDetailsService)securityRealm.getSecurityComponents().userDetails2).contains(this)) && (ldapSecurityRealm = (LDAPSecurityRealm)securityRealm).cache != null) {
                    CacheEntry cached;
                    Object object = ldapSecurityRealm;
                    synchronized (object) {
                        cached = ldapSecurityRealm.userDetailsCache != null ? (CacheEntry)ldapSecurityRealm.userDetailsCache.get(username) : null;
                    }
                    if (cached != null && cached.isValid()) {
                        object = (DelegatedLdapUserDetails)cached.getValue();
                        return object;
                    }
                }
                DirContextOperations ldapUser = this.ldapSearch.searchForUser(username);
                LdapUserDetailsImpl.Essence user = new LdapUserDetailsImpl.Essence(ldapUser);
                user.setUsername(username);
                user.setDn(ldapUser.getNameInNamespace());
                Attributes v = ldapUser.getAttributes();
                LRUMap lRUMap = this.attributesCache;
                synchronized (lRUMap) {
                    Attributes vv = (Attributes)this.attributesCache.get((Object)v);
                    if (vv == null) {
                        this.attributesCache.put((Object)v, (Object)v);
                    } else {
                        v = vv;
                    }
                }
                Collection<? extends GrantedAuthority> extraAuthorities = this.groupMembershipStrategy == null ? this.authoritiesPopulator.getGrantedAuthorities(ldapUser, username) : this.groupMembershipStrategy.getGrantedAuthorities(ldapUser, username);
                for (GrantedAuthority grantedAuthority : extraAuthorities) {
                    if (FORCE_GROUPNAME_LOWERCASE) {
                        user.addAuthority((GrantedAuthority)new SimpleGrantedAuthority(grantedAuthority.getAuthority().toLowerCase()));
                        continue;
                    }
                    user.addAuthority(grantedAuthority);
                }
                UserAttributesHelper.checkIfUserEnabled(username, v);
                UserAttributesHelper.checkIfAccountNonExpired(username, v);
                UserAttributesHelper.checkIfCredentialsNonExpired(username, v);
                UserAttributesHelper.checkIfAccountNonLocked(username, v);
                DelegatedLdapUserDetails ldapUserDetails = new DelegatedLdapUserDetails(user.createUserDetails(), this.configurationId, v);
                if (securityRealm instanceof LDAPSecurityRealm && (securityRealm.getSecurityComponents().userDetails2 == this || securityRealm.getSecurityComponents().userDetails2 instanceof DelegateLDAPUserDetailsService && ((DelegateLDAPUserDetailsService)securityRealm.getSecurityComponents().userDetails2).contains(this)) && (lDAPSecurityRealm = (LDAPSecurityRealm)securityRealm).cache != null) {
                    LDAPSecurityRealm lDAPSecurityRealm2 = lDAPSecurityRealm;
                    synchronized (lDAPSecurityRealm2) {
                        if (lDAPSecurityRealm.userDetailsCache == null) {
                            lDAPSecurityRealm.userDetailsCache = new CacheMap(lDAPSecurityRealm.cache.getSize());
                        }
                        lDAPSecurityRealm.userDetailsCache.put(username, new CacheEntry<DelegatedLdapUserDetails>(lDAPSecurityRealm.cache.getTtl(), lDAPSecurityRealm.updateUserDetails(ldapUserDetails, this.ldapSearch)));
                    }
                }
                DelegatedLdapUserDetails delegatedLdapUserDetails = ldapUserDetails;
                return delegatedLdapUserDetails;
            }
            catch (AuthenticationException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new AuthenticationServiceException("Failed to search LDAP for " + username, (Throwable)x);
            }
        }
    }

    private static class DelegateLDAPUserDetailsService
    implements UserDetailsService {
        private final List<LDAPUserDetailsService> delegates = new ArrayList<LDAPUserDetailsService>();

        public void addDelegate(LDAPUserDetailsService delegate) {
            this.delegates.add(delegate);
        }

        public boolean contains(LDAPUserDetailsService delegate) {
            return this.delegates.contains(delegate);
        }

        public DelegatedLdapUserDetails loadUserByUsername(String configurationId, String username) throws UsernameNotFoundException {
            for (LDAPUserDetailsService delegate : this.delegates) {
                if (!delegate.configurationId.equals(configurationId)) continue;
                try {
                    return delegate.loadUserByUsername(username);
                }
                catch (AuthenticationException e) {
                    LDAPConfiguration configuration = LDAPSecurityRealm._getConfigurationFor(delegate.configurationId);
                    LOGGER.log(Level.WARNING, String.format("Failed communication with ldap server %s (%s)", delegate.configurationId, configuration != null ? configuration.getServer() : "null"), e);
                    throw e;
                }
            }
            return null;
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
            UsernameNotFoundException lastUNFE = null;
            for (LDAPUserDetailsService delegate : this.delegates) {
                try {
                    return delegate.loadUserByUsername(username);
                }
                catch (AccountStatusException x) {
                    throw x;
                }
                catch (UsernameNotFoundException e) {
                    lastUNFE = e;
                }
                catch (AuthenticationException e) {
                    LDAPConfiguration configuration = LDAPSecurityRealm._getConfigurationFor(delegate.configurationId);
                    LDAPSecurityRealm.throwUnlessConfigIsIgnorable((Exception)((Object)new UserMayOrMayNotExistException2(e.toString(), (Throwable)e)), configuration);
                }
            }
            if (lastUNFE != null) {
                throw lastUNFE;
            }
            throw new UsernameNotFoundException(username);
        }
    }

    static class DelegatedLdapUserDetails
    implements LdapUserDetails,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final LdapUserDetails userDetails;
        @Nonnull
        private final String configurationId;
        @CheckForNull
        private final Attributes attributes;

        DelegatedLdapUserDetails(@Nonnull LdapUserDetails userDetails, @Nonnull String configurationId, @CheckForNull Attributes attributes) {
            this.userDetails = userDetails;
            this.configurationId = configurationId;
            this.attributes = attributes;
        }

        public String getDn() {
            return this.userDetails.getDn();
        }

        public Collection<? extends GrantedAuthority> getAuthorities() {
            return this.userDetails.getAuthorities();
        }

        public String getPassword() {
            return this.userDetails.getPassword();
        }

        public String getUsername() {
            return this.userDetails.getUsername();
        }

        public boolean isAccountNonExpired() {
            return this.userDetails.isAccountNonExpired();
        }

        public boolean isAccountNonLocked() {
            return this.userDetails.isAccountNonLocked();
        }

        public boolean isCredentialsNonExpired() {
            return this.userDetails.isCredentialsNonExpired();
        }

        public boolean isEnabled() {
            return this.userDetails.isEnabled();
        }

        public LdapUserDetails getUserDetails() {
            return this.userDetails;
        }

        @Nonnull
        public String getConfigurationId() {
            return this.configurationId;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Attributes getAttributes(LdapUserDetails details, @CheckForNull LdapUserSearch ldapUserSearch) {
            if (details instanceof DelegatedLdapUserDetails && ((DelegatedLdapUserDetails)details).attributes != null) {
                return ((DelegatedLdapUserDetails)details).attributes;
            }
            if (ldapUserSearch == null) return new BasicAttributes();
            try (SetContextClassLoader sccl = new SetContextClassLoader();){
                Attributes attributes = ldapUserSearch.searchForUser(details.getUsername()).getAttributes();
                return attributes;
            }
            catch (UsernameNotFoundException usernameNotFoundException) {
                // empty catch block
            }
            return new BasicAttributes();
        }

        public void eraseCredentials() {
            this.userDetails.eraseCredentials();
        }
    }

    static class DelegatedLdapAuthentication
    implements Authentication {
        private final Authentication delegate;
        private final Object principal;
        private final String configurationId;

        DelegatedLdapAuthentication(Authentication delegate, Object principal, String configurationId) {
            this.delegate = delegate;
            this.principal = principal;
            this.configurationId = configurationId;
        }

        public Collection<? extends GrantedAuthority> getAuthorities() {
            return this.delegate.getAuthorities();
        }

        public Object getCredentials() {
            return this.delegate.getCredentials();
        }

        public Object getDetails() {
            return this.delegate.getDetails();
        }

        public Object getPrincipal() {
            return this.principal;
        }

        public boolean isAuthenticated() {
            return this.delegate.isAuthenticated();
        }

        public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
            this.delegate.setAuthenticated(isAuthenticated);
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Authentication getDelegate() {
            return this.delegate;
        }

        public String getConfigurationId() {
            return this.configurationId;
        }
    }

    private class LDAPAuthenticationManager
    implements AuthenticationManager {
        private final List<ManagerEntry> delegates = new ArrayList<ManagerEntry>();
        private final DelegateLDAPUserDetailsService detailsService;

        private LDAPAuthenticationManager(DelegateLDAPUserDetailsService detailsService) {
            this.detailsService = detailsService;
        }

        private void addDelegate(AuthenticationManager delegate, String configurationId, LdapUserSearch ldapUserSearch) {
            this.delegates.add(new ManagerEntry(delegate, configurationId, ldapUserSearch));
        }

        /*
         * Exception decompiling
         */
        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private class ManagerEntry {
            final AuthenticationManager delegate;
            final String configurationId;
            final LdapUserSearch ldapUserSearch;

            ManagerEntry(AuthenticationManager delegate, String configurationId, LdapUserSearch ldapUserSearch) {
                this.delegate = delegate;
                this.configurationId = configurationId;
                this.ldapUserSearch = ldapUserSearch;
            }
        }
    }

    private static class GroupDetailsMapper
    implements LdapEntryMapper<GroupDetailsImpl> {
        private GroupDetailsMapper() {
        }

        @Override
        public GroupDetailsImpl mapAttributes(String dn, Attributes attributes) throws NamingException {
            LdapName name = new LdapName(dn);
            String groupName = LDAPSecurityRealm.fixGroupname(GroupDetailsMapper.extractGroupName(name, attributes));
            return new GroupDetailsImpl(dn, groupName);
        }

        static String extractGroupName(LdapName name, Attributes attributes) throws NamingException {
            String CN = "cn";
            boolean isCN = false;
            String groupName = String.valueOf(name.getRdn(name.size() - 1).getValue());
            Attribute cnAttribute = attributes.get("cn");
            if (cnAttribute != null) {
                NamingEnumeration<?> e = cnAttribute.getAll();
                while (e.hasMore() && !isCN) {
                    groupName = e.next().toString();
                    isCN = true;
                    if (!e.hasMore()) continue;
                    LOGGER.log(Level.FINE, "The group " + name.getRdns() + " has more than one cn value. The first one  (" + groupName + ") has been assigned as external group name");
                }
            } else {
                LOGGER.log(Level.SEVERE, "The group {0} has not defined a cn attribute. The last value from the dn ({1}) has been assigned as external group name", new Object[]{name.getRdns(), groupName});
            }
            return groupName;
        }
    }

    private static class GroupDetailsImpl
    extends GroupDetails {
        private final String dn;
        private final String name;
        private final Set<String> members;

        public GroupDetailsImpl(String dn, String name) {
            this(dn, name, null);
        }

        public GroupDetailsImpl(String dn, String name, Set<String> members) {
            this.dn = dn;
            this.name = name;
            this.members = members;
        }

        public String getDn() {
            return this.dn;
        }

        public String getName() {
            return this.name;
        }

        public Set<String> getMembers() {
            return this.members;
        }
    }
}

